/*
 * Decompiled with CFR 0.152.
 */
package com.zenofx.classguard.bootstrap;

public class Base32 {
    private static final String base32Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final byte[] base32Lookup = new byte[]{26, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25};

    public static String encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer((byArray.length * 8 + 4) / 5);
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n++] & 0xFF;
            stringBuffer.append(base32Chars.charAt(n2 >> 3));
            int n3 = (n2 & 7) << 2;
            if (n >= byArray.length) {
                stringBuffer.append(base32Chars.charAt(n3));
                break;
            }
            n2 = byArray[n++] & 0xFF;
            stringBuffer.append(base32Chars.charAt(n3 | n2 >> 6));
            stringBuffer.append(base32Chars.charAt(n2 >> 1 & 0x1F));
            n3 = (n2 & 1) << 4;
            if (n >= byArray.length) {
                stringBuffer.append(base32Chars.charAt(n3));
                break;
            }
            n2 = byArray[n++] & 0xFF;
            stringBuffer.append(base32Chars.charAt(n3 | n2 >> 4));
            n3 = (n2 & 0xF) << 1;
            if (n >= byArray.length) {
                stringBuffer.append(base32Chars.charAt(n3));
                break;
            }
            n2 = byArray[n++] & 0xFF;
            stringBuffer.append(base32Chars.charAt(n3 | n2 >> 7));
            stringBuffer.append(base32Chars.charAt(n2 >> 2 & 0x1F));
            n3 = (n2 & 3) << 3;
            if (n >= byArray.length) {
                stringBuffer.append(base32Chars.charAt(n3));
                break;
            }
            n2 = byArray[n++] & 0xFF;
            stringBuffer.append(base32Chars.charAt(n3 | n2 >> 5));
            stringBuffer.append(base32Chars.charAt(n2 & 0x1F));
        }
        return stringBuffer.toString();
    }

    public static byte[] decodeUserInput(String string) throws IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (Character.isWhitespace(stringBuffer.charAt(n)) || stringBuffer.charAt(n) == '-') {
                stringBuffer.deleteCharAt(n);
                continue;
            }
            ++n;
        }
        return Base32.decode(stringBuffer.toString());
    }

    public static byte[] decode(String string) throws IllegalArgumentException {
        byte[] byArray = new byte[string.length() * 5 / 8];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        byte by = 0;
        while (n3 < string.length()) {
            int n4;
            if ((n4 = string.charAt(n3++) - 50) < 0 || n4 >= base32Lookup.length) {
                throw new IllegalArgumentException();
            }
            byte by2 = base32Lookup[n4];
            if (by2 == -1) {
                throw new IllegalArgumentException();
            }
            switch (n) {
                case 0: {
                    by = (byte)(by2 << 3);
                    n = 5;
                    break;
                }
                case 5: {
                    byArray[n2++] = (byte)(by | by2 >> 2);
                    by = (byte)((by2 & 3) << 6);
                    n = 2;
                    break;
                }
                case 2: {
                    by = (byte)(by | (byte)(by2 << 1));
                    n = 7;
                    break;
                }
                case 7: {
                    byArray[n2++] = (byte)(by | by2 >> 4);
                    by = (byte)((by2 & 0xF) << 4);
                    n = 4;
                    break;
                }
                case 4: {
                    byArray[n2++] = (byte)(by | by2 >> 1);
                    by = (byte)((by2 & 1) << 7);
                    n = 1;
                    break;
                }
                case 1: {
                    by = (byte)(by | (byte)(by2 << 2));
                    n = 6;
                    break;
                }
                case 6: {
                    byArray[n2++] = (byte)(by | by2 >> 3);
                    by = (byte)((by2 & 7) << 5);
                    n = 3;
                    break;
                }
                case 3: {
                    byArray[n2++] = (byte)(by | by2);
                    n = 0;
                }
            }
        }
        return byArray;
    }
}

