/*
 * Decompiled with CFR 0.152.
 */
package com.zenofx.classguard.bootstrap;

import com.zenofx.classguard.bootstrap.Base32;
import com.zenofx.classguard.bootstrap.LicenseInterface;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.SignatureException;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class ClassGuard
extends ClassLoader {
    private static Boolean nativeInit = false;
    private static Boolean licenseInit = false;
    private static boolean initSuccess = false;
    private static final Manifest mf;
    private LicenseInterface licenseAdapter;

    public ClassGuard(ClassLoader classLoader) {
        super(classLoader);
        String string = ClassGuard.getManifestAttribute("ClassGuard-License-Interface");
        if (string == null || string.length() == 0) {
            string = "com.zenofx.classguard.bootstrap.LicenseAdapter";
        }
        try {
            Class<?> clazz = Class.forName(string, true, classLoader);
            this.licenseAdapter = (LicenseInterface)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("ClassGuard license adapter not found");
        }
    }

    static String getManifestAttribute(String string) {
        if (mf == null) {
            return null;
        }
        return mf.getMainAttributes().getValue(string);
    }

    LicenseInterface getLicenseAdapter() {
        return this.licenseAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initLicense(String string) throws SignatureException, IOException {
        String string2;
        this.initNative();
        int n = string.indexOf(10);
        if (n > 0 && string.charAt(n - 1) != '\r') {
            string = string.replace("\n", "\r\n");
        }
        if ((n = string.lastIndexOf("Signature=")) < 0) {
            throw new SignatureException("No signature in license file");
        }
        byte[] byArray = null;
        try {
            string2 = string.substring(n + "Signature".length() + 1, string.length() - 2);
            byArray = Base32.decode(string2);
        }
        catch (Exception exception) {
            throw new SignatureException("Invalid signature in license file");
        }
        string2 = string.substring(0, n);
        Boolean bl = licenseInit;
        synchronized (bl) {
            if (!this.initLicense(string2, byArray)) {
                throw new SignatureException("Error in license file");
            }
            licenseInit = true;
        }
    }

    public String getSystemId() throws IOException {
        this.initNative();
        return Base32.encode((this.getUsername() + "@" + this.getHostname()).getBytes("UTF-8"));
    }

    private static File copyStreamToTemp(InputStream inputStream, String string) throws IOException {
        String string2 = System.getProperty("classguard.tmpdir");
        File file = null;
        if (string2 != null && string2.length() > 0) {
            file = new File(string2);
        }
        File file2 = File.createTempFile("cg-", string, file);
        file2.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[512];
        int n = 0;
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        fileOutputStream.close();
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadFile(String string) throws IOException {
        try (InputStream inputStream = null;){
            inputStream = this.getParent().getResourceAsStream(string);
            if (inputStream == null) {
                throw new IOException("Couldn't load " + string);
            }
            byte[] byArray = ClassGuard.readStream(inputStream);
            return byArray;
        }
    }

    public static byte[] readStream(InputStream inputStream) throws IOException {
        return ClassGuard.readStream(inputStream, inputStream.available());
    }

    public static byte[] readStream(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = 0; i != byArray.length; i += n2) {
            n2 = inputStream.read(byArray, i, byArray.length - i);
            if (n2 >= 0) continue;
            throw new IOException("Unexpected end of stream");
        }
        return byArray;
    }

    public static void sign(File file) throws InterruptedException, IOException {
        Runtime.getRuntime().exec(new String[]{"/usr/bin/codesign", "-s", "-", file.getAbsolutePath()}).waitFor();
    }

    private native Class<?> decryptClass(String var1, byte[] var2, int var3) throws ClassNotFoundException;

    private final native byte[] getCryptedResource(byte[] var1, int var2);

    private native boolean initLicense(String var1, byte[] var2);

    public final native String getAttribute(String var1);

    public final native String getHostname();

    public final native String getUsername();

    @Override
    public Class<?> findClass(String string) throws ClassNotFoundException {
        String string2 = string.replace('.', '/') + ".class" + "x";
        URL uRL = this.getParent().getResource(string2);
        if (uRL == null) {
            throw new ClassNotFoundException();
        }
        byte[] byArray = null;
        try {
            byArray = this.loadFile(string2);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Couldn't load encrypted class", iOException);
        }
        return this.findClassInternal(string, byArray);
    }

    public Class<?> findClassInternal(String string, byte[] byArray) throws ClassNotFoundException {
        try {
            this.initNative();
        }
        catch (Exception exception) {
            throw new RuntimeException("Couldn't load native ClassGuard library", exception);
        }
        try {
            this.initDefaultLicense();
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("Couldn't load default license", exception);
        }
        Class<?> clazz = this.decryptClass(string.replace('.', '/'), byArray, byArray.length);
        if (clazz == null) {
            throw new ClassNotFoundException("Couldn't decrypt class");
        }
        return clazz;
    }

    @Override
    public URL getResource(final String string) {
        URL uRL = this.getParent().getResource(string);
        if (uRL != null) {
            return uRL;
        }
        final byte[] byArray = this.getCryptedResource(string);
        if (byArray == null) {
            return null;
        }
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            return new URL(null, "classguard:" + string, new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL uRL) {
                    return new URLConnection(uRL){

                        @Override
                        public void connect() {
                        }

                        @Override
                        public InputStream getInputStream() {
                            return byteArrayInputStream;
                        }

                        @Override
                        public String getContentType() {
                            return 1.getFileNameMap().getContentTypeFor(string);
                        }

                        @Override
                        public int getContentLength() {
                            return byArray.length;
                        }
                    };
                }
            });
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = this.getParent().getResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        byte[] byArray = this.getCryptedResource(string);
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    private byte[] getCryptedResource(String string) {
        string = string + "x";
        URL uRL = this.getParent().getResource(string);
        if (uRL != null) {
            try {
                byte[] byArray = this.loadFile(string);
                return this.getCryptedResource(byArray, byArray.length);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initDefaultLicense() throws SignatureException, UnsupportedEncodingException, IOException {
        Object object;
        if (licenseInit.booleanValue()) return;
        String string = null;
        String string2 = ClassGuard.getManifestAttribute("ClassGuard-Product-Name");
        if (string2 != null) {
            string = this.licenseAdapter.loadLicense(string2);
        }
        if (string == null) {
            try {
                object = this.loadFile("META-INF/default.license");
                string = new String((byte[])object, "UTF-8");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (string == null) return;
        Boolean bl = licenseInit;
        object = bl;
        synchronized (bl) {
            if (licenseInit.booleanValue()) return;
            this.initLicense(string);
            // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initNative() throws IOException {
        if (!nativeInit.booleanValue()) {
            String string = System.getProperty("os.arch").toLowerCase();
            if (string.charAt(0) == 'i' && string.endsWith("86")) {
                string = "x86";
            } else if (string.equals("amd64") || string.equals("x86_64")) {
                string = "x64";
            } else if (string.equals("aarch64")) {
                string = "arm64";
            }
            String string2 = System.getProperty("os.name").toLowerCase();
            String string3 = ".so";
            if (string2.startsWith("windows")) {
                string3 = ".dll";
                string2 = "win";
            } else if (string2.startsWith("mac os x")) {
                string3 = ".jnilib";
                string2 = "osx";
            }
            String string4 = ClassGuard.getManifestAttribute("ClassGuard-External-Lib-Mode");
            String string5 = "cg_" + string + "_" + string2;
            Boolean bl = nativeInit;
            synchronized (bl) {
                if (!nativeInit.booleanValue()) {
                    if ("true".equals(string4)) {
                        if (string2.equals("win")) {
                            string5 = "lib" + string5;
                        }
                        try {
                            System.loadLibrary(string5);
                        }
                        catch (Throwable throwable) {
                            throw new IOException("External native library not found");
                        }
                    }
                    String string6 = "lib/lib" + string5 + string3 + "x";
                    InputStream inputStream = this.getParent().getResourceAsStream(string6);
                    if (inputStream == null) {
                        throw new IOException("Native library not found");
                    }
                    File file = ClassGuard.copyStreamToTemp(inputStream, string3);
                    if (string.equals("arm64") && string2.equals("osx")) {
                        try {
                            ClassGuard.sign(file);
                        }
                        catch (Exception exception) {
                            throw new IOException("Couldn't load native arm64 library");
                        }
                    }
                    System.load(file.getAbsolutePath());
                    nativeInit = true;
                    initSuccess = true;
                }
            }
        }
        if (!initSuccess) {
            throw new IOException("Native library not loaded");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        ClassGuard classGuard = new ClassGuard(ClassGuard.class.getClassLoader());
        Thread.currentThread().setContextClassLoader(classGuard);
        String string = ClassGuard.getManifestAttribute("ClassGuard-Main-Class");
        string = System.getProperty("classguard.main.class", string);
        Class<?> clazz = null;
        LicenseInterface licenseInterface = classGuard.getLicenseAdapter();
        try {
            string = string.replace('/', '.');
            try {
                clazz = Class.forName(string, true, classGuard);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string2 = ClassGuard.getManifestAttribute("ClassGuard-Product-Name");
                if (string2 == null) {
                    licenseInterface.error("Start class " + string + " not found.");
                    System.exit(1);
                } else {
                    String string3 = licenseInterface.requestLicense(classGuard, string2);
                    if (string3 == null) {
                        System.exit(1);
                    }
                    licenseInterface.storeLicense(string2, string3);
                }
                clazz = Class.forName(string, true, classGuard);
            }
        }
        catch (Throwable throwable) {
            licenseInterface.error(throwable.getMessage());
            System.exit(1);
        }
        Method method = clazz.getDeclaredMethod("main", stringArray.getClass());
        method.invoke(null, new Object[]{stringArray});
    }

    static {
        try {
            URL uRL = ClassGuard.class.getProtectionDomain().getCodeSource().getLocation();
            JarInputStream jarInputStream = new JarInputStream(uRL.openStream());
            mf = jarInputStream.getManifest();
            jarInputStream.close();
        }
        catch (Exception exception) {
            throw new RuntimeException("Couldn't load ClassGuard manifest file", exception);
        }
    }
}

