/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.expressions;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.sf.dynamicreports.report.builder.datatype.DataTypes;
import net.sf.dynamicreports.report.builder.expression.AbstractComplexExpression;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;

public class CurrentDateExpression
extends AbstractComplexExpression<String> {
    private static final long serialVersionUID = 10000L;
    private String datePattern;

    public CurrentDateExpression(DRIExpression<String> currentDateExpression, String datePattern) {
        this.datePattern = datePattern;
        this.addExpression(currentDateExpression);
    }

    @Override
    public String evaluate(List<?> values, ReportParameters reportParameters) {
        String pattern = (String)values.get(0);
        Locale locale = reportParameters.getLocale();
        MessageFormat format = new MessageFormat(pattern, locale);
        String date = this.datePattern == null ? DataTypes.dateType().valueToString(new Date(), locale) : new SimpleDateFormat(this.datePattern, locale).format(new Date());
        String result = format.format(new Object[]{date});
        return result;
    }
}

