/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.jasper.transformation;

import net.sf.dynamicreports.design.definition.style.DRIDesignBaseStyle;
import net.sf.dynamicreports.design.definition.style.DRIDesignBorder;
import net.sf.dynamicreports.design.definition.style.DRIDesignConditionalStyle;
import net.sf.dynamicreports.design.definition.style.DRIDesignFont;
import net.sf.dynamicreports.design.definition.style.DRIDesignPadding;
import net.sf.dynamicreports.design.definition.style.DRIDesignParagraph;
import net.sf.dynamicreports.design.definition.style.DRIDesignPen;
import net.sf.dynamicreports.design.definition.style.DRIDesignStyle;
import net.sf.dynamicreports.design.definition.style.DRIDesignTabStop;
import net.sf.dynamicreports.jasper.exception.JasperDesignException;
import net.sf.dynamicreports.jasper.transformation.AbstractExpressionTransform;
import net.sf.dynamicreports.jasper.transformation.ConstantTransform;
import net.sf.dynamicreports.jasper.transformation.JasperTransformAccessor;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.type.ModeEnum;

public class StyleTransform {
    private final JasperTransformAccessor accessor;

    public StyleTransform(JasperTransformAccessor accessor) {
        this.accessor = accessor;
    }

    public void transform() {
        for (DRIDesignStyle style : this.accessor.getReport().getStyles()) {
            this.addStyle(style);
        }
    }

    private void addStyle(DRIDesignStyle style) {
        try {
            this.accessor.getDesign().addStyle((JRStyle)this.style(style));
        }
        catch (JRException e) {
            throw new JasperDesignException("Registration failed for style \"" + style.getName() + "\"", e);
        }
    }

    private JRDesignStyle style(DRIDesignStyle style) {
        JRDesignStyle jrStyle = new JRDesignStyle();
        this.abstractStyle((JRBaseStyle)jrStyle, style);
        jrStyle.setName(style.getName());
        DRIDesignStyle parentStyle = style.getParentStyle();
        if (parentStyle != null) {
            this.style(parentStyle);
            jrStyle.setParentStyleNameReference(parentStyle.getName());
        }
        for (DRIDesignConditionalStyle dRIDesignConditionalStyle : style.getConditionalStyles()) {
            jrStyle.addConditionalStyle((JRConditionalStyle)this.conditionalStyle(dRIDesignConditionalStyle));
        }
        return jrStyle;
    }

    private JRDesignConditionalStyle conditionalStyle(DRIDesignConditionalStyle conditionalStyle) {
        JRDesignConditionalStyle jrConditionalStyle = new JRDesignConditionalStyle();
        this.abstractStyle((JRBaseStyle)jrConditionalStyle, conditionalStyle);
        AbstractExpressionTransform expressionTransform = this.accessor.getExpressionTransform(conditionalStyle.getDataset());
        JRDesignExpression expression = expressionTransform.getExpression(conditionalStyle.getConditionExpression());
        jrConditionalStyle.setConditionExpression((JRExpression)expression);
        return jrConditionalStyle;
    }

    private void abstractStyle(JRBaseStyle baseStyle, DRIDesignBaseStyle style) {
        baseStyle.setForecolor(style.getForegroundColor());
        baseStyle.setBackcolor(style.getBackgroundColor());
        if (style.getBackgroundColor() != null) {
            baseStyle.setMode(ModeEnum.OPAQUE);
        }
        baseStyle.setRadius(style.getRadius());
        baseStyle.setScaleImage(ConstantTransform.imageScale(style.getImageScale()));
        baseStyle.setHorizontalTextAlign(ConstantTransform.horizontalTextAlignment(style.getHorizontalTextAlignment()));
        baseStyle.setVerticalTextAlign(ConstantTransform.verticalTextAlignment(style.getVerticalTextAlignment()));
        baseStyle.setHorizontalImageAlign(ConstantTransform.horizontalImageAlignment(style.getHorizontalImageAlignment()));
        baseStyle.setVerticalImageAlign(ConstantTransform.verticalImageAlignment(style.getVerticalImageAlignment()));
        this.border(baseStyle.getLineBox(), style.getBorder());
        this.padding(baseStyle.getLineBox(), style.getPadding());
        this.font(baseStyle, style.getFont());
        baseStyle.setRotation(ConstantTransform.rotation(style.getRotation()));
        baseStyle.setPattern(style.getPattern());
        baseStyle.setMarkup(ConstantTransform.markup(style.getMarkup()));
        baseStyle.setBlankWhenNull(Boolean.TRUE);
        this.paragraph(baseStyle.getParagraph(), style.getParagraph());
        this.pen(baseStyle.getLinePen(), style.getLinePen());
    }

    private void paragraph(JRParagraph jrParagraph, DRIDesignParagraph paragraph) {
        jrParagraph.setLineSpacing(ConstantTransform.lineSpacing(paragraph.getLineSpacing()));
        jrParagraph.setLineSpacingSize(paragraph.getLineSpacingSize());
        jrParagraph.setFirstLineIndent(paragraph.getFirstLineIndent());
        jrParagraph.setLeftIndent(paragraph.getLeftIndent());
        jrParagraph.setRightIndent(paragraph.getRightIndent());
        jrParagraph.setSpacingBefore(paragraph.getSpacingBefore());
        jrParagraph.setSpacingAfter(paragraph.getSpacingAfter());
        jrParagraph.setTabStopWidth(paragraph.getTabStopWidth());
        for (DRIDesignTabStop tabStop : paragraph.getTabStops()) {
            TabStop jrTabStop = new TabStop();
            jrTabStop.setPosition(tabStop.getPosition());
            jrTabStop.setAlignment(ConstantTransform.tabStopAlignment(tabStop.getAlignment()));
            jrParagraph.addTabStop(jrTabStop);
        }
    }

    protected void pen(JRPen jrPen, DRIDesignPen pen) {
        if (pen == null) {
            return;
        }
        jrPen.setLineColor(pen.getLineColor());
        jrPen.setLineStyle(ConstantTransform.lineStyle(pen.getLineStyle()));
        jrPen.setLineWidth(pen.getLineWidth());
    }

    private void border(JRLineBox lineBox, DRIDesignBorder border) {
        if (border == null) {
            return;
        }
        this.pen((JRPen)lineBox.getLeftPen(), border.getLeftPen());
        this.pen((JRPen)lineBox.getRightPen(), border.getRightPen());
        this.pen((JRPen)lineBox.getTopPen(), border.getTopPen());
        this.pen((JRPen)lineBox.getBottomPen(), border.getBottomPen());
    }

    private void padding(JRLineBox lineBox, DRIDesignPadding padding) {
        if (padding == null) {
            return;
        }
        lineBox.setLeftPadding(padding.getLeft());
        lineBox.setRightPadding(padding.getRight());
        lineBox.setTopPadding(padding.getTop());
        lineBox.setBottomPadding(padding.getBottom());
    }

    private void font(JRBaseStyle baseStyle, DRIDesignFont font) {
        if (font == null) {
            return;
        }
        baseStyle.setFontName(font.getFontName());
        baseStyle.setBold(font.getBold());
        baseStyle.setItalic(font.getItalic());
        baseStyle.setFontSize(font.getFontSize() == null ? null : Float.valueOf(font.getFontSize().floatValue()));
        baseStyle.setStrikeThrough(font.getStrikeThrough());
        baseStyle.setUnderline(font.getUnderline());
        baseStyle.setPdfFontName(font.getPdfFontName());
        baseStyle.setPdfEncoding(font.getPdfEncoding());
        baseStyle.setPdfEmbedded(font.getPdfEmbedded());
    }

    protected JRBaseFont font(DRIDesignFont font) {
        if (font == null) {
            return null;
        }
        JRBaseFont jrFont = new JRBaseFont();
        jrFont.setFontName(font.getFontName());
        jrFont.setBold(font.getBold());
        jrFont.setItalic(font.getItalic());
        jrFont.setFontSize(font.getFontSize() == null ? null : Float.valueOf(font.getFontSize().floatValue()));
        jrFont.setStrikeThrough(font.getStrikeThrough());
        jrFont.setUnderline(font.getUnderline());
        jrFont.setPdfFontName(font.getPdfFontName());
        jrFont.setPdfEncoding(font.getPdfEncoding());
        jrFont.setPdfEmbedded(font.getPdfEmbedded());
        return jrFont;
    }

    protected JRDesignStyle getStyle(DRIDesignStyle style) {
        if (style == null) {
            return null;
        }
        if (!this.accessor.getDesign().getStylesMap().containsKey(style.getName())) {
            throw new JasperDesignException("Style \"" + style.getName() + "\" is not registered");
        }
        return (JRDesignStyle)this.accessor.getDesign().getStylesMap().get(style.getName());
    }
}

