/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.base;

import net.sf.dynamicreports.report.definition.DRIParameter;
import org.apache.commons.lang3.Validate;

public class DRParameter<T>
implements DRIParameter<T> {
    private static final long serialVersionUID = 10000L;
    private String name;
    private Class<T> valueClass;
    private T value;

    public DRParameter(String name, T value) {
        Validate.notEmpty((CharSequence)name, (String)"name must not be empty", (Object[])new Object[0]);
        Validate.notNull(value, (String)"value must not be null", (Object[])new Object[0]);
        this.name = name;
        this.valueClass = value.getClass();
        this.value = value;
    }

    public DRParameter(String name, Class<T> valueClass) {
        Validate.notEmpty((CharSequence)name, (String)"name must not be empty", (Object[])new Object[0]);
        Validate.notNull(valueClass, (String)"valueClass must not be null", (Object[])new Object[0]);
        this.name = name;
        this.valueClass = valueClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<T> getValueClass() {
        return this.valueClass;
    }

    @Override
    public T getValue() {
        return this.value;
    }
}

