/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.base.chart.plot;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.dynamicreports.report.constant.Orientation;
import net.sf.dynamicreports.report.definition.chart.plot.DRIBasePlot;
import org.apache.commons.lang3.Validate;

public abstract class AbstractBasePlot
implements DRIBasePlot {
    private static final long serialVersionUID = 10000L;
    private Orientation orientation;
    private List<Color> seriesColors;
    private Map<String, Color> seriesColorsByName;

    protected AbstractBasePlot() {
        this.init();
    }

    protected void init() {
        this.seriesColors = new ArrayList<Color>();
        this.seriesColorsByName = new HashMap<String, Color>();
    }

    @Override
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public void addSeriesColor(Color color) {
        Validate.notNull((Object)color, (String)"color must not be null", (Object[])new Object[0]);
        this.seriesColors.add(color);
    }

    @Override
    public List<Color> getSeriesColors() {
        return this.seriesColors;
    }

    public void setSeriesColors(List<Color> seriesColors) {
        Validate.notNull(seriesColors, (String)"seriesColors must not be null", (Object[])new Object[0]);
        Validate.noNullElements(seriesColors, (String)"seriesColors must not contain null color", (Object[])new Object[0]);
        this.seriesColors = seriesColors;
    }

    public void addSeriesColorByName(String seriesName, Color color) {
        Validate.notNull((Object)seriesName, (String)"seriesName must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)color, (String)"color must not be null", (Object[])new Object[0]);
        this.seriesColorsByName.put(seriesName, color);
    }

    @Override
    public Map<String, Color> getSeriesColorsByName() {
        return this.seriesColorsByName;
    }

    public void setSeriesColorsByName(Map<String, Color> seriesColorsByName) {
        Validate.notNull(seriesColorsByName, (String)"seriesColorsByName must not be null", (Object[])new Object[0]);
        this.seriesColorsByName = seriesColorsByName;
    }
}

