/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.chart;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class SeriesOrderByNamesComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 10000L;
    private List<String> seriesNames;

    public SeriesOrderByNamesComparator(List<String> seriesNames) {
        Validate.notNull(seriesNames, (String)"seriesNames must not be null", (Object[])new Object[0]);
        Validate.noNullElements(seriesNames, (String)"seriesNames must not contains null seriesName", (Object[])new Object[0]);
        this.seriesNames = seriesNames;
    }

    @Override
    public int compare(String o1, String o2) {
        String row2;
        String row1;
        if (StringUtils.countMatches((CharSequence)o1, (CharSequence)"-{group-series}-") == 1 && StringUtils.countMatches((CharSequence)o2, (CharSequence)"-{group-series}-") == 1) {
            String group2;
            String group1 = StringUtils.substringBefore((String)o1, (String)"-{group-series}-");
            int compare = group1.compareTo(group2 = StringUtils.substringBefore((String)o2, (String)"-{group-series}-"));
            if (compare != 0) {
                return compare;
            }
            row1 = StringUtils.substringAfter((String)o1, (String)"-{group-series}-");
            row2 = StringUtils.substringAfter((String)o2, (String)"-{group-series}-");
        } else {
            row1 = o1;
            row2 = o2;
        }
        int index1 = this.seriesNames.indexOf(row1);
        int index2 = this.seriesNames.indexOf(row2);
        if (index1 < 0 && index2 < 0) {
            return row1.compareTo(row2);
        }
        if (index1 == index2) {
            return 0;
        }
        if (index1 < 0) {
            return index1 * -1;
        }
        if (index2 < 0) {
            return index2;
        }
        return index1 - index2;
    }
}

