/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.component;

import java.util.Date;
import net.sf.dynamicreports.report.base.DRGroup;
import net.sf.dynamicreports.report.base.component.DRTextField;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.VariableBuilder;
import net.sf.dynamicreports.report.builder.component.HyperLinkComponentBuilder;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.constant.ComponentDimensionType;
import net.sf.dynamicreports.report.constant.Evaluation;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.constant.HorizontalTextAlignment;
import net.sf.dynamicreports.report.constant.Markup;
import net.sf.dynamicreports.report.constant.TextAdjust;
import net.sf.dynamicreports.report.definition.DRIField;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.expression.DRIValueFormatter;
import org.apache.commons.lang3.Validate;

public class TextFieldBuilder<T>
extends HyperLinkComponentBuilder<TextFieldBuilder<T>, DRTextField<T>> {
    private static final long serialVersionUID = 10000L;

    protected TextFieldBuilder() {
        super(new DRTextField());
    }

    public TextFieldBuilder<T> setText(VariableBuilder<T> variable) {
        Validate.notNull(variable, (String)"variable must not be null", (Object[])new Object[0]);
        ((DRTextField)this.getObject()).setValueExpression(variable.getVariable());
        return this;
    }

    public TextFieldBuilder<T> setText(FieldBuilder<T> field) {
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        ((DRTextField)this.getObject()).setValueExpression(field.getField());
        if (((DRTextField)this.getObject()).getDataType() == null) {
            ((DRTextField)this.getObject()).setDataType(field.getField().getDataType());
        }
        return this;
    }

    public TextFieldBuilder<T> setText(DRIExpression<T> textExpression) {
        ((DRTextField)this.getObject()).setValueExpression(textExpression);
        if (textExpression instanceof DRIField && ((DRTextField)this.getObject()).getDataType() == null) {
            ((DRTextField)this.getObject()).setDataType(((DRIField)textExpression).getDataType());
        }
        return this;
    }

    public TextFieldBuilder<T> setText(String text) {
        ((DRTextField)this.getObject()).setValueExpression(Expressions.text(text));
        return this;
    }

    public TextFieldBuilder<T> setText(Number number) {
        ((DRTextField)this.getObject()).setValueExpression(Expressions.number(number));
        return this;
    }

    public TextFieldBuilder<T> setText(Date date) {
        ((DRTextField)this.getObject()).setValueExpression(Expressions.date(date));
        return this;
    }

    public TextFieldBuilder<T> setPattern(String pattern) {
        ((DRTextField)this.getObject()).setPattern(pattern);
        return this;
    }

    public TextFieldBuilder<T> setPattern(DRIExpression<String> patternExpression) {
        ((DRTextField)this.getObject()).setPatternExpression(patternExpression);
        return this;
    }

    @Deprecated
    public TextFieldBuilder<T> setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment != null) {
            ((DRTextField)this.getObject()).setHorizontalTextAlignment(HorizontalTextAlignment.valueOf(horizontalAlignment.name()));
        } else {
            ((DRTextField)this.getObject()).setHorizontalTextAlignment(null);
        }
        return this;
    }

    public TextFieldBuilder<T> setHorizontalTextAlignment(HorizontalTextAlignment horizontalTextAlignment) {
        ((DRTextField)this.getObject()).setHorizontalTextAlignment(horizontalTextAlignment);
        return this;
    }

    public TextFieldBuilder<T> setValueFormatter(DRIValueFormatter<?, ? super T> valueFormatter) {
        ((DRTextField)this.getObject()).setValueFormatter(valueFormatter);
        return this;
    }

    public TextFieldBuilder<T> setDataType(DRIDataType<? super T, T> dataType) {
        ((DRTextField)this.getObject()).setDataType(dataType);
        return this;
    }

    public TextFieldBuilder<T> setColumns(Integer columns) {
        ((DRTextField)this.getObject()).setColumns(columns);
        return this;
    }

    public TextFieldBuilder<T> setFixedColumns(Integer columns) {
        ((DRTextField)this.getObject()).setColumns(columns);
        ((DRTextField)this.getObject()).setWidthType(ComponentDimensionType.FIXED);
        return this;
    }

    public TextFieldBuilder<T> setMinColumns(Integer columns) {
        ((DRTextField)this.getObject()).setColumns(columns);
        ((DRTextField)this.getObject()).setWidthType(ComponentDimensionType.EXPAND);
        return this;
    }

    public TextFieldBuilder<T> setRows(Integer rows) {
        ((DRTextField)this.getObject()).setRows(rows);
        return this;
    }

    public TextFieldBuilder<T> setFixedRows(Integer rows) {
        ((DRTextField)this.getObject()).setRows(rows);
        ((DRTextField)this.getObject()).setHeightType(ComponentDimensionType.FIXED);
        return this;
    }

    public TextFieldBuilder<T> setMinRows(Integer rows) {
        ((DRTextField)this.getObject()).setRows(rows);
        ((DRTextField)this.getObject()).setHeightType(ComponentDimensionType.EXPAND);
        return this;
    }

    public TextFieldBuilder<T> setEvaluationTime(Evaluation evaluationTime) {
        ((DRTextField)this.getObject()).setEvaluationTime(evaluationTime);
        return this;
    }

    public TextFieldBuilder<T> setEvaluationGroup(GroupBuilder<?> evaluationGroup) {
        Validate.notNull(evaluationGroup, (String)"evaluationGroup must not be null", (Object[])new Object[0]);
        ((DRTextField)this.getObject()).setEvaluationGroup((DRGroup)evaluationGroup.build());
        ((DRTextField)this.getObject()).setEvaluationTime(Evaluation.GROUP);
        return this;
    }

    public TextFieldBuilder<T> setMarkup(Markup markup) {
        ((DRTextField)this.getObject()).setMarkup(markup);
        return this;
    }

    @Deprecated
    public TextFieldBuilder<T> setStretchWithOverflow(Boolean stretchWithOverflow) {
        ((DRTextField)this.getObject()).setStretchWithOverflow(stretchWithOverflow);
        return this;
    }

    public TextFieldBuilder<T> setTextAdjust(TextAdjust textAdjust) {
        ((DRTextField)this.getObject()).setTextAdjust(textAdjust);
        return this;
    }

    public TextFieldBuilder<T> setPrintRepeatedValues(Boolean printRepeatedValues) {
        ((DRTextField)this.getObject()).setPrintRepeatedValues(printRepeatedValues);
        return this;
    }
}

