/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.expression;

import java.awt.Image;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import net.sf.dynamicreports.report.builder.crosstab.AbstractCrosstabGroupBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabMeasureBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabRowGroupBuilder;
import net.sf.dynamicreports.report.builder.expression.BeanArraySubDatasourceExpression;
import net.sf.dynamicreports.report.builder.expression.BeanCollectionSubDatasourceExpression;
import net.sf.dynamicreports.report.builder.expression.ColumnNumberExpression;
import net.sf.dynamicreports.report.builder.expression.ColumnRowNumberExpression;
import net.sf.dynamicreports.report.builder.expression.CrosstabValueExpression;
import net.sf.dynamicreports.report.builder.expression.DataSourceExpression;
import net.sf.dynamicreports.report.builder.expression.GroupRowNumberExpression;
import net.sf.dynamicreports.report.builder.expression.JasperExpression;
import net.sf.dynamicreports.report.builder.expression.MapArraySubDatasourceExpression;
import net.sf.dynamicreports.report.builder.expression.MapCollectionSubDatasourceExpression;
import net.sf.dynamicreports.report.builder.expression.MessageExpression;
import net.sf.dynamicreports.report.builder.expression.OrderByExpression;
import net.sf.dynamicreports.report.builder.expression.PageNumberExpression;
import net.sf.dynamicreports.report.builder.expression.PageRowNumberExpression;
import net.sf.dynamicreports.report.builder.expression.ParameterExpression;
import net.sf.dynamicreports.report.builder.expression.PrintInEvenRowExpression;
import net.sf.dynamicreports.report.builder.expression.PrintInFirstPageExpression;
import net.sf.dynamicreports.report.builder.expression.PrintInOddRowExpression;
import net.sf.dynamicreports.report.builder.expression.PrintNotInFirstPageExpression;
import net.sf.dynamicreports.report.builder.expression.PrintWhenGroupHasMoreThanOneRowExpression;
import net.sf.dynamicreports.report.builder.expression.PropertyExpression;
import net.sf.dynamicreports.report.builder.expression.ReportRowNumberExpression;
import net.sf.dynamicreports.report.builder.expression.ValueExpression;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.definition.DRICrosstabValue;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.jasperreports.engine.JRDataSource;
import org.apache.commons.lang3.Validate;
import org.apache.commons.text.StringEscapeUtils;

public class Expressions {
    private static final PrintInFirstPageExpression printInFirstPage = new PrintInFirstPageExpression();
    private static final PrintNotInFirstPageExpression printNotInFirstPage = new PrintNotInFirstPageExpression();
    private static final ReportRowNumberExpression reportRowNumber = new ReportRowNumberExpression();
    private static final PageRowNumberExpression pageRowNumber = new PageRowNumberExpression();
    private static final ColumnRowNumberExpression columnRowNumber = new ColumnRowNumberExpression();
    private static final PageNumberExpression pageNumber = new PageNumberExpression();
    private static final ColumnNumberExpression columnNumber = new ColumnNumberExpression();
    private static final PrintInOddRowExpression printInOddRow = new PrintInOddRowExpression();
    private static final PrintInEvenRowExpression printInEvenRow = new PrintInEvenRowExpression();

    public static PrintInFirstPageExpression printInFirstPage() {
        return printInFirstPage;
    }

    public static PrintNotInFirstPageExpression printNotInFirstPage() {
        return printNotInFirstPage;
    }

    public static PrintWhenGroupHasMoreThanOneRowExpression printWhenGroupHasMoreThanOneRow(String groupName) {
        return new PrintWhenGroupHasMoreThanOneRowExpression(groupName);
    }

    public static PrintWhenGroupHasMoreThanOneRowExpression printWhenGroupHasMoreThanOneRow(GroupBuilder<?> group) {
        Validate.notNull(group, (String)"group must not be null", (Object[])new Object[0]);
        return Expressions.printWhenGroupHasMoreThanOneRow(group.getGroup().getName());
    }

    public static ReportRowNumberExpression reportRowNumber() {
        return reportRowNumber;
    }

    public static PageRowNumberExpression pageRowNumber() {
        return pageRowNumber;
    }

    public static ColumnRowNumberExpression columnRowNumber() {
        return columnRowNumber;
    }

    public static PageNumberExpression pageNumber() {
        return pageNumber;
    }

    public static ColumnNumberExpression columnNumber() {
        return columnNumber;
    }

    public static GroupRowNumberExpression groupRowNumber(String groupName) {
        return new GroupRowNumberExpression(groupName);
    }

    public static GroupRowNumberExpression groupRowNumber(GroupBuilder<?> group) {
        Validate.notNull(group, (String)"group must not be null", (Object[])new Object[0]);
        return Expressions.groupRowNumber(group.getGroup().getName());
    }

    public static ValueExpression<Date> date(Date date) {
        return Expressions.value(date, Date.class);
    }

    public static ValueExpression<Number> number(Number number) {
        return Expressions.value(number, Number.class);
    }

    public static ValueExpression<Image> image(Image image) {
        return Expressions.value(image, Image.class);
    }

    public static ValueExpression<InputStream> inputStream(InputStream inputStream) {
        return Expressions.value(inputStream, InputStream.class);
    }

    public static ValueExpression<URL> url(URL url) {
        return Expressions.value(url, URL.class);
    }

    public static <T> ValueExpression<T> value(T value) {
        return new ValueExpression<T>(value);
    }

    public static <T> ValueExpression<T> value(T value, Class<? super T> valueClass) {
        return new ValueExpression<T>(value, valueClass);
    }

    public static ValueExpression<String> text(String text) {
        return Expressions.value(text, String.class);
    }

    public static DataSourceExpression dataSource(JRDataSource dataSource) {
        return new DataSourceExpression(dataSource);
    }

    public static MessageExpression message(String key) {
        if (key != null) {
            return new MessageExpression(key);
        }
        return null;
    }

    public static MessageExpression message(String key, Object[] arguments) {
        if (key != null) {
            return new MessageExpression(key, arguments);
        }
        return null;
    }

    public static JasperExpression<String> jasperSyntaxText(String text) {
        return new JasperExpression<String>("\"" + StringEscapeUtils.escapeJava((String)text) + "\"", String.class);
    }

    public static <T> JasperExpression<T> jasperSyntax(String expression, Class<? super T> valueClass) {
        return new JasperExpression<T>(expression, valueClass);
    }

    public static JasperExpression jasperSyntax(String expression) {
        return Expressions.jasperSyntax(expression, Object.class);
    }

    public static PropertyExpression property(String name, DRIExpression<String> valueExpression) {
        return new PropertyExpression(name, valueExpression);
    }

    public static PropertyExpression property(String name, String value) {
        return new PropertyExpression(name, Expressions.text(value));
    }

    public static ParameterExpression parameter(String name, DRIExpression<?> valueExpression) {
        return new ParameterExpression(name, valueExpression);
    }

    public static ParameterExpression parameter(String name, Object value) {
        return new ParameterExpression(name, Expressions.value(value));
    }

    public static PrintInOddRowExpression printInOddRow() {
        return printInOddRow;
    }

    public static PrintInEvenRowExpression printInEvenRow() {
        return printInEvenRow;
    }

    public static BeanCollectionSubDatasourceExpression subDatasourceBeanCollection(String fieldName) {
        return new BeanCollectionSubDatasourceExpression(fieldName);
    }

    public static BeanCollectionSubDatasourceExpression subDatasourceBeanCollection(DRIExpression<? extends Collection<?>> expression) {
        return new BeanCollectionSubDatasourceExpression(expression);
    }

    public static BeanArraySubDatasourceExpression subDatasourceBeanArray(String fieldName) {
        return new BeanArraySubDatasourceExpression(fieldName);
    }

    public static BeanArraySubDatasourceExpression subDatasourceBeanArray(DRIExpression<? extends Object[]> expression) {
        return new BeanArraySubDatasourceExpression(expression);
    }

    public static MapCollectionSubDatasourceExpression subDatasourceMapCollection(String fieldName) {
        return new MapCollectionSubDatasourceExpression(fieldName);
    }

    public static MapCollectionSubDatasourceExpression subDatasourceMapCollection(DRIExpression<? extends Collection<Map<String, ?>>> expression) {
        return new MapCollectionSubDatasourceExpression(expression);
    }

    public static MapArraySubDatasourceExpression subDatasourceMapArray(String fieldName) {
        return new MapArraySubDatasourceExpression(fieldName);
    }

    public static MapArraySubDatasourceExpression subDatasourceMapArray(DRIExpression<? extends Object[]> expression) {
        return new MapArraySubDatasourceExpression(expression);
    }

    public static OrderByExpression orderBy(CrosstabMeasureBuilder<? extends Comparable<?>> measure) {
        return new OrderByExpression(measure);
    }

    public static <T> CrosstabValueExpression<T> crosstabValue(AbstractCrosstabGroupBuilder<?, ?, ?> group) {
        return new CrosstabValueExpression(group);
    }

    public static <T> CrosstabValueExpression<T> crosstabValue(DRICrosstabValue<T> measure) {
        return new CrosstabValueExpression<T>(measure);
    }

    public static <T> CrosstabValueExpression<T> crosstabValue(DRICrosstabValue<T> measure, AbstractCrosstabGroupBuilder<?, ?, ?> group) {
        return new CrosstabValueExpression<T>(measure, group);
    }

    public static <T> CrosstabValueExpression<T> crosstabValue(DRICrosstabValue<T> measure, CrosstabRowGroupBuilder<?> rowGroup, CrosstabColumnGroupBuilder<?> columnGroup) {
        return new CrosstabValueExpression<T>(measure, rowGroup, columnGroup);
    }
}

