/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.style;

import java.awt.Color;
import net.sf.dynamicreports.report.base.style.DRBaseStyle;
import net.sf.dynamicreports.report.base.style.DRBorder;
import net.sf.dynamicreports.report.base.style.DRFont;
import net.sf.dynamicreports.report.base.style.DRPadding;
import net.sf.dynamicreports.report.base.style.DRPen;
import net.sf.dynamicreports.report.base.style.DRTabStop;
import net.sf.dynamicreports.report.builder.AbstractBuilder;
import net.sf.dynamicreports.report.builder.style.BorderBuilder;
import net.sf.dynamicreports.report.builder.style.FontBuilder;
import net.sf.dynamicreports.report.builder.style.PaddingBuilder;
import net.sf.dynamicreports.report.builder.style.PenBuilder;
import net.sf.dynamicreports.report.builder.style.Styles;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.constant.HorizontalImageAlignment;
import net.sf.dynamicreports.report.constant.HorizontalTextAlignment;
import net.sf.dynamicreports.report.constant.ImageScale;
import net.sf.dynamicreports.report.constant.LineSpacing;
import net.sf.dynamicreports.report.constant.Markup;
import net.sf.dynamicreports.report.constant.Rotation;
import net.sf.dynamicreports.report.constant.TabStopAlignment;
import net.sf.dynamicreports.report.constant.VerticalAlignment;
import net.sf.dynamicreports.report.constant.VerticalImageAlignment;
import net.sf.dynamicreports.report.constant.VerticalTextAlignment;
import org.apache.commons.lang3.Validate;

public abstract class BaseStyleBuilder<T extends BaseStyleBuilder<T, U>, U extends DRBaseStyle>
extends AbstractBuilder<T, U> {
    private static final long serialVersionUID = 10000L;

    protected BaseStyleBuilder(U baseStyle) {
        super(baseStyle);
    }

    public T setBackgroundColor(Color backgroundColor) {
        ((DRBaseStyle)this.getObject()).setBackgroundColor(backgroundColor);
        return (T)this;
    }

    public T setBorder(BorderBuilder border) {
        if (border != null) {
            ((DRBaseStyle)this.getObject()).setBorder((DRBorder)border.build());
        } else {
            ((DRBaseStyle)this.getObject()).setBorder(null);
        }
        return (T)this;
    }

    public T setBorder(PenBuilder pen) {
        return this.setBorder(pen != null ? Styles.border(pen) : null);
    }

    public T setTopBorder(PenBuilder topPen) {
        if (topPen != null) {
            ((DRBaseStyle)this.getObject()).getBorder().setTopPen((DRPen)topPen.build());
        } else {
            ((DRBaseStyle)this.getObject()).getBorder().setTopPen(null);
        }
        return (T)this;
    }

    public T setLeftBorder(PenBuilder leftPen) {
        if (leftPen != null) {
            ((DRBaseStyle)this.getObject()).getBorder().setLeftPen((DRPen)leftPen.build());
        } else {
            ((DRBaseStyle)this.getObject()).getBorder().setLeftPen(null);
        }
        return (T)this;
    }

    public T setBottomBorder(PenBuilder bottomPen) {
        if (bottomPen != null) {
            ((DRBaseStyle)this.getObject()).getBorder().setBottomPen((DRPen)bottomPen.build());
        } else {
            ((DRBaseStyle)this.getObject()).getBorder().setBottomPen(null);
        }
        return (T)this;
    }

    public T setRightBorder(PenBuilder rightPen) {
        if (rightPen != null) {
            ((DRBaseStyle)this.getObject()).getBorder().setRightPen((DRPen)rightPen.build());
        } else {
            ((DRBaseStyle)this.getObject()).getBorder().setRightPen(null);
        }
        return (T)this;
    }

    public T setFont(FontBuilder font) {
        if (font != null) {
            ((DRBaseStyle)this.getObject()).setFont((DRFont)font.build());
        } else {
            ((DRBaseStyle)this.getObject()).setFont(null);
        }
        return (T)this;
    }

    public T bold() {
        return this.setBold(true);
    }

    public T setBold(Boolean bold) {
        ((DRBaseStyle)this.getObject()).getFont().setBold(bold);
        return (T)this;
    }

    public T setFontName(String fontName) {
        ((DRBaseStyle)this.getObject()).getFont().setFontName(fontName);
        return (T)this;
    }

    public T setFontSize(Integer fontSize) {
        ((DRBaseStyle)this.getObject()).getFont().setFontSize(fontSize);
        return (T)this;
    }

    public T italic() {
        return this.setItalic(true);
    }

    public T setItalic(Boolean italic) {
        ((DRBaseStyle)this.getObject()).getFont().setItalic(italic);
        return (T)this;
    }

    public T boldItalic() {
        this.setBold(true);
        return this.setItalic(true);
    }

    @Deprecated
    public T setPdfEmbedded(Boolean pdfEmbedded) {
        ((DRBaseStyle)this.getObject()).getFont().setPdfEmbedded(pdfEmbedded);
        return (T)this;
    }

    @Deprecated
    public T setPdfEncoding(String pdfEncoding) {
        ((DRBaseStyle)this.getObject()).getFont().setPdfEncoding(pdfEncoding);
        return (T)this;
    }

    @Deprecated
    public T setPdfFontName(String pdfFontName) {
        ((DRBaseStyle)this.getObject()).getFont().setPdfFontName(pdfFontName);
        return (T)this;
    }

    public T strikeThrough() {
        return this.setStrikeThrough(true);
    }

    public T setStrikeThrough(Boolean strikeThrough) {
        ((DRBaseStyle)this.getObject()).getFont().setStrikeThrough(strikeThrough);
        return (T)this;
    }

    public T underline() {
        return this.setUnderline(true);
    }

    public T setUnderline(Boolean underline) {
        ((DRBaseStyle)this.getObject()).getFont().setUnderline(underline);
        return (T)this;
    }

    public T setForegroundColor(Color foregroudColor) {
        ((DRBaseStyle)this.getObject()).setForegroundColor(foregroudColor);
        return (T)this;
    }

    @Deprecated
    public T setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment != null) {
            ((DRBaseStyle)this.getObject()).setHorizontalTextAlignment(HorizontalTextAlignment.valueOf(horizontalAlignment.name()));
        } else {
            ((DRBaseStyle)this.getObject()).setHorizontalTextAlignment(null);
        }
        return (T)this;
    }

    public T setHorizontalTextAlignment(HorizontalTextAlignment horizontalTextAlignment) {
        ((DRBaseStyle)this.getObject()).setHorizontalTextAlignment(horizontalTextAlignment);
        return (T)this;
    }

    public T setHorizontalImageAlignment(HorizontalImageAlignment horizontalImageAlignment) {
        ((DRBaseStyle)this.getObject()).setHorizontalImageAlignment(horizontalImageAlignment);
        return (T)this;
    }

    public T setImageScale(ImageScale imageScale) {
        ((DRBaseStyle)this.getObject()).setImageScale(imageScale);
        return (T)this;
    }

    public T setPadding(PaddingBuilder padding) {
        if (padding != null) {
            ((DRBaseStyle)this.getObject()).setPadding((DRPadding)padding.build());
        } else {
            ((DRBaseStyle)this.getObject()).setPadding(null);
        }
        return (T)this;
    }

    public T setPadding(Integer padding) {
        return this.setPadding(Styles.padding(padding));
    }

    public T setTopPadding(Integer top) {
        ((DRBaseStyle)this.getObject()).getPadding().setTop(top);
        return (T)this;
    }

    public T setLeftPadding(Integer left) {
        ((DRBaseStyle)this.getObject()).getPadding().setLeft(left);
        return (T)this;
    }

    public T setBottomPadding(Integer bottom) {
        ((DRBaseStyle)this.getObject()).getPadding().setBottom(bottom);
        return (T)this;
    }

    public T setRightPadding(Integer right) {
        ((DRBaseStyle)this.getObject()).getPadding().setRight(right);
        return (T)this;
    }

    public T setPattern(String pattern) {
        ((DRBaseStyle)this.getObject()).setPattern(pattern);
        return (T)this;
    }

    public T setRadius(Integer radius) {
        ((DRBaseStyle)this.getObject()).setRadius(radius);
        return (T)this;
    }

    public T setRotation(Rotation rotation) {
        ((DRBaseStyle)this.getObject()).setRotation(rotation);
        return (T)this;
    }

    @Deprecated
    public T setAlignment(HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        if (horizontalAlignment != null) {
            ((DRBaseStyle)this.getObject()).setHorizontalTextAlignment(HorizontalTextAlignment.valueOf(horizontalAlignment.name()));
        } else {
            ((DRBaseStyle)this.getObject()).setHorizontalTextAlignment(null);
        }
        if (verticalAlignment != null) {
            ((DRBaseStyle)this.getObject()).setVerticalTextAlignment(VerticalTextAlignment.valueOf(verticalAlignment.name()));
        } else {
            ((DRBaseStyle)this.getObject()).setVerticalTextAlignment(null);
        }
        return (T)this;
    }

    public T setTextAlignment(HorizontalTextAlignment horizontalTextAlignment, VerticalTextAlignment verticalTextAlignment) {
        ((DRBaseStyle)this.getObject()).setHorizontalTextAlignment(horizontalTextAlignment);
        ((DRBaseStyle)this.getObject()).setVerticalTextAlignment(verticalTextAlignment);
        return (T)this;
    }

    public T setImageAlignment(HorizontalImageAlignment horizontalImageAlignment, VerticalImageAlignment verticalImageAlignment) {
        ((DRBaseStyle)this.getObject()).setHorizontalImageAlignment(horizontalImageAlignment);
        ((DRBaseStyle)this.getObject()).setVerticalImageAlignment(verticalImageAlignment);
        return (T)this;
    }

    @Deprecated
    public T setVerticalAlignment(VerticalAlignment verticalAlignment) {
        if (verticalAlignment != null) {
            ((DRBaseStyle)this.getObject()).setVerticalTextAlignment(VerticalTextAlignment.valueOf(verticalAlignment.name()));
        } else {
            ((DRBaseStyle)this.getObject()).setVerticalTextAlignment(null);
        }
        return (T)this;
    }

    public T setVerticalTextAlignment(VerticalTextAlignment verticalTextAlignment) {
        ((DRBaseStyle)this.getObject()).setVerticalTextAlignment(verticalTextAlignment);
        return (T)this;
    }

    public T setVerticalImageAlignment(VerticalImageAlignment verticalImageAlignment) {
        ((DRBaseStyle)this.getObject()).setVerticalImageAlignment(verticalImageAlignment);
        return (T)this;
    }

    public T setMarkup(Markup markup) {
        ((DRBaseStyle)this.getObject()).setMarkup(markup);
        return (T)this;
    }

    public T setLineSpacing(LineSpacing lineSpacing) {
        ((DRBaseStyle)this.getObject()).getParagraph().setLineSpacing(lineSpacing);
        return (T)this;
    }

    public T setLineSpacingSize(Float lineSpacingSize) {
        ((DRBaseStyle)this.getObject()).getParagraph().setLineSpacingSize(lineSpacingSize);
        return (T)this;
    }

    public T setFirstLineIndent(Integer firstLineIndent) {
        ((DRBaseStyle)this.getObject()).getParagraph().setFirstLineIndent(firstLineIndent);
        return (T)this;
    }

    public T setLeftIndent(Integer leftIndent) {
        ((DRBaseStyle)this.getObject()).getParagraph().setLeftIndent(leftIndent);
        return (T)this;
    }

    public T setRightIndent(Integer rightIndent) {
        ((DRBaseStyle)this.getObject()).getParagraph().setRightIndent(rightIndent);
        return (T)this;
    }

    public T setSpacingBefore(Integer spacingBefore) {
        ((DRBaseStyle)this.getObject()).getParagraph().setSpacingBefore(spacingBefore);
        return (T)this;
    }

    public T setSpacingAfter(Integer spacingAfter) {
        ((DRBaseStyle)this.getObject()).getParagraph().setSpacingAfter(spacingAfter);
        return (T)this;
    }

    public T setTabStopWidth(Integer tabStopWidth) {
        ((DRBaseStyle)this.getObject()).getParagraph().setTabStopWidth(tabStopWidth);
        return (T)this;
    }

    public T addTabStop(int position, TabStopAlignment alignment) {
        Validate.notNull((Object)((Object)alignment), (String)"alignment must not be null", (Object[])new Object[0]);
        DRTabStop tabStop = new DRTabStop();
        tabStop.setPosition(position);
        tabStop.setAlignment(alignment);
        ((DRBaseStyle)this.getObject()).getParagraph().getTabStops().add(tabStop);
        return (T)this;
    }

    public T setLinePen(PenBuilder linePen) {
        if (linePen != null) {
            ((DRBaseStyle)this.getObject()).setLinePen((DRPen)linePen.build());
        } else {
            ((DRBaseStyle)this.getObject()).setLinePen(null);
        }
        return (T)this;
    }

    public U getStyle() {
        return (U)((DRBaseStyle)this.build());
    }
}

