/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.subtotal;

import net.sf.dynamicreports.report.base.DRGroup;
import net.sf.dynamicreports.report.base.DRSubtotal;
import net.sf.dynamicreports.report.base.DRVariable;
import net.sf.dynamicreports.report.base.component.DRTextField;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.datatype.DataTypes;
import net.sf.dynamicreports.report.builder.expression.PercentageExpression;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.subtotal.BaseSubtotalBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.Evaluation;
import net.sf.dynamicreports.report.constant.PercentageTotalType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRReportException;

public class PercentageSubtotalBuilder
extends BaseSubtotalBuilder<PercentageSubtotalBuilder, Double> {
    private static final long serialVersionUID = 10000L;
    private DRIExpression<? extends Number> expression;
    private PercentageTotalType totalType;
    private DRGroup totalGroup;

    protected PercentageSubtotalBuilder(ValueColumnBuilder<?, ? extends Number> column) {
        this((DRIExpression)column.build(), column);
    }

    protected PercentageSubtotalBuilder(FieldBuilder<? extends Number> field, ColumnBuilder<?, ?> showInColumn) {
        this(field.getField(), showInColumn);
    }

    protected PercentageSubtotalBuilder(DRIExpression<? extends Number> expression, ColumnBuilder<?, ?> showInColumn) {
        super(showInColumn);
        this.expression = expression;
    }

    public PercentageSubtotalBuilder setTotalType(PercentageTotalType totalType) {
        this.totalType = totalType;
        return this;
    }

    public PercentageSubtotalBuilder setTotalGroup(GroupBuilder<?> totalGroup) {
        if (totalGroup != null) {
            this.totalGroup = totalGroup.getGroup();
            this.setTotalType(PercentageTotalType.GROUP);
        } else {
            this.totalGroup = null;
        }
        return this;
    }

    @Override
    protected void configure() {
        DRVariable totalExpression;
        DRVariable actualExpression;
        block8: {
            block7: {
                if (((DRTextField)((DRSubtotal)this.getObject()).getValueField()).getDataType() == null) {
                    ((DRTextField)((DRSubtotal)this.getObject()).getValueField()).setDataType(DataTypes.percentageType());
                }
                actualExpression = new DRVariable(this.expression, Calculation.SUM);
                actualExpression.setResetType(Evaluation.GROUP);
                actualExpression.setResetGroup(((DRSubtotal)this.getObject()).getGroup());
                totalExpression = new DRVariable(this.expression, Calculation.SUM);
                if (this.totalType == null) break block7;
                switch (this.totalType) {
                    case REPORT: {
                        totalExpression.setResetType(Evaluation.REPORT);
                        break block8;
                    }
                    case GROUP: {
                        totalExpression.setResetType(Evaluation.GROUP);
                        break block8;
                    }
                    case FIRST_GROUP: {
                        totalExpression.setResetType(Evaluation.FIRST_GROUP);
                        break block8;
                    }
                    case LAST_GROUP: {
                        totalExpression.setResetType(Evaluation.LAST_GROUP);
                        break block8;
                    }
                    default: {
                        throw new DRReportException("Percentage total type " + this.totalType.name() + " not supported.");
                    }
                }
            }
            totalExpression.setResetType(Evaluation.BEFORE_GROUP);
            this.totalGroup = ((DRSubtotal)this.getObject()).getGroup();
        }
        totalExpression.setResetGroup(this.totalGroup);
        this.setValueExpression(new PercentageExpression(actualExpression, totalExpression));
        super.configure();
    }
}

