/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.network.unix;

import java.util.HashMap;
import java.util.Map;
import org.jutils.jhardware.info.network.AbstractNetworkInfo;
import org.jutils.jhardware.util.HardwareInfoUtils;

public final class UnixNetworkInfo
extends AbstractNetworkInfo {
    private static String getNetworkData() {
        return HardwareInfoUtils.executeCommand("ifconfig", "-a");
    }

    @Override
    protected Map<String, String> parseInfo() {
        HashMap<String, String> networkDataMap = new HashMap<String, String>();
        String networkData = UnixNetworkInfo.getNetworkData();
        if (networkData != null) {
            String[] dataStringLines = networkData.split("\\r?\\n");
            int count = 0;
            String[] stringArray = dataStringLines;
            int n = dataStringLines.length;
            int n2 = 0;
            while (n2 < n) {
                String dataLine = stringArray[n2];
                if (!dataLine.startsWith(" ")) {
                    networkDataMap.put("interface_" + ++count, HardwareInfoUtils.extractText(dataLine, "([^\\s]+)"));
                    networkDataMap.put("type_" + count, HardwareInfoUtils.extractText(dataLine, "Link encap:(.+?)  "));
                } else {
                    UnixNetworkInfo.updateNetworkData(networkDataMap, count, dataLine);
                }
                ++n2;
            }
            networkDataMap.put("interfacesLength", String.valueOf(count));
        }
        return networkDataMap;
    }

    private static void updateNetworkData(Map<String, String> networkDataMap, int count, String dataLine) {
        block17: {
            String lineType = HardwareInfoUtils.extractText(dataLine, "([^\\s]+)");
            if (lineType == null) break block17;
            switch (lineType) {
                case "inet": {
                    networkDataMap.put("ipv4_" + count, HardwareInfoUtils.extractText(dataLine, "addr:(.+?) "));
                    break;
                }
                case "inet6": {
                    networkDataMap.put("ipv6_" + count, HardwareInfoUtils.extractText(dataLine, "addr:(.+?) "));
                    break;
                }
                case "RX": {
                    if (dataLine.trim().startsWith("RX packets")) {
                        networkDataMap.put("received_packets_" + count, HardwareInfoUtils.extractText(dataLine, "packets:(.+?) "));
                        break;
                    }
                    networkDataMap.put("received_bytes_" + count, HardwareInfoUtils.extractText(dataLine, "RX bytes:(.+?) "));
                    networkDataMap.put("transmitted_bytes_" + count, HardwareInfoUtils.extractText(dataLine, "TX bytes:(.+?) "));
                    break;
                }
                case "TX": {
                    networkDataMap.put("transmitted_packets_" + count, HardwareInfoUtils.extractText(dataLine, "packets:(.+?) "));
                    break;
                }
            }
        }
    }
}

