/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.chartcustomizer;

import java.awt.Paint;
import java.io.Serializable;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.chart.DRIChartCustomizer;
import net.sf.dynamicreports.report.definition.chart.plot.DRIWaterfallBarPlot;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.WaterfallBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.GradientPaintTransformer;

public class WaterfallBarRendererCustomizer
implements DRIChartCustomizer,
Serializable {
    private static final long serialVersionUID = 10000L;
    private Paint firstBarPaint;
    private Paint lastBarPaint;
    private Paint positiveBarPaint;
    private Paint negativeBarPaint;

    public WaterfallBarRendererCustomizer(DRIWaterfallBarPlot waterfallBarPlot) {
        this.firstBarPaint = waterfallBarPlot.getFirstBarPaint();
        this.lastBarPaint = waterfallBarPlot.getLastBarPaint();
        this.positiveBarPaint = waterfallBarPlot.getPositiveBarPaint();
        this.negativeBarPaint = waterfallBarPlot.getNegativeBarPaint();
    }

    @Override
    public void customize(JFreeChart chart, ReportParameters reportParameters) {
        BarRenderer categoryRenderer = (BarRenderer)chart.getCategoryPlot().getRenderer();
        WaterfallBarRenderer renderer = new WaterfallBarRenderer();
        renderer.setBaseItemLabelsVisible(categoryRenderer.getBaseItemLabelsVisible());
        renderer.setBaseItemLabelFont(categoryRenderer.getBaseItemLabelFont());
        renderer.setBaseItemLabelPaint(categoryRenderer.getBaseItemLabelPaint());
        renderer.setBaseItemLabelGenerator(categoryRenderer.getBaseItemLabelGenerator());
        renderer.setShadowVisible(categoryRenderer.getShadowsVisible());
        CategoryDataset categoryDataset = chart.getCategoryPlot().getDataset();
        if (categoryDataset != null) {
            for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
                Paint seriesPaint;
                Paint seriesOutlinePaint = categoryRenderer.getSeriesOutlinePaint(i);
                if (seriesOutlinePaint != null) {
                    renderer.setSeriesOutlinePaint(i, seriesOutlinePaint);
                }
                if ((seriesPaint = categoryRenderer.getSeriesPaint(i)) == null) continue;
                renderer.setSeriesPaint(i, seriesPaint);
            }
        }
        renderer.setItemMargin(categoryRenderer.getItemMargin());
        GradientPaintTransformer gradientPaintTransformer = categoryRenderer.getGradientPaintTransformer();
        if (gradientPaintTransformer != null) {
            renderer.setGradientPaintTransformer(gradientPaintTransformer);
        }
        if (this.firstBarPaint != null) {
            renderer.setFirstBarPaint(this.firstBarPaint);
        }
        if (this.lastBarPaint != null) {
            renderer.setLastBarPaint(this.lastBarPaint);
        }
        if (this.positiveBarPaint != null) {
            renderer.setPositiveBarPaint(this.positiveBarPaint);
        }
        if (this.negativeBarPaint != null) {
            renderer.setNegativeBarPaint(this.negativeBarPaint);
        }
        chart.getCategoryPlot().setRenderer((CategoryItemRenderer)renderer);
    }
}

