/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.expressions;

import java.util.List;
import net.sf.dynamicreports.design.exception.DRDesignReportException;
import net.sf.dynamicreports.design.transformation.CustomBatikRenderer;
import net.sf.dynamicreports.report.ReportUtils;
import net.sf.dynamicreports.report.builder.expression.AbstractComplexExpression;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.component.DRIBooleanField;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.renderers.Renderable;

public class BooleanImageExpression
extends AbstractComplexExpression<Renderable> {
    private static final long serialVersionUID = 10000L;
    private Renderable imageTrue;
    private Renderable imageFalse;
    private boolean emptyWhenNullValue;

    public BooleanImageExpression(DRIBooleanField booleanField, boolean emptyWhenNullValue, int width, int height) throws DRException {
        String fileNameFalse;
        String fileNameTrue;
        this.emptyWhenNullValue = emptyWhenNullValue;
        this.addExpression(booleanField.getValueExpression());
        switch (booleanField.getComponentType()) {
            case IMAGE_STYLE_1: {
                fileNameTrue = "boolean1_true";
                fileNameFalse = "boolean1_false";
                break;
            }
            case IMAGE_STYLE_2: {
                fileNameTrue = "boolean2_true";
                fileNameFalse = "boolean2_false";
                break;
            }
            case IMAGE_STYLE_3: {
                fileNameTrue = "boolean3_true";
                fileNameFalse = "boolean3_false";
                break;
            }
            case IMAGE_STYLE_4: {
                fileNameTrue = "boolean1_true";
                fileNameFalse = "boolean4_false";
                break;
            }
            case IMAGE_CHECKBOX_1: {
                fileNameTrue = "checkbox1_true";
                fileNameFalse = "checkbox_false";
                break;
            }
            case IMAGE_CHECKBOX_2: {
                fileNameTrue = "checkbox2_true";
                fileNameFalse = "checkbox_false";
                break;
            }
            case IMAGE_BALL: {
                fileNameTrue = "ball_green";
                fileNameFalse = "ball_red";
                break;
            }
            default: {
                throw new DRDesignReportException("BooleanComponentType " + booleanField.getComponentType().name() + " not supported");
            }
        }
        try {
            this.imageTrue = new CustomBatikRenderer(ReportUtils.class.getResource("images/" + fileNameTrue + ".svg"), width, height);
            this.imageFalse = new CustomBatikRenderer(ReportUtils.class.getResource("images/" + fileNameFalse + ".svg"), width, height);
        }
        catch (JRException e) {
            throw new DRException(e);
        }
    }

    @Override
    public Renderable evaluate(List<?> values, ReportParameters reportParameters) {
        Boolean value = (Boolean)values.get(0);
        if (this.emptyWhenNullValue && value == null) {
            return null;
        }
        if (value != null && value.booleanValue()) {
            return this.imageTrue;
        }
        return this.imageFalse;
    }
}

