/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.jasper.base.reporthandler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.dynamicreports.jasper.base.reporthandler.AbstractPrintListHandler;
import net.sf.dynamicreports.report.exception.DRReportException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;

public class JasperPrintListFileHandler
extends AbstractPrintListHandler {
    private static final String TEMP_FILE_PREFIX = "JasperPrint";
    private List<JasperPrint> printList;
    private List<File> tempFiles;
    private File directory;
    private JRVirtualizer virtualizer;

    public JasperPrintListFileHandler(String directory) {
        this(directory, null);
    }

    public JasperPrintListFileHandler(String directory, JRVirtualizer virtualizer) {
        this.virtualizer = virtualizer;
        if (directory != null) {
            this.directory = new File(directory);
        }
        this.printList = new PrintList();
        this.tempFiles = new ArrayList<File>();
    }

    @Override
    protected void add(JasperPrint jasperPrint) {
        try {
            File tempFile = File.createTempFile(TEMP_FILE_PREFIX, null, this.directory);
            JRSaver.saveObject((Object)jasperPrint, (File)tempFile);
            this.tempFiles.add(tempFile);
        }
        catch (JRException e) {
            throw new DRReportException(e);
        }
        catch (IOException e) {
            throw new DRReportException(e);
        }
    }

    @Override
    public List<JasperPrint> getPrintList() {
        return this.printList;
    }

    protected void finalize() throws Throwable {
        for (File tempFile : this.tempFiles) {
            tempFile.delete();
        }
        super.finalize();
    }

    private class PrintList
    implements List<JasperPrint> {
        private PrintList() {
        }

        @Override
        public int size() {
            return JasperPrintListFileHandler.this.tempFiles.size();
        }

        @Override
        public boolean isEmpty() {
            return JasperPrintListFileHandler.this.tempFiles.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<JasperPrint> iterator() {
            return new Iterator<JasperPrint>(){
                private Iterator<File> it;
                {
                    this.it = JasperPrintListFileHandler.this.tempFiles.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public JasperPrint next() {
                    File tempFile = this.it.next();
                    try {
                        JasperPrint jasperPrint = JRLoader.loadJasperPrint((File)tempFile, (JRVirtualizer)JasperPrintListFileHandler.this.virtualizer);
                        return jasperPrint;
                    }
                    catch (JRException e) {
                        throw new DRReportException(e);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(JasperPrint o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends JasperPrint> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends JasperPrint> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JasperPrint get(int index) {
            try {
                File tempFile = (File)JasperPrintListFileHandler.this.tempFiles.get(index);
                JasperPrint jasperPrint = JRLoader.loadJasperPrint((File)tempFile, (JRVirtualizer)JasperPrintListFileHandler.this.virtualizer);
                return jasperPrint;
            }
            catch (JRException e) {
                throw new DRReportException(e);
            }
        }

        @Override
        public JasperPrint set(int index, JasperPrint element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, JasperPrint element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JasperPrint remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lastIndexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<JasperPrint> listIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<JasperPrint> listIterator(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<JasperPrint> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }
    }
}

