/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.jasper.transformation;

import net.sf.dynamicreports.design.definition.DRIDesignGroup;
import net.sf.dynamicreports.jasper.exception.JasperDesignException;
import net.sf.dynamicreports.jasper.transformation.ConstantTransform;
import net.sf.dynamicreports.jasper.transformation.JasperTransformAccessor;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;

public class GroupTransform {
    private JasperTransformAccessor accessor;

    public GroupTransform(JasperTransformAccessor accessor) {
        this.accessor = accessor;
    }

    public void transform() {
        for (DRIDesignGroup dRIDesignGroup : this.accessor.getReport().getGroups()) {
            this.addGroup(dRIDesignGroup);
        }
    }

    private void addGroup(DRIDesignGroup group) {
        try {
            JRDesignGroup jrGroup = this.group(group);
            this.accessor.getDesign().addGroup(jrGroup);
        }
        catch (JRException e) {
            throw new JasperDesignException("Registration failed for group \"" + group.getName() + "\"", e);
        }
    }

    private JRDesignGroup group(DRIDesignGroup group) {
        JRDesignGroup jrGroup = new JRDesignGroup();
        jrGroup.setName(group.getName());
        jrGroup.setReprintHeaderOnEachPage(group.isReprintHeaderOnEachPage());
        jrGroup.setStartNewColumn(group.isStartInNewColumn());
        jrGroup.setStartNewPage(group.isStartInNewPage());
        jrGroup.setResetPageNumber(group.isResetPageNumber());
        if (group.getMinHeightToStartNewPage() != null) {
            jrGroup.setMinHeightToStartNewPage(group.getMinHeightToStartNewPage().intValue());
        }
        jrGroup.setFooterPosition(ConstantTransform.groupFooterPosition(group.getFooterPosition()));
        jrGroup.setKeepTogether(group.isKeepTogether());
        return jrGroup;
    }

    public void transformExpressions() {
        for (DRIDesignGroup dRIDesignGroup : this.accessor.getReport().getGroups()) {
            this.getGroup(dRIDesignGroup).setExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(dRIDesignGroup.getGroupExpression()));
        }
    }

    public JRDesignGroup getGroup(DRIDesignGroup group) {
        JRDesignGroup jrGroup = (JRDesignGroup)this.accessor.getDesign().getGroupsMap().get(group.getName());
        if (jrGroup == null) {
            throw new JasperDesignException("Group " + group.getName() + " is not registered");
        }
        return jrGroup;
    }
}

