/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.jasper.transformation.expression;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.dynamicreports.design.base.DRDesignReport;
import net.sf.dynamicreports.design.base.expression.AbstractDesignComplexExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignExpression;
import net.sf.dynamicreports.jasper.base.JasperReportDesign;
import net.sf.dynamicreports.jasper.transformation.JasperTransform;
import net.sf.dynamicreports.report.ReportUtils;
import net.sf.dynamicreports.report.builder.ReportBuilder;
import net.sf.dynamicreports.report.definition.DRICustomValues;
import net.sf.dynamicreports.report.definition.DRIReport;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubreportExpression
extends AbstractDesignComplexExpression {
    private static final long serialVersionUID = 10000L;
    private static final Log log = LogFactory.getLog(SubreportExpression.class);
    private String name;
    private Integer pageWidth;
    private ReportBuilder<?> reportBuilder;
    private Map<ReportBuilder<?>, JasperReportDesign> reportDesigns;
    private Map<ReportBuilder<?>, JasperReport> jasperReports;

    public SubreportExpression(DRIDesignExpression pageWidthExpression, DRIDesignExpression reportExpression, Integer pageWidth) {
        this.addExpression(pageWidthExpression);
        this.addExpression(reportExpression);
        this.pageWidth = pageWidth;
        this.name = ReportUtils.generateUniqueName("subreportExpression");
        this.reportDesigns = new HashMap();
        this.jasperReports = new HashMap();
    }

    @Override
    public Object evaluate(List<?> values, ReportParameters reportParameters) {
        block5: {
            this.reportBuilder = (ReportBuilder)values.get(1);
            if (this.jasperReports.containsKey(this.reportBuilder)) {
                return this.jasperReports.get(this.reportBuilder);
            }
            try {
                DRICustomValues customValues = (DRICustomValues)reportParameters.getParameterValue("CUSTOM_VALUES");
                DRDesignReport report = new DRDesignReport((DRIReport)this.reportBuilder.build(), this.pageWidth, customValues.getTocHeadings());
                JasperReportDesign reportDesign = new JasperReportDesign(report, reportParameters, null);
                JasperTransform jasperTransform = new JasperTransform(report, reportDesign);
                jasperTransform.transform();
                JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)reportDesign.getDesign());
                this.reportDesigns.put(this.reportBuilder, reportDesign);
                this.jasperReports.put(this.reportBuilder, jasperReport);
                return jasperReport;
            }
            catch (JRException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Error encountered while creating subreport design", (Throwable)e);
                }
            }
            catch (DRException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Error encountered while creating subreport design", (Throwable)e);
            }
        }
        return null;
    }

    public JasperReportDesign getReportDesign() {
        return this.reportDesigns.get(this.reportBuilder);
    }

    public ReportBuilder<?> getReportBuilder() {
        return this.reportBuilder;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getValueClass() {
        return JasperReport.class;
    }
}

