/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.base;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import net.sf.dynamicreports.report.base.DRField;
import net.sf.dynamicreports.report.base.DRQuery;
import net.sf.dynamicreports.report.base.DRSort;
import net.sf.dynamicreports.report.base.DRVariable;
import net.sf.dynamicreports.report.definition.DRIDataset;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public class DRDataset
implements DRIDataset {
    private static final long serialVersionUID = 10000L;
    private List<DRField<?>> fields;
    private List<DRVariable<?>> variables;
    private List<DRSort> sorts;
    private DRQuery query;
    private DRIExpression<Connection> connectionExpression;
    private DRIExpression<?> dataSourceExpression;
    private DRIExpression<Boolean> filterExpression;

    public DRDataset() {
        this.init();
    }

    private void init() {
        this.fields = new ArrayList();
        this.variables = new ArrayList();
        this.sorts = new ArrayList<DRSort>();
    }

    public List<DRField<?>> getFields() {
        return this.fields;
    }

    public void setFields(List<DRField<?>> fields) {
        Validate.notNull(fields, (String)"fields must not be null", (Object[])new Object[0]);
        Validate.noNullElements(fields, (String)"fields must not contains null field", (Object[])new Object[0]);
        this.fields = fields;
    }

    public void addField(DRField<?> field) {
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        this.fields.add(field);
    }

    public List<DRVariable<?>> getVariables() {
        return this.variables;
    }

    public void setVariables(List<DRVariable<?>> variables) {
        Validate.notNull(variables, (String)"variables must not be null", (Object[])new Object[0]);
        Validate.noNullElements(variables, (String)"variables must not contains null variable", (Object[])new Object[0]);
        this.variables = variables;
    }

    public void addVariable(DRVariable<?> variable) {
        Validate.notNull(variable, (String)"variable must not be null", (Object[])new Object[0]);
        this.variables.add(variable);
    }

    public List<DRSort> getSorts() {
        return this.sorts;
    }

    public void setSorts(List<DRSort> sorts) {
        Validate.notNull(sorts, (String)"sorts must not be null", (Object[])new Object[0]);
        Validate.noNullElements(sorts, (String)"sorts must not contains null sort", (Object[])new Object[0]);
        this.sorts = sorts;
    }

    public void addSort(DRSort sort) {
        Validate.notNull((Object)sort, (String)"sort must not be null", (Object[])new Object[0]);
        this.sorts.add(sort);
    }

    @Override
    public DRQuery getQuery() {
        return this.query;
    }

    public void setQuery(DRQuery query) {
        this.query = query;
    }

    @Override
    public DRIExpression<Connection> getConnectionExpression() {
        return this.connectionExpression;
    }

    public void setConnectionExpression(DRIExpression<Connection> connectionExpression) {
        this.connectionExpression = connectionExpression;
    }

    @Override
    public DRIExpression<?> getDataSourceExpression() {
        return this.dataSourceExpression;
    }

    public void setDataSourceExpression(DRIExpression<?> dataSourceExpression) {
        this.dataSourceExpression = dataSourceExpression;
    }

    @Override
    public DRIExpression<Boolean> getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(DRIExpression<Boolean> filterExpression) {
        this.filterExpression = filterExpression;
    }
}

