/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.base.chart;

import java.util.ArrayList;
import java.util.List;
import net.sf.dynamicreports.report.base.chart.DRChartLegend;
import net.sf.dynamicreports.report.base.chart.DRChartSubtitle;
import net.sf.dynamicreports.report.base.chart.DRChartTitle;
import net.sf.dynamicreports.report.base.chart.dataset.DRCategoryDataset;
import net.sf.dynamicreports.report.base.chart.dataset.DRChartDataset;
import net.sf.dynamicreports.report.base.chart.dataset.DRHighLowDataset;
import net.sf.dynamicreports.report.base.chart.dataset.DRSeriesDataset;
import net.sf.dynamicreports.report.base.chart.dataset.DRTimeSeriesDataset;
import net.sf.dynamicreports.report.base.chart.dataset.DRValueDataset;
import net.sf.dynamicreports.report.base.chart.plot.DRAxisPlot;
import net.sf.dynamicreports.report.base.chart.plot.DRBar3DPlot;
import net.sf.dynamicreports.report.base.chart.plot.DRBarPlot;
import net.sf.dynamicreports.report.base.chart.plot.DRBubblePlot;
import net.sf.dynamicreports.report.base.chart.plot.DRCandlestickPlot;
import net.sf.dynamicreports.report.base.chart.plot.DRDifferencePlot;
import net.sf.dynamicreports.report.base.chart.plot.DRGroupedStackedBarPlot;
import net.sf.dynamicreports.report.base.chart.plot.DRHighLowPlot;
import net.sf.dynamicreports.report.base.chart.plot.DRLayeredBarPlot;
import net.sf.dynamicreports.report.base.chart.plot.DRLinePlot;
import net.sf.dynamicreports.report.base.chart.plot.DRMeterPlot;
import net.sf.dynamicreports.report.base.chart.plot.DRMultiAxisPlot;
import net.sf.dynamicreports.report.base.chart.plot.DRPie3DPlot;
import net.sf.dynamicreports.report.base.chart.plot.DRPiePlot;
import net.sf.dynamicreports.report.base.chart.plot.DRSpiderPlot;
import net.sf.dynamicreports.report.base.chart.plot.DRThermometerPlot;
import net.sf.dynamicreports.report.base.chart.plot.DRWaterfallBarPlot;
import net.sf.dynamicreports.report.base.chart.plot.DRXyBlockPlot;
import net.sf.dynamicreports.report.base.chart.plot.DRXyStepPlot;
import net.sf.dynamicreports.report.base.component.DRHyperLinkComponent;
import net.sf.dynamicreports.report.constant.ChartType;
import net.sf.dynamicreports.report.definition.chart.DRIChart;
import net.sf.dynamicreports.report.definition.chart.DRIChartCustomizer;
import net.sf.dynamicreports.report.definition.chart.plot.DRIPlot;
import net.sf.dynamicreports.report.exception.DRReportException;
import org.apache.commons.lang3.Validate;

public class DRChart
extends DRHyperLinkComponent
implements DRIChart {
    private static final long serialVersionUID = 10000L;
    private ChartType chartType;
    private DRChartDataset dataset;
    private DRIPlot plot;
    private List<DRIChartCustomizer> customizers;
    private DRChartTitle title;
    private DRChartSubtitle subtitle;
    private DRChartLegend legend;
    private String theme;

    public DRChart(ChartType chartType) {
        this.setChartType(chartType);
    }

    @Override
    protected void init() {
        super.init();
        this.customizers = new ArrayList<DRIChartCustomizer>();
        this.title = new DRChartTitle();
        this.subtitle = new DRChartSubtitle();
        this.legend = new DRChartLegend();
    }

    @Override
    public ChartType getChartType() {
        return this.chartType;
    }

    private void setChartType(ChartType chartType) {
        Validate.notNull((Object)((Object)chartType), (String)"chartType must not be null", (Object[])new Object[0]);
        this.chartType = chartType;
        switch (chartType) {
            case AREA: 
            case STACKEDAREA: {
                this.dataset = new DRCategoryDataset();
                this.plot = new DRAxisPlot();
                break;
            }
            case BAR: 
            case STACKEDBAR: {
                this.dataset = new DRCategoryDataset();
                this.plot = new DRBarPlot();
                break;
            }
            case GROUPEDSTACKEDBAR: {
                this.dataset = new DRCategoryDataset();
                this.plot = new DRGroupedStackedBarPlot();
                break;
            }
            case LAYEREDBAR: {
                this.dataset = new DRCategoryDataset();
                this.plot = new DRLayeredBarPlot();
                break;
            }
            case WATERFALLBAR: {
                this.dataset = new DRCategoryDataset();
                this.plot = new DRWaterfallBarPlot();
                break;
            }
            case BAR3D: 
            case STACKEDBAR3D: {
                this.dataset = new DRCategoryDataset();
                this.plot = new DRBar3DPlot();
                break;
            }
            case LINE: {
                this.dataset = new DRCategoryDataset();
                this.plot = new DRLinePlot();
                break;
            }
            case PIE: {
                this.dataset = new DRSeriesDataset();
                this.plot = new DRPiePlot();
                break;
            }
            case PIE3D: {
                this.dataset = new DRSeriesDataset();
                this.plot = new DRPie3DPlot();
                break;
            }
            case TIMESERIES: {
                this.dataset = new DRTimeSeriesDataset();
                this.plot = new DRLinePlot();
                break;
            }
            case DIFFERENCE: {
                this.dataset = new DRTimeSeriesDataset();
                this.plot = new DRDifferencePlot();
                break;
            }
            case XYAREA: {
                this.dataset = new DRSeriesDataset();
                this.plot = new DRAxisPlot();
                break;
            }
            case XYBAR: {
                this.dataset = new DRSeriesDataset();
                this.plot = new DRBarPlot();
                break;
            }
            case XYLINE: {
                this.dataset = new DRSeriesDataset();
                this.plot = new DRLinePlot();
                break;
            }
            case XYSTEP: {
                this.dataset = new DRSeriesDataset();
                this.plot = new DRXyStepPlot();
                break;
            }
            case SCATTER: {
                this.dataset = new DRSeriesDataset();
                this.plot = new DRLinePlot();
                break;
            }
            case SPIDER: {
                this.dataset = new DRCategoryDataset();
                this.plot = new DRSpiderPlot();
                break;
            }
            case MULTI_AXIS: {
                this.dataset = new DRChartDataset();
                this.plot = new DRMultiAxisPlot();
                break;
            }
            case XYBLOCK: {
                this.dataset = new DRSeriesDataset();
                this.plot = new DRXyBlockPlot();
                break;
            }
            case BUBBLE: {
                this.dataset = new DRSeriesDataset();
                this.plot = new DRBubblePlot();
                break;
            }
            case CANDLESTICK: {
                this.dataset = new DRHighLowDataset();
                this.plot = new DRCandlestickPlot();
                break;
            }
            case HIGHLOW: {
                this.dataset = new DRHighLowDataset();
                this.plot = new DRHighLowPlot();
                break;
            }
            case METER: {
                this.dataset = new DRValueDataset();
                this.plot = new DRMeterPlot();
                break;
            }
            case THERMOMETER: {
                this.dataset = new DRValueDataset();
                this.plot = new DRThermometerPlot();
                break;
            }
            case GANTT: {
                this.dataset = new DRSeriesDataset();
                this.plot = new DRBarPlot();
                break;
            }
            default: {
                throw new DRReportException("Chart type not supported.");
            }
        }
    }

    @Override
    public DRChartDataset getDataset() {
        return this.dataset;
    }

    @Override
    public DRIPlot getPlot() {
        return this.plot;
    }

    @Override
    public List<DRIChartCustomizer> getCustomizers() {
        return this.customizers;
    }

    public void setCustomizers(List<DRIChartCustomizer> customizers) {
        this.customizers = customizers;
    }

    public void addCustomizer(DRIChartCustomizer customizer) {
        this.customizers.add(customizer);
    }

    @Override
    public DRChartTitle getTitle() {
        return this.title;
    }

    public void setTitle(DRChartTitle title) {
        Validate.notNull((Object)title, (String)"title must not be null", (Object[])new Object[0]);
        this.title = title;
    }

    @Override
    public DRChartSubtitle getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(DRChartSubtitle subtitle) {
        Validate.notNull((Object)subtitle, (String)"subtitle must not be null", (Object[])new Object[0]);
        this.subtitle = subtitle;
    }

    @Override
    public DRChartLegend getLegend() {
        return this.legend;
    }

    public void setLegend(DRChartLegend legend) {
        Validate.notNull((Object)legend, (String)"legend must not be null", (Object[])new Object[0]);
        this.legend = legend;
    }

    @Override
    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }
}

