/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder;

import net.sf.dynamicreports.report.base.DRHyperLink;
import net.sf.dynamicreports.report.builder.AbstractBuilder;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.constant.HyperLinkTarget;
import net.sf.dynamicreports.report.constant.HyperLinkType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public class HyperLinkBuilder
extends AbstractBuilder<HyperLinkBuilder, DRHyperLink> {
    private static final long serialVersionUID = 10000L;

    protected HyperLinkBuilder() {
        super(new DRHyperLink());
    }

    protected HyperLinkBuilder(String link) {
        super(new DRHyperLink());
        this.setLink(link);
    }

    protected HyperLinkBuilder(DRIExpression<String> linkExpression) {
        super(new DRHyperLink());
        this.setLink(linkExpression);
    }

    public HyperLinkBuilder setLink(String link) {
        Validate.notNull((Object)link, (String)"link must not be null", (Object[])new Object[0]);
        return this.setLink(Expressions.text(link));
    }

    public HyperLinkBuilder setLink(DRIExpression<String> linkExpression) {
        Validate.notNull(linkExpression, (String)"linkExpression must not be null", (Object[])new Object[0]);
        ((DRHyperLink)this.getObject()).setReferenceExpression(linkExpression);
        ((DRHyperLink)this.getObject()).setType(HyperLinkType.REFERENCE.name());
        return this;
    }

    public HyperLinkBuilder setAnchor(String anchor) {
        ((DRHyperLink)this.getObject()).setAnchorExpression(Expressions.text(anchor));
        return this;
    }

    public HyperLinkBuilder setAnchor(DRIExpression<String> anchorExpression) {
        ((DRHyperLink)this.getObject()).setAnchorExpression(anchorExpression);
        return this;
    }

    public HyperLinkBuilder setPage(Integer page) {
        ((DRHyperLink)this.getObject()).setPageExpression(Expressions.value(page));
        return this;
    }

    public HyperLinkBuilder setPage(DRIExpression<Integer> pageExpression) {
        ((DRHyperLink)this.getObject()).setPageExpression(pageExpression);
        return this;
    }

    public HyperLinkBuilder setReference(String reference) {
        ((DRHyperLink)this.getObject()).setReferenceExpression(Expressions.text(reference));
        return this;
    }

    public HyperLinkBuilder setReference(DRIExpression<String> referenceExpression) {
        ((DRHyperLink)this.getObject()).setReferenceExpression(referenceExpression);
        return this;
    }

    public HyperLinkBuilder setTooltip(String tooltip) {
        ((DRHyperLink)this.getObject()).setTooltipExpression(Expressions.text(tooltip));
        return this;
    }

    public HyperLinkBuilder setTooltip(DRIExpression<String> tooltipExpression) {
        ((DRHyperLink)this.getObject()).setTooltipExpression(tooltipExpression);
        return this;
    }

    public HyperLinkBuilder setType(HyperLinkType hyperLinkType) {
        ((DRHyperLink)this.getObject()).setType(hyperLinkType.name());
        return this;
    }

    public HyperLinkBuilder setType(String hyperLinkType) {
        ((DRHyperLink)this.getObject()).setType(hyperLinkType);
        return this;
    }

    public HyperLinkBuilder setTarget(HyperLinkTarget hyperLinkTarget) {
        ((DRHyperLink)this.getObject()).setTarget(hyperLinkTarget.name());
        return this;
    }

    public HyperLinkBuilder setTarget(String hyperLinkTarget) {
        ((DRHyperLink)this.getObject()).setTarget(hyperLinkTarget);
        return this;
    }

    public DRHyperLink getHyperLink() {
        return (DRHyperLink)this.build();
    }
}

