/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.column;

import net.sf.dynamicreports.report.base.column.DRColumn;
import net.sf.dynamicreports.report.base.component.DRComponent;
import net.sf.dynamicreports.report.builder.AbstractBuilder;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.builder.grid.ColumnGridComponentBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.constant.ComponentDimensionType;
import net.sf.dynamicreports.report.constant.TextAdjust;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.expression.DRIPropertyExpression;

public abstract class ColumnBuilder<T extends ColumnBuilder<T, U>, U extends DRColumn<?>>
extends AbstractBuilder<T, U>
implements ColumnGridComponentBuilder {
    private static final long serialVersionUID = 10000L;

    protected ColumnBuilder(U column) {
        super(column);
    }

    public T setTitle(DRIExpression<?> titleExpression) {
        ((DRColumn)this.getObject()).setTitleExpression(titleExpression);
        return (T)this;
    }

    public T setTitle(String title) {
        ((DRColumn)this.getObject()).setTitleExpression(Expressions.text(title));
        return (T)this;
    }

    public T setTitleStyle(ReportStyleBuilder titleStyle) {
        if (titleStyle != null) {
            ((DRColumn)this.getObject()).setTitleStyle(titleStyle.getStyle());
        } else {
            ((DRColumn)this.getObject()).setTitleStyle(null);
        }
        return (T)this;
    }

    public T setStyle(ReportStyleBuilder style) {
        if (style != null) {
            this.getComponent().setStyle(style.getStyle());
        } else {
            this.getComponent().setStyle(null);
        }
        return (T)this;
    }

    public T setPrintWhenExpression(DRIExpression<Boolean> printWhenExpression) {
        this.getComponent().setPrintWhenExpression(printWhenExpression);
        return (T)this;
    }

    public T setTitleRows(Integer rows) {
        ((DRColumn)this.getObject()).setTitleRows(rows);
        return (T)this;
    }

    public T setTitleFixedRows(Integer rows) {
        ((DRColumn)this.getObject()).setTitleRows(rows);
        ((DRColumn)this.getObject()).setTitleHeightType(ComponentDimensionType.FIXED);
        return (T)this;
    }

    public T setTitleMinRows(Integer rows) {
        ((DRColumn)this.getObject()).setTitleRows(rows);
        ((DRColumn)this.getObject()).setTitleHeightType(ComponentDimensionType.EXPAND);
        return (T)this;
    }

    public T setTitleHeight(Integer height) {
        ((DRColumn)this.getObject()).setTitleHeight(height);
        return (T)this;
    }

    public T setTitleFixedHeight(Integer height) {
        ((DRColumn)this.getObject()).setTitleHeight(height);
        ((DRColumn)this.getObject()).setTitleHeightType(ComponentDimensionType.FIXED);
        return (T)this;
    }

    public T setTitleMinHeight(Integer height) {
        ((DRColumn)this.getObject()).setTitleHeight(height);
        ((DRColumn)this.getObject()).setTitleHeightType(ComponentDimensionType.EXPAND);
        return (T)this;
    }

    @Deprecated
    public T setTitleStretchWithOverflow(Boolean stretchWithOverflow) {
        ((DRColumn)this.getObject()).setTitleStretchWithOverflow(stretchWithOverflow);
        return (T)this;
    }

    public T setTitleTextAdjust(TextAdjust textAdjust) {
        ((DRColumn)this.getObject()).setTitleTextAdjust(textAdjust);
        return (T)this;
    }

    public T addTitleProperty(DRIPropertyExpression propertyExpression) {
        ((DRColumn)this.getObject()).addTitlePropertyExpression(propertyExpression);
        return (T)this;
    }

    public T addTitleProperty(String name, DRIExpression<String> valueExpression) {
        ((DRColumn)this.getObject()).addTitlePropertyExpression(Expressions.property(name, valueExpression));
        return (T)this;
    }

    public T addTitleProperty(String name, String value) {
        ((DRColumn)this.getObject()).addTitlePropertyExpression(Expressions.property(name, value));
        return (T)this;
    }

    protected DRComponent getComponent() {
        return (DRComponent)((DRColumn)this.getObject()).getComponent();
    }

    public U getColumn() {
        return (U)((DRColumn)this.build());
    }
}

