/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.column;

import net.sf.dynamicreports.report.base.column.DRColumn;
import net.sf.dynamicreports.report.base.component.DRComponent;
import net.sf.dynamicreports.report.base.component.DRDimensionComponent;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.constant.ComponentDimensionType;
import net.sf.dynamicreports.report.definition.component.DRIDimensionComponent;
import net.sf.dynamicreports.report.exception.DRReportException;

public class ComponentColumnBuilder
extends ColumnBuilder<ComponentColumnBuilder, DRColumn<DRComponent>> {
    private static final long serialVersionUID = 10000L;

    protected ComponentColumnBuilder(ComponentBuilder<?, ?> component) {
        super(new DRColumn(component.getComponent()));
    }

    public ComponentColumnBuilder setWidth(Integer width) {
        this.getDimensionComponent().setWidth(width);
        return this;
    }

    public ComponentColumnBuilder setFixedWidth(Integer width) {
        this.getDimensionComponent().setWidth(width);
        this.getDimensionComponent().setWidthType(ComponentDimensionType.FIXED);
        return this;
    }

    public ComponentColumnBuilder setMinWidth(Integer width) {
        this.getDimensionComponent().setWidth(width);
        this.getDimensionComponent().setWidthType(ComponentDimensionType.EXPAND);
        return this;
    }

    public ComponentColumnBuilder setHeight(Integer height) {
        this.getDimensionComponent().setHeight(height);
        return this;
    }

    public ComponentColumnBuilder setFixedHeight(Integer height) {
        this.getDimensionComponent().setHeight(height);
        this.getDimensionComponent().setHeightType(ComponentDimensionType.FIXED);
        return this;
    }

    public ComponentColumnBuilder setMinHeight(Integer height) {
        this.getDimensionComponent().setHeight(height);
        this.getDimensionComponent().setHeightType(ComponentDimensionType.EXPAND);
        return this;
    }

    private DRDimensionComponent getDimensionComponent() {
        if (!(((DRColumn)this.getObject()).getComponent() instanceof DRIDimensionComponent)) {
            throw new DRReportException("Column component" + ((DRComponent)((DRColumn)this.getObject()).getComponent()).getClass().getName() + "is not a dimension component.");
        }
        return (DRDimensionComponent)((DRColumn)this.getObject()).getComponent();
    }
}

