/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.condition;

import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.ReportParameters;
import org.apache.commons.lang3.Validate;

public abstract class AbstractValuesExpression<T extends Number>
extends AbstractSimpleExpression<Boolean> {
    private static final long serialVersionUID = 10000L;
    private DRIValue<T> value;
    private Number[] numbers;

    public AbstractValuesExpression(DRIValue<T> value, Number ... numbers) {
        Validate.notNull(value, (String)"value must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])numbers, (String)"numbers must not contains null number", (Object[])new Object[0]);
        this.value = value;
        this.numbers = numbers;
    }

    @Override
    public Boolean evaluate(ReportParameters reportParameters) {
        Number actualValue = (Number)reportParameters.getValue(this.value);
        if (actualValue != null) {
            return this.compare(actualValue, this.numbers);
        }
        return false;
    }

    @Override
    public Class<Boolean> getValueClass() {
        return Boolean.class;
    }

    protected abstract Boolean compare(Number var1, Number[] var2);
}

