/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.HeaderUtil;
import net.lingala.zip4j.headers.HeaderWriter;
import net.lingala.zip4j.io.outputstream.SplitOutputStream;
import net.lingala.zip4j.io.outputstream.ZipOutputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AsyncZipTask;
import net.lingala.zip4j.tasks.RemoveEntryFromZipFileTask;
import net.lingala.zip4j.util.CrcUtil;
import net.lingala.zip4j.util.FileUtils;
import net.lingala.zip4j.util.Zip4jUtil;

public abstract class AbstractAddFileToZipTask<T>
extends AsyncZipTask<T> {
    private ZipModel zipModel;
    private char[] password;
    private HeaderWriter headerWriter;

    AbstractAddFileToZipTask(ProgressMonitor progressMonitor, boolean runInThread, ZipModel zipModel, char[] password, HeaderWriter headerWriter) {
        super(progressMonitor, runInThread);
        this.zipModel = zipModel;
        this.password = password;
        this.headerWriter = headerWriter;
    }

    void addFilesToZip(List<File> filesToAdd, ProgressMonitor progressMonitor, ZipParameters zipParameters, Charset charset) throws IOException {
        List<File> updatedFilesToAdd = this.removeFilesIfExists(filesToAdd, zipParameters, progressMonitor, charset);
        try (SplitOutputStream splitOutputStream = new SplitOutputStream(this.zipModel.getZipFile(), this.zipModel.getSplitLength());
             ZipOutputStream zipOutputStream = this.initializeOutputStream(splitOutputStream, charset);){
            byte[] readBuff = new byte[4096];
            int readLen = -1;
            for (File fileToAdd : updatedFilesToAdd) {
                this.verifyIfTaskIsCancelled();
                ZipParameters clonedZipParameters = this.cloneAndAdjustZipParameters(zipParameters, fileToAdd, progressMonitor);
                progressMonitor.setFileName(fileToAdd.getAbsolutePath());
                zipOutputStream.putNextEntry(clonedZipParameters);
                if (fileToAdd.isDirectory()) {
                    zipOutputStream.closeEntry();
                    continue;
                }
                try (FileInputStream inputStream = new FileInputStream(fileToAdd);){
                    while ((readLen = ((InputStream)inputStream).read(readBuff)) != -1) {
                        zipOutputStream.write(readBuff, 0, readLen);
                        progressMonitor.updateWorkCompleted(readLen);
                        this.verifyIfTaskIsCancelled();
                    }
                }
                FileHeader fileHeader = zipOutputStream.closeEntry();
                fileHeader.setExternalFileAttributes(FileUtils.getFileAttributes(fileToAdd));
                this.updateLocalFileHeader(fileHeader, splitOutputStream);
            }
        }
    }

    long calculateWorkForFiles(List<File> filesToAdd, ZipParameters zipParameters) throws ZipException {
        long totalWork = 0L;
        for (File fileToAdd : filesToAdd) {
            if (!fileToAdd.exists()) continue;
            totalWork = zipParameters.isEncryptFiles() && zipParameters.getEncryptionMethod() == EncryptionMethod.ZIP_STANDARD ? (totalWork += fileToAdd.length() * 2L) : (totalWork += fileToAdd.length());
            String relativeFileName = FileUtils.getRelativeFileName(fileToAdd.getAbsolutePath(), zipParameters.getDefaultFolderPath());
            FileHeader fileHeader = HeaderUtil.getFileHeader(this.getZipModel(), relativeFileName);
            if (fileHeader == null) continue;
            totalWork += this.getZipModel().getZipFile().length() - fileHeader.getCompressedSize();
        }
        return totalWork;
    }

    ZipOutputStream initializeOutputStream(SplitOutputStream splitOutputStream, Charset charset) throws IOException {
        if (this.zipModel.getZipFile().exists()) {
            if (this.zipModel.getEndOfCentralDirectoryRecord() == null) {
                throw new ZipException("invalid end of central directory record");
            }
            splitOutputStream.seek(this.zipModel.getEndOfCentralDirectoryRecord().getOffsetOfStartOfCentralDirectory());
        }
        return new ZipOutputStream(splitOutputStream, this.password, charset, this.zipModel);
    }

    void verifyZipParameters(ZipParameters parameters) throws ZipException {
        if (parameters == null) {
            throw new ZipException("cannot validate zip parameters");
        }
        if (parameters.getCompressionMethod() != CompressionMethod.STORE && parameters.getCompressionMethod() != CompressionMethod.DEFLATE) {
            throw new ZipException("unsupported compression type");
        }
        if (parameters.isEncryptFiles()) {
            if (parameters.getEncryptionMethod() == EncryptionMethod.NONE) {
                throw new ZipException("Encryption method has to be set, when encrypt files flag is set");
            }
            if (this.password == null || this.password.length <= 0) {
                throw new ZipException("input password is empty or null");
            }
        } else {
            parameters.setEncryptionMethod(EncryptionMethod.NONE);
        }
    }

    void updateLocalFileHeader(FileHeader fileHeader, SplitOutputStream splitOutputStream) throws IOException {
        this.headerWriter.updateLocalFileHeader(fileHeader, this.getZipModel(), splitOutputStream);
    }

    private ZipParameters cloneAndAdjustZipParameters(ZipParameters zipParameters, File fileToAdd, ProgressMonitor progressMonitor) throws IOException {
        ZipParameters clonedZipParameters = new ZipParameters(zipParameters);
        clonedZipParameters.setLastModifiedFileTime(Zip4jUtil.javaToDosTime(fileToAdd.lastModified()));
        if (fileToAdd.isDirectory()) {
            clonedZipParameters.setEntrySize(0L);
        } else {
            clonedZipParameters.setEntrySize(fileToAdd.length());
        }
        clonedZipParameters.setWriteExtendedLocalFileHeader(false);
        clonedZipParameters.setLastModifiedFileTime(fileToAdd.lastModified());
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(zipParameters.getFileNameInZip())) {
            String relativeFileName = FileUtils.getRelativeFileName(fileToAdd.getAbsolutePath(), zipParameters.getDefaultFolderPath());
            clonedZipParameters.setFileNameInZip(relativeFileName);
        }
        if (fileToAdd.isDirectory()) {
            clonedZipParameters.setCompressionMethod(CompressionMethod.STORE);
            clonedZipParameters.setEncryptionMethod(EncryptionMethod.NONE);
            clonedZipParameters.setEncryptFiles(false);
        } else {
            if (clonedZipParameters.isEncryptFiles() && clonedZipParameters.getEncryptionMethod() == EncryptionMethod.ZIP_STANDARD) {
                progressMonitor.setCurrentTask(ProgressMonitor.Task.CALCULATE_CRC);
                clonedZipParameters.setEntryCRC(CrcUtil.computeFileCrc(fileToAdd, progressMonitor));
                progressMonitor.setCurrentTask(ProgressMonitor.Task.ADD_ENTRY);
            }
            if (fileToAdd.length() == 0L) {
                clonedZipParameters.setCompressionMethod(CompressionMethod.STORE);
            }
        }
        return clonedZipParameters;
    }

    private List<File> removeFilesIfExists(List<File> files, ZipParameters zipParameters, ProgressMonitor progressMonitor, Charset charset) throws ZipException {
        ArrayList<File> filesToAdd = new ArrayList<File>(files);
        if (!this.zipModel.getZipFile().exists()) {
            return filesToAdd;
        }
        for (File file : files) {
            String fileName = FileUtils.getRelativeFileName(file.getAbsolutePath(), zipParameters.getDefaultFolderPath());
            FileHeader fileHeader = HeaderUtil.getFileHeader(this.zipModel, fileName);
            if (fileHeader == null) continue;
            if (zipParameters.isOverrideExistingFilesInZip()) {
                progressMonitor.setCurrentTask(ProgressMonitor.Task.REMOVE_ENTRY);
                this.removeFile(fileHeader, progressMonitor, charset);
                this.verifyIfTaskIsCancelled();
                progressMonitor.setCurrentTask(ProgressMonitor.Task.ADD_ENTRY);
                continue;
            }
            filesToAdd.remove(file);
        }
        return filesToAdd;
    }

    private void removeFile(FileHeader fileHeader, ProgressMonitor progressMonitor, Charset charset) throws ZipException {
        RemoveEntryFromZipFileTask removeEntryFromZipFileTask = new RemoveEntryFromZipFileTask(progressMonitor, false, this.zipModel);
        removeEntryFromZipFileTask.execute(new RemoveEntryFromZipFileTask.RemoveEntryFromZipFileTaskParameters(fileHeader, charset));
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return ProgressMonitor.Task.ADD_ENTRY;
    }

    protected ZipModel getZipModel() {
        return this.zipModel;
    }
}

