/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AsyncZipTask;
import net.lingala.zip4j.util.InternalZipConstants;
import net.lingala.zip4j.util.UnzipUtil;
import net.lingala.zip4j.util.Zip4jUtil;

public abstract class AbstractExtractFileTask<T>
extends AsyncZipTask<T> {
    private ZipModel zipModel;
    private byte[] buff = new byte[4096];

    public AbstractExtractFileTask(ProgressMonitor progressMonitor, boolean runInThread, ZipModel zipModel) {
        super(progressMonitor, runInThread);
        this.zipModel = zipModel;
    }

    protected void extractFile(ZipInputStream zipInputStream, FileHeader fileHeader, String outPath, String newFileName, ProgressMonitor progressMonitor) throws IOException {
        progressMonitor.setFileName(fileHeader.getFileName());
        if (!outPath.endsWith(InternalZipConstants.FILE_SEPARATOR)) {
            outPath = outPath + InternalZipConstants.FILE_SEPARATOR;
        }
        String fileName = fileHeader.getFileName();
        String completePath = outPath + fileName;
        if (!new File(completePath).getCanonicalPath().startsWith(new File(outPath).getCanonicalPath())) {
            throw new ZipException("illegal file name that breaks out of the target directory: " + fileHeader.getFileName());
        }
        this.verifyNextEntry(zipInputStream, fileHeader);
        if (fileHeader.isDirectory()) {
            File file = new File(completePath);
            if (!file.exists() && !file.mkdirs()) {
                throw new ZipException("Could not create directory: " + file);
            }
        } else {
            this.checkOutputDirectoryStructure(fileHeader, outPath, newFileName);
            this.unzipFile(zipInputStream, fileHeader, outPath, newFileName, progressMonitor);
        }
    }

    private void unzipFile(ZipInputStream inputStream, FileHeader fileHeader, String outputPath, String newFileName, ProgressMonitor progressMonitor) throws IOException {
        String outputFileName = Zip4jUtil.isStringNotNullAndNotEmpty(newFileName) ? newFileName : fileHeader.getFileName();
        File outputFile = new File(outputPath + System.getProperty("file.separator") + outputFileName);
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            int readLength;
            while ((readLength = inputStream.read(this.buff)) != -1) {
                ((OutputStream)outputStream).write(this.buff, 0, readLength);
                progressMonitor.updateWorkCompleted(readLength);
                this.verifyIfTaskIsCancelled();
            }
        }
        catch (Exception e) {
            if (outputFile.exists()) {
                outputFile.delete();
            }
            throw e;
        }
        UnzipUtil.applyFileAttributes(fileHeader, outputFile);
    }

    private void verifyNextEntry(ZipInputStream zipInputStream, FileHeader fileHeader) throws IOException {
        LocalFileHeader localFileHeader = zipInputStream.getNextEntry(fileHeader);
        if (localFileHeader == null) {
            throw new ZipException("Could not read corresponding local file header for file header: " + fileHeader.getFileName());
        }
        if (!fileHeader.getFileName().equals(localFileHeader.getFileName())) {
            throw new ZipException("File header and local file header mismatch");
        }
    }

    private void checkOutputDirectoryStructure(FileHeader fileHeader, String outPath, String newFileName) throws ZipException {
        String fileName = fileHeader.getFileName();
        if (Zip4jUtil.isStringNotNullAndNotEmpty(newFileName)) {
            fileName = newFileName;
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(fileName)) {
            return;
        }
        String compOutPath = outPath + fileName;
        File file = new File(compOutPath);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new ZipException("Unable to create parent directories: " + file.getParentFile());
        }
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return ProgressMonitor.Task.EXTRACT_ENTRY;
    }

    public ZipModel getZipModel() {
        return this.zipModel;
    }
}

