/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.network.windows;

import java.util.HashMap;
import java.util.Map;
import org.jutils.jhardware.info.network.AbstractNetworkInfo;
import org.jutils.jhardware.util.HardwareInfoUtils;

public final class WindowsNetworkInfo
extends AbstractNetworkInfo {
    private static String getNetworkData() {
        return HardwareInfoUtils.executeCommand("ipconfig", "/all");
    }

    private static String getNetstatData() {
        return HardwareInfoUtils.executeCommand("netstat", "-e");
    }

    @Override
    protected Map<String, String> parseInfo() {
        String[] dataStringLines;
        HashMap<String, String> networkDataMap = new HashMap<String, String>();
        String receivedBytes = null;
        String transmittedBytes = null;
        String receivedPackets = null;
        String transmittedPackets = null;
        String netstatData = WindowsNetworkInfo.getNetstatData();
        String[] stringArray = dataStringLines = netstatData.split("\\r?\\n");
        int n = dataStringLines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] infos;
            String dataLine = stringArray[n2];
            if (dataLine.startsWith("Bytes") || dataLine.startsWith("Octets")) {
                infos = dataLine.split("\\s+");
                receivedBytes = infos[infos.length - 2];
                transmittedBytes = infos[infos.length - 1];
            } else if (dataLine.startsWith("Unicast") || dataLine.contains("monodiffusion")) {
                infos = dataLine.split("\\s+");
                receivedPackets = infos[infos.length - 2];
                transmittedPackets = infos[infos.length - 1];
            }
            ++n2;
        }
        String networkData = WindowsNetworkInfo.getNetworkData();
        dataStringLines = networkData.split("\\r?\\n");
        boolean reading = false;
        int count = 0;
        String[] stringArray2 = dataStringLines;
        int n3 = dataStringLines.length;
        int n4 = 0;
        while (n4 < n3) {
            String dataLine = stringArray2[n4];
            if (!(dataLine.trim().isEmpty() || dataLine.startsWith(" ") || dataLine.startsWith("\t"))) {
                reading = false;
                if (!WindowsNetworkInfo.multiContains(dataLine, "Windows", "IP")) {
                    reading = true;
                    networkDataMap.put("interface_" + ++count, dataLine);
                }
            } else if (reading) {
                if (dataLine.contains("IP Address") || dataLine.contains("IPv4")) {
                    networkDataMap.put("ipv4_" + count, WindowsNetworkInfo.getValueFromDataLine(dataLine));
                }
                if (WindowsNetworkInfo.multiContains(dataLine, "IPv6", "Address") || WindowsNetworkInfo.multiContains(dataLine, "IPv6", "Adresse")) {
                    networkDataMap.put("ipv6_" + count, WindowsNetworkInfo.getValueFromDataLine(dataLine));
                }
                if ((dataLine.toLowerCase().contains("gateway") || dataLine.toLowerCase().contains("passerelle")) && WindowsNetworkInfo.getValueFromDataLine(dataLine) != null) {
                    networkDataMap.put("received_packets_" + count, receivedPackets);
                    networkDataMap.put("transmitted_packets_" + count, transmittedPackets);
                    networkDataMap.put("received_bytes_" + count, receivedBytes);
                    networkDataMap.put("transmitted_bytes_" + count, transmittedBytes);
                }
            }
            ++n4;
        }
        networkDataMap.put("interfacesLength", String.valueOf(count));
        return networkDataMap;
    }

    private static String getValueFromDataLine(String dataLine) {
        String[] data = dataLine.split(":", 2);
        if (data.length > 1 && !data[1].isEmpty()) {
            return data[1];
        }
        return null;
    }

    private static boolean multiContains(String baseString, String ... args) {
        if (baseString == null || baseString.isEmpty()) {
            return false;
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (!baseString.contains(arg)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

