/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.base;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import net.sf.dynamicreports.design.base.DRDesignBand;
import net.sf.dynamicreports.design.base.DRDesignGroup;
import net.sf.dynamicreports.design.base.DRDesignPage;
import net.sf.dynamicreports.design.base.DRDesignQuery;
import net.sf.dynamicreports.design.definition.DRIDesignDataset;
import net.sf.dynamicreports.design.definition.DRIDesignField;
import net.sf.dynamicreports.design.definition.DRIDesignParameter;
import net.sf.dynamicreports.design.definition.DRIDesignReport;
import net.sf.dynamicreports.design.definition.DRIDesignSort;
import net.sf.dynamicreports.design.definition.DRIDesignTemplateDesign;
import net.sf.dynamicreports.design.definition.DRIDesignVariable;
import net.sf.dynamicreports.design.definition.expression.DRIDesignComplexExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignJasperExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignSimpleExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignSystemExpression;
import net.sf.dynamicreports.design.definition.style.DRIDesignStyle;
import net.sf.dynamicreports.design.transformation.AbstractExpressionTransform;
import net.sf.dynamicreports.design.transformation.BandTransform;
import net.sf.dynamicreports.design.transformation.BarcodeTransform;
import net.sf.dynamicreports.design.transformation.ChartTransform;
import net.sf.dynamicreports.design.transformation.ColumnGridTransform;
import net.sf.dynamicreports.design.transformation.ColumnTransform;
import net.sf.dynamicreports.design.transformation.ComponentTransform;
import net.sf.dynamicreports.design.transformation.CrosstabTransform;
import net.sf.dynamicreports.design.transformation.DatasetTransform;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.design.transformation.GroupTransform;
import net.sf.dynamicreports.design.transformation.MainDatasetExpressionTransform;
import net.sf.dynamicreports.design.transformation.PageTransform;
import net.sf.dynamicreports.design.transformation.ReportTransform;
import net.sf.dynamicreports.design.transformation.StyleTransform;
import net.sf.dynamicreports.design.transformation.SubtotalTransform;
import net.sf.dynamicreports.design.transformation.TableOfContentsTransform;
import net.sf.dynamicreports.design.transformation.TemplateTransform;
import net.sf.dynamicreports.jasper.base.tableofcontents.JasperTocHeading;
import net.sf.dynamicreports.report.constant.Orientation;
import net.sf.dynamicreports.report.constant.RunDirection;
import net.sf.dynamicreports.report.constant.WhenNoDataType;
import net.sf.dynamicreports.report.constant.WhenResourceMissingType;
import net.sf.dynamicreports.report.definition.DRIDataset;
import net.sf.dynamicreports.report.definition.DRIReport;
import net.sf.dynamicreports.report.definition.DRIScriptlet;
import net.sf.dynamicreports.report.definition.DRITableOfContentsCustomizer;
import net.sf.dynamicreports.report.exception.DRException;

public class DRDesignReport
implements DesignTransformAccessor,
DRIDesignReport {
    private static final long serialVersionUID = 10000L;
    private DRIReport report;
    private Integer pageWidth;
    private Map<String, JasperTocHeading> tocHeadings;
    private ReportTransform reportTransform;
    private TemplateTransform templateTransform;
    private PageTransform pageTransform;
    private MainDatasetExpressionTransform mainDatasetExpressionTransform;
    private BandTransform bandTransform;
    private ComponentTransform componentTransform;
    private GroupTransform groupTransform;
    private ColumnGridTransform columnGridTransform;
    private ColumnTransform columnTransform;
    private SubtotalTransform subtotalTransform;
    private StyleTransform styleTransform;
    private ChartTransform chartTransform;
    private BarcodeTransform barcodeTransform;
    private CrosstabTransform crosstabTransform;
    private DatasetTransform datasetTransform;
    private TableOfContentsTransform tableOfContentsTransform;
    private AbstractExpressionTransform expressionTransform;

    public DRDesignReport(DRIReport report) throws DRException {
        this(report, null, null);
    }

    public DRDesignReport(DRIReport report, Integer pageWidth, Map<String, JasperTocHeading> tocHeadings) throws DRException {
        this.report = report;
        this.pageWidth = pageWidth;
        this.tocHeadings = tocHeadings;
        this.init();
        this.transform();
    }

    private void init() {
        this.reportTransform = new ReportTransform(this);
        this.templateTransform = new TemplateTransform(this);
        this.pageTransform = new PageTransform(this);
        this.mainDatasetExpressionTransform = new MainDatasetExpressionTransform(this);
        this.groupTransform = new GroupTransform(this);
        this.bandTransform = new BandTransform(this);
        this.componentTransform = new ComponentTransform(this);
        this.columnGridTransform = new ColumnGridTransform(this);
        this.columnTransform = new ColumnTransform(this);
        this.subtotalTransform = new SubtotalTransform(this);
        this.styleTransform = new StyleTransform(this);
        this.chartTransform = new ChartTransform(this);
        this.barcodeTransform = new BarcodeTransform(this);
        this.crosstabTransform = new CrosstabTransform(this);
        this.datasetTransform = new DatasetTransform(this);
        this.tableOfContentsTransform = new TableOfContentsTransform(this);
        this.transformToMainDataset();
    }

    private void transform() throws DRException {
        this.reportTransform.transform();
        this.pageTransform.transform();
        this.groupTransform.transform();
        this.mainDatasetExpressionTransform.transform();
        this.bandTransform.transform();
        this.columnGridTransform.transform();
        this.columnTransform.transform();
        this.groupTransform.transformHeaderAndFooter();
        this.pageTransform.transformPageWidth();
        this.subtotalTransform.transform();
        this.bandTransform.prepareBands();
        this.styleTransform.transformTemplateStyles();
    }

    @Override
    public DRIReport getReport() {
        return this.report;
    }

    @Override
    public Integer getPageWidth() {
        return this.pageWidth;
    }

    @Override
    public ReportTransform getReportTransform() {
        return this.reportTransform;
    }

    @Override
    public TemplateTransform getTemplateTransform() {
        return this.templateTransform;
    }

    @Override
    public PageTransform getPageTransform() {
        return this.pageTransform;
    }

    @Override
    public void transformToMainDataset() {
        this.transformToDataset(null);
    }

    @Override
    public void transformToDataset(DRIDataset dataset) {
        this.expressionTransform = dataset != null ? this.datasetTransform.getDatasetExpressionTransform(dataset) : this.mainDatasetExpressionTransform;
    }

    @Override
    public AbstractExpressionTransform getExpressionTransform() {
        return this.expressionTransform;
    }

    @Override
    public BandTransform getBandTransform() {
        return this.bandTransform;
    }

    @Override
    public ComponentTransform getComponentTransform() {
        return this.componentTransform;
    }

    @Override
    public GroupTransform getGroupTransform() {
        return this.groupTransform;
    }

    @Override
    public ColumnTransform getColumnTransform() {
        return this.columnTransform;
    }

    @Override
    public ColumnGridTransform getColumnGridTransform() {
        return this.columnGridTransform;
    }

    @Override
    public StyleTransform getStyleTransform() {
        return this.styleTransform;
    }

    @Override
    public ChartTransform getChartTransform() {
        return this.chartTransform;
    }

    @Override
    public BarcodeTransform getBarcodeTransform() {
        return this.barcodeTransform;
    }

    @Override
    public CrosstabTransform getCrosstabTransform() {
        return this.crosstabTransform;
    }

    @Override
    public DatasetTransform getDatasetTransform() {
        return this.datasetTransform;
    }

    @Override
    public TableOfContentsTransform getTableOfContentsTransform() {
        return this.tableOfContentsTransform;
    }

    @Override
    public DRIDesignTemplateDesign getTemplateDesign() {
        return this.reportTransform.getTemplateDesign();
    }

    @Override
    public String getReportName() {
        return this.templateTransform.getReportName();
    }

    @Override
    public Locale getLocale() {
        return this.templateTransform.getLocale();
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.report.getResourceBundle();
    }

    @Override
    public String getResourceBundleName() {
        return this.templateTransform.getResourceBundleName();
    }

    @Override
    public boolean isIgnorePagination() {
        return this.templateTransform.isIgnorePagination();
    }

    @Override
    public Properties getProperties() {
        return this.report.getProperties();
    }

    @Override
    public DRDesignQuery getQuery() {
        return this.reportTransform.getQuery();
    }

    @Override
    public DRDesignPage getPage() {
        return this.pageTransform.getPage();
    }

    @Override
    public WhenNoDataType getWhenNoDataType() {
        return this.templateTransform.getWhenNoDataType(this.getDetailBands().isEmpty(), this.getNoDataBand());
    }

    @Override
    public WhenResourceMissingType getWhenResourceMissingType() {
        return this.templateTransform.getWhenResourceMissingType();
    }

    @Override
    public boolean isTitleOnANewPage() {
        return this.templateTransform.isTitleOnANewPage();
    }

    @Override
    public boolean isSummaryOnANewPage() {
        return this.templateTransform.isSummaryOnANewPage();
    }

    @Override
    public boolean isSummaryWithPageHeaderAndFooter() {
        return this.templateTransform.isSummaryWithPageHeaderAndFooter();
    }

    @Override
    public boolean isFloatColumnFooter() {
        return this.templateTransform.isFloatColumnFooter();
    }

    @Override
    public Orientation getPrintOrder() {
        return this.templateTransform.getPrintOrder();
    }

    @Override
    public RunDirection getColumnDirection() {
        return this.templateTransform.getColumnDirection();
    }

    @Override
    public String getLanguage() {
        return this.templateTransform.getLanguage();
    }

    @Override
    public boolean isTableOfContents() {
        return this.templateTransform.isTableOfContents(this.tocHeadings);
    }

    @Override
    public Map<String, JasperTocHeading> getTableOfContentsHeadings() {
        return this.tocHeadings;
    }

    @Override
    public DRITableOfContentsCustomizer getTableOfContentsCustomizer() {
        return this.templateTransform.getTableOfContentsCustomizer();
    }

    @Override
    public DRIDesignExpression getFilterExpression() {
        return this.reportTransform.getFilterExpression();
    }

    @Override
    public Collection<DRIDesignParameter> getParameters() {
        return this.reportTransform.getParameters();
    }

    @Override
    public Map<String, Object> getParameterValues() {
        return this.report.getParameterValues();
    }

    @Override
    public Collection<DRIScriptlet> getScriptlets() {
        return this.report.getScriptlets();
    }

    @Override
    public Collection<DRIDesignField> getFields() {
        return this.mainDatasetExpressionTransform.getFields();
    }

    @Override
    public Collection<DRIDesignSystemExpression> getSystemExpressions() {
        return this.mainDatasetExpressionTransform.getSystemExpressions();
    }

    @Override
    public Collection<DRIDesignJasperExpression> getJasperExpressions() {
        return this.mainDatasetExpressionTransform.getJasperExpressions();
    }

    @Override
    public Collection<DRIDesignSimpleExpression> getSimpleExpressions() {
        return this.mainDatasetExpressionTransform.getSimpleExpressions();
    }

    @Override
    public Collection<DRIDesignStyle> getStyles() {
        return this.styleTransform.getStyles();
    }

    public Collection<DRDesignGroup> getGroups() {
        return this.groupTransform.getGroups();
    }

    @Override
    public Collection<DRIDesignVariable> getVariables() {
        return this.mainDatasetExpressionTransform.getVariables();
    }

    @Override
    public Collection<DRIDesignComplexExpression> getComplexExpressions() {
        return this.mainDatasetExpressionTransform.getComplexExpressions();
    }

    @Override
    public Collection<DRIDesignSort> getSorts() {
        return this.mainDatasetExpressionTransform.getSorts();
    }

    @Override
    public Collection<DRIDesignDataset> getDatasets() {
        return this.datasetTransform.getDatasets();
    }

    @Override
    public DRDesignBand getTitleBand() {
        return this.bandTransform.getTitleBand();
    }

    @Override
    public DRDesignBand getPageHeaderBand() {
        return this.bandTransform.getPageHeaderBand();
    }

    @Override
    public DRDesignBand getPageFooterBand() {
        return this.bandTransform.getPageFooterBand();
    }

    @Override
    public DRDesignBand getColumnHeaderBand() {
        return this.bandTransform.getColumnHeaderBand();
    }

    @Override
    public DRDesignBand getColumnFooterBand() {
        return this.bandTransform.getColumnFooterBand();
    }

    public List<DRDesignBand> getDetailBands() {
        return this.bandTransform.getDetailBands();
    }

    @Override
    public DRDesignBand getLastPageFooterBand() {
        return this.bandTransform.getLastPageFooterBand();
    }

    @Override
    public DRDesignBand getSummaryBand() {
        return this.bandTransform.getSummaryBand();
    }

    @Override
    public DRDesignBand getNoDataBand() {
        return this.bandTransform.getNoDataBand();
    }

    @Override
    public DRDesignBand getBackgroundBand() {
        return this.bandTransform.getBackgroundBand();
    }
}

