/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.dynamicreports.design.base.DRDesignBand;
import net.sf.dynamicreports.design.base.component.DRDesignComponent;
import net.sf.dynamicreports.design.base.component.DRDesignFiller;
import net.sf.dynamicreports.design.base.component.DRDesignList;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstab;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstabCell;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstabCellContent;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstabColumnGroup;
import net.sf.dynamicreports.design.base.crosstab.DRDesignCrosstabRowGroup;
import net.sf.dynamicreports.design.constant.ComponentGroupType;
import net.sf.dynamicreports.design.transformation.ComponentPosition;
import net.sf.dynamicreports.design.transformation.DesignTransformAccessor;
import net.sf.dynamicreports.design.transformation.StyleResolver;
import net.sf.dynamicreports.report.constant.StretchType;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstab;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabColumnGroup;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabRowGroup;
import net.sf.dynamicreports.report.exception.DRException;

class BandComponentsTransform {
    private DesignTransformAccessor accessor;
    private Map<String, Integer> componentNames;

    public BandComponentsTransform(DesignTransformAccessor accessor) {
        this.accessor = accessor;
        this.componentNames = new HashMap<String, Integer>();
    }

    public DRDesignBand prepareBand(DRDesignBand band, int maxWidth, int templateDesignComponents) throws DRException {
        if (band == null) {
            return null;
        }
        if (band.getBandComponent() != null) {
            return band;
        }
        DRDesignComponent component = this.prepareList(band.getName(), band.getList(), maxWidth);
        if (component == null && (band.getList() == null || band.getList().getHeight() == null || band.getList().getHeight() == 0)) {
            return null;
        }
        band.setHeight(band.getList().getHeight());
        band.setBandComponent(component);
        if (band.getBandComponent() != null && templateDesignComponents > 0) {
            throw new DRException("Band " + band.getName() + " must not be defined at once in jrxml template design and in dynamic design");
        }
        this.prepareListBackgroundComponents(component);
        this.prepareCrosstabs(component);
        return band;
    }

    private DRDesignComponent prepareList(String name, DRDesignList list, int maxWidth) throws DRException {
        return this.prepareList(name, list, maxWidth, -1);
    }

    private DRDesignComponent prepareList(String name, DRDesignList list, int maxWidth, int maxHeight) throws DRException {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        ComponentPosition.component(name, list, maxWidth, maxHeight);
        DRDesignComponent component = this.removeEmptyComponents(list);
        if (component == null) {
            return null;
        }
        this.componentGroupType(component);
        this.generateComponentNames(component, name);
        return component;
    }

    private void generateComponentNames(DRDesignComponent component, String bandName) {
        String componentName = bandName + "." + component.getUniqueName();
        if (!this.componentNames.containsKey(componentName)) {
            this.componentNames.put(componentName, 1);
        } else {
            this.componentNames.put(componentName, this.componentNames.get(componentName) + 1);
        }
        component.setUniqueName(componentName + this.componentNames.get(componentName));
        if (component instanceof DRDesignList) {
            DRDesignList list = (DRDesignList)component;
            for (DRDesignComponent lComponent : list.getComponents()) {
                this.generateComponentNames(lComponent, bandName);
            }
            if (list.getBackgroundComponent() != null) {
                list.getBackgroundComponent().setUniqueName(component.getUniqueName() + ".background");
            }
        }
    }

    private DRDesignComponent removeEmptyComponents(DRDesignComponent component) {
        if (component instanceof DRDesignList) {
            DRDesignList list = (DRDesignList)component;
            if (list.getComponents().isEmpty()) {
                return null;
            }
            if (list.getComponents().size() == 1) {
                DRDesignComponent lComponent = list.getComponents().get(0);
                DRDesignComponent elm = this.removeEmptyComponents(lComponent);
                if (elm == null) {
                    if (list.getWidth() > 0 && list.getHeight() > 0 && (list.getStyle() != null || list.getBackgroundComponent() != null)) {
                        list.getComponents().clear();
                        return list;
                    }
                    return null;
                }
                if (lComponent != elm && (!(lComponent instanceof DRDesignList) || lComponent instanceof DRDesignList && (lComponent.getStyle() != null || lComponent.getPrintWhenExpression() != null || ((DRDesignList)lComponent).getBackgroundComponent() != null))) {
                    elm.setX(lComponent.getX() + elm.getX());
                    elm.setY(lComponent.getY() + elm.getY());
                }
                if (list.getStyle() == null && list.getPrintWhenExpression() == null && list.getBackgroundComponent() == null) {
                    elm.setX(list.getX() + elm.getX());
                    elm.setY(list.getY() + elm.getY());
                    return elm;
                }
                list.getComponents().clear();
                list.getComponents().add(elm);
                return list;
            }
            ArrayList<DRDesignComponent> components = new ArrayList<DRDesignComponent>();
            for (DRDesignComponent listComponent : list.getComponents()) {
                DRDesignComponent comp = this.removeEmptyComponents(listComponent);
                if (comp == null) continue;
                components.add(comp);
            }
            if (components.isEmpty()) {
                if (list.getWidth() > 0 && list.getHeight() > 0 && (list.getStyle() != null || list.getBackgroundComponent() != null)) {
                    list.getComponents().clear();
                    return list;
                }
                return null;
            }
            list.getComponents().clear();
            list.getComponents().addAll(components);
            return list;
        }
        if (component instanceof DRDesignFiller && component.getStyle() == null && component.getPrintWhenExpression() == null) {
            return null;
        }
        return component;
    }

    private void componentGroupType(DRDesignComponent component) {
        if (component instanceof DRDesignList) {
            DRDesignList list = (DRDesignList)component;
            if (list.isRemovable() && list.getStyle() == null && list.getPrintWhenExpression() == null && list.getBackgroundComponent() == null) {
                list.setComponentGroupType(ComponentGroupType.NONE);
                for (DRDesignComponent listComponent : list.getComponents()) {
                    listComponent.setX(list.getX() + listComponent.getX());
                    listComponent.setY(list.getY() + listComponent.getY());
                }
            } else {
                list.setComponentGroupType(ComponentGroupType.FRAME);
            }
            for (DRDesignComponent listComponent : list.getComponents()) {
                this.componentGroupType(listComponent);
            }
        }
    }

    private void prepareListBackgroundComponents(DRDesignComponent component) throws DRException {
        if (component instanceof DRDesignList) {
            DRDesignList list = (DRDesignList)component;
            if (list.getBackgroundComponent() != null) {
                DRDesignComponent backgroundComponent = list.getBackgroundComponent();
                backgroundComponent.setX(0);
                backgroundComponent.setY(0);
                backgroundComponent.setWidth(list.getWidth() - StyleResolver.getHorizontalPadding(list.getStyle()));
                backgroundComponent.setHeight(list.getHeight() - StyleResolver.getVerticalPadding(list.getStyle()));
                backgroundComponent.setStretchType(StretchType.ELEMENT_GROUP_HEIGHT);
                list.setBackgroundComponent(backgroundComponent);
            }
            for (DRDesignComponent listComponent : list.getComponents()) {
                this.prepareListBackgroundComponents(listComponent);
            }
        }
    }

    private void prepareCrosstabs(DRDesignComponent component) throws DRException {
        if (component instanceof DRDesignList) {
            DRDesignList list = (DRDesignList)component;
            for (DRDesignComponent listComponent : list.getComponents()) {
                this.prepareCrosstabs(listComponent);
            }
        } else if (component instanceof DRDesignCrosstab) {
            this.prepareCrosstab((DRDesignCrosstab)component);
        }
    }

    private void prepareCrosstab(DRDesignCrosstab crosstab) throws DRException {
        DRDesignCrosstabCellContent headerCell;
        DRDesignCrosstabCellContent totalHeader;
        DRDesignCrosstabCellContent header;
        this.calculateCellDimensions(crosstab);
        DRDesignCrosstabCellContent whenNoDataCell = crosstab.getWhenNoDataCell();
        for (DRDesignCrosstabColumnGroup columnGroup : crosstab.getColumnGroups()) {
            header = columnGroup.getHeader();
            if (header != null) {
                header.setComponent(this.prepareCrosstabCell(crosstab.getUniqueName(), header));
            }
            if ((totalHeader = columnGroup.getTotalHeader()) == null) continue;
            totalHeader.setComponent(this.prepareCrosstabCell(crosstab.getUniqueName(), totalHeader));
        }
        for (DRDesignCrosstabRowGroup rowGroup : crosstab.getRowGroups()) {
            header = rowGroup.getHeader();
            if (header != null) {
                header.setComponent(this.prepareCrosstabCell(crosstab.getUniqueName(), header));
            }
            if ((totalHeader = rowGroup.getTotalHeader()) == null) continue;
            totalHeader.setComponent(this.prepareCrosstabCell(crosstab.getUniqueName(), totalHeader));
        }
        if (whenNoDataCell != null) {
            whenNoDataCell.setComponent(this.prepareCrosstabCell(crosstab.getUniqueName() + ".whennodatacell", whenNoDataCell));
        }
        if ((headerCell = crosstab.getHeaderCell()) != null) {
            crosstab.getHeaderCell().setComponent(this.prepareCrosstabCell(crosstab.getUniqueName() + ".headercell", headerCell));
        }
        for (DRDesignCrosstabCell cell : crosstab.getCells()) {
            DRDesignCrosstabCellContent content = cell.getContent();
            if (content == null) continue;
            content.setComponent(this.prepareCrosstabCell(crosstab.getUniqueName(), content));
        }
    }

    private DRDesignComponent prepareCrosstabCell(String name, DRDesignCrosstabCellContent cell) throws DRException {
        return this.prepareList(name, cell.getList(), cell.getWidth(), cell.getHeight());
    }

    private void calculateCellDimensions(DRDesignCrosstab designCrosstab) {
        GroupCellDimension groupCellDimension;
        int totalHeaderHeight;
        int totalHeaderWidth;
        int headerHeight;
        int headerWidth;
        int i;
        DRICrosstab crosstab = this.accessor.getCrosstabTransform().getCrosstab(designCrosstab);
        int cellWidth = this.accessor.getTemplateTransform().getCrosstabCellWidth(crosstab, designCrosstab);
        int cellHeight = this.accessor.getTemplateTransform().getCrosstabCellHeight(crosstab, designCrosstab);
        HashMap<String, GroupCellDimension> columnGroups = new HashMap<String, GroupCellDimension>();
        HashMap<String, GroupCellDimension> rowGroups = new HashMap<String, GroupCellDimension>();
        int groupWidth = 0;
        int groupHeight = 0;
        GroupCellDimension previousCellDimension = null;
        for (i = crosstab.getColumnGroups().size() - 1; i >= 0; --i) {
            DRICrosstabColumnGroup<?> columnGroup = crosstab.getColumnGroups().get(i);
            headerWidth = 0;
            headerHeight = 0;
            totalHeaderWidth = 0;
            totalHeaderHeight = 0;
            headerWidth = previousCellDimension == null ? cellWidth : previousCellDimension.getHeaderWidth() + previousCellDimension.getTotalHeaderWidth();
            headerHeight = this.accessor.getTemplateTransform().getCrosstabColumnGroupHeaderHeight(columnGroup, designCrosstab, groupHeight);
            if (this.accessor.getTemplateTransform().isCrosstabColumnGroupShowTotal(columnGroup)) {
                totalHeaderWidth = this.accessor.getTemplateTransform().getCrosstabColumnGroupTotalHeaderWidth(columnGroup, crosstab.getCellWidth(), designCrosstab);
            }
            totalHeaderHeight = headerHeight;
            if (previousCellDimension != null) {
                totalHeaderHeight += previousCellDimension.getTotalHeaderHeight();
            }
            groupCellDimension = new GroupCellDimension();
            groupCellDimension.setHeaderWidth(headerWidth);
            groupCellDimension.setHeaderHeight(headerHeight);
            groupCellDimension.setTotalHeaderWidth(totalHeaderWidth);
            groupCellDimension.setTotalHeaderHeight(totalHeaderHeight);
            columnGroups.put(columnGroup.getName(), groupCellDimension);
            previousCellDimension = groupCellDimension;
            groupHeight += groupCellDimension.getHeaderHeight();
        }
        previousCellDimension = null;
        for (i = crosstab.getRowGroups().size() - 1; i >= 0; --i) {
            DRICrosstabRowGroup<?> rowGroup = crosstab.getRowGroups().get(i);
            headerWidth = 0;
            headerHeight = 0;
            totalHeaderWidth = 0;
            totalHeaderHeight = 0;
            headerWidth = this.accessor.getTemplateTransform().getCrosstabRowGroupHeaderWidth(rowGroup, designCrosstab);
            headerHeight = previousCellDimension == null ? cellHeight : previousCellDimension.getHeaderHeight() + previousCellDimension.getTotalHeaderHeight();
            totalHeaderWidth = headerWidth;
            if (previousCellDimension != null) {
                totalHeaderWidth += previousCellDimension.getTotalHeaderWidth();
            }
            if (this.accessor.getTemplateTransform().isCrosstabRowGroupShowTotal(rowGroup)) {
                totalHeaderHeight = this.accessor.getTemplateTransform().getCrosstabRowGroupTotalHeaderHeight(rowGroup, crosstab.getCellHeight(), designCrosstab);
            }
            groupCellDimension = new GroupCellDimension();
            groupCellDimension.setHeaderWidth(headerWidth);
            groupCellDimension.setHeaderHeight(headerHeight);
            groupCellDimension.setTotalHeaderWidth(totalHeaderWidth);
            groupCellDimension.setTotalHeaderHeight(totalHeaderHeight);
            rowGroups.put(rowGroup.getName(), groupCellDimension);
            previousCellDimension = groupCellDimension;
            groupWidth += groupCellDimension.getHeaderWidth();
        }
        designCrosstab.getWhenNoDataCell().setWidth(designCrosstab.getWidth());
        designCrosstab.getWhenNoDataCell().setHeight(designCrosstab.getHeight());
        designCrosstab.getHeaderCell().setWidth(groupWidth);
        designCrosstab.getHeaderCell().setHeight(groupHeight);
        for (DRDesignCrosstabColumnGroup designColumnGroup : designCrosstab.getColumnGroups()) {
            GroupCellDimension groupCellDimension2 = (GroupCellDimension)columnGroups.get(designColumnGroup.getName());
            designColumnGroup.setHeight(groupCellDimension2.getHeaderHeight());
            designColumnGroup.getHeader().setWidth(groupCellDimension2.getHeaderWidth());
            designColumnGroup.getHeader().setHeight(groupCellDimension2.getHeaderHeight());
            if (designColumnGroup.getTotalHeader() == null) continue;
            designColumnGroup.getTotalHeader().setWidth(groupCellDimension2.getTotalHeaderWidth());
            designColumnGroup.getTotalHeader().setHeight(groupCellDimension2.getTotalHeaderHeight());
        }
        for (DRDesignCrosstabRowGroup designRowGroup : designCrosstab.getRowGroups()) {
            GroupCellDimension groupCellDimension3 = (GroupCellDimension)rowGroups.get(designRowGroup.getName());
            designRowGroup.setWidth(groupCellDimension3.getHeaderWidth());
            designRowGroup.getHeader().setWidth(groupCellDimension3.getHeaderWidth());
            designRowGroup.getHeader().setHeight(groupCellDimension3.getHeaderHeight());
            if (designRowGroup.getTotalHeader() == null) continue;
            designRowGroup.getTotalHeader().setWidth(groupCellDimension3.getTotalHeaderWidth());
            designRowGroup.getTotalHeader().setHeight(groupCellDimension3.getTotalHeaderHeight());
        }
        for (DRDesignCrosstabCell designCell : designCrosstab.getCells()) {
            GroupCellDimension groupCellDimension4;
            if (designCell.getColumnTotalGroup() == null && designCell.getRowTotalGroup() == null) {
                designCell.getContent().setWidth(cellWidth);
                designCell.getContent().setHeight(cellHeight);
                continue;
            }
            if (designCell.getColumnTotalGroup() != null && designCell.getRowTotalGroup() == null) {
                groupCellDimension4 = (GroupCellDimension)columnGroups.get(designCell.getColumnTotalGroup());
                designCell.getContent().setWidth(groupCellDimension4.getTotalHeaderWidth());
                designCell.getContent().setHeight(cellHeight);
                continue;
            }
            if (designCell.getColumnTotalGroup() == null && designCell.getRowTotalGroup() != null) {
                groupCellDimension4 = (GroupCellDimension)rowGroups.get(designCell.getRowTotalGroup());
                designCell.getContent().setWidth(cellWidth);
                designCell.getContent().setHeight(groupCellDimension4.getTotalHeaderHeight());
                continue;
            }
            groupCellDimension4 = (GroupCellDimension)columnGroups.get(designCell.getColumnTotalGroup());
            designCell.getContent().setWidth(groupCellDimension4.getTotalHeaderWidth());
            groupCellDimension4 = (GroupCellDimension)rowGroups.get(designCell.getRowTotalGroup());
            designCell.getContent().setHeight(groupCellDimension4.getTotalHeaderHeight());
        }
    }

    private class GroupCellDimension {
        private int headerWidth;
        private int headerHeight;
        private int totalHeaderWidth;
        private int totalHeaderHeight;

        private GroupCellDimension() {
        }

        public int getHeaderWidth() {
            return this.headerWidth;
        }

        public void setHeaderWidth(int headerWidth) {
            this.headerWidth = headerWidth;
        }

        public int getHeaderHeight() {
            return this.headerHeight;
        }

        public void setHeaderHeight(int headerHeight) {
            this.headerHeight = headerHeight;
        }

        public int getTotalHeaderWidth() {
            return this.totalHeaderWidth;
        }

        public void setTotalHeaderWidth(int totalHeaderWidth) {
            this.totalHeaderWidth = totalHeaderWidth;
        }

        public int getTotalHeaderHeight() {
            return this.totalHeaderHeight;
        }

        public void setTotalHeaderHeight(int totalHeaderHeight) {
            this.totalHeaderHeight = totalHeaderHeight;
        }
    }
}

