/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.expressions;

import java.util.HashMap;
import java.util.Map;
import net.sf.dynamicreports.design.base.DRDesignGroup;
import net.sf.dynamicreports.design.constant.ResetType;
import net.sf.dynamicreports.design.definition.expression.DRIDesignExpression;
import net.sf.dynamicreports.design.exception.DRDesignReportException;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.definition.ReportParameters;

public class SerieValueExpression
extends AbstractSimpleExpression<Number> {
    private static final long serialVersionUID = 10000L;
    private DRIDesignExpression valueExpression;
    private DRIDesignExpression serieExpression;
    private ResetType resetType;
    private DRDesignGroup resetGroup;
    private String key;
    private Object resetValue;
    private Map<Object, Double> values;

    public SerieValueExpression(DRIDesignExpression valueExpression, DRIDesignExpression serieExpression, ResetType resetType, DRDesignGroup resetGroup, String key) {
        this.valueExpression = valueExpression;
        this.serieExpression = serieExpression;
        this.resetType = resetType;
        this.resetGroup = resetGroup;
        this.key = key;
    }

    @Override
    public Number evaluate(ReportParameters reportParameters) {
        if (reportParameters.getReportRowNumber() <= 1) {
            this.resetValue = null;
            this.values = new HashMap<Object, Double>();
        }
        Integer resetValue = null;
        switch (this.resetType) {
            case NONE: 
            case REPORT: {
                break;
            }
            case PAGE: {
                resetValue = reportParameters.getPageNumber();
                break;
            }
            case COLUMN: {
                resetValue = reportParameters.getColumnNumber();
                break;
            }
            case GROUP: {
                resetValue = reportParameters.getValue(this.resetGroup.getGroupExpression().getName());
                break;
            }
            default: {
                throw new DRDesignReportException("Reset type " + this.resetType.name() + " not supported");
            }
        }
        if (this.resetValue != null && !this.resetValue.equals(resetValue)) {
            this.values = new HashMap<Object, Double>();
        }
        this.resetValue = resetValue;
        Object keyValue = this.key != null ? reportParameters.getValue(this.valueExpression.getName()) + "_" + reportParameters.getValue(this.key) : reportParameters.getValue(this.valueExpression.getName());
        Number serieValue = (Number)reportParameters.getValue(this.serieExpression.getName());
        Double value = this.values.get(keyValue);
        if (serieValue != null) {
            value = value == null ? Double.valueOf(serieValue.doubleValue()) : Double.valueOf(value + serieValue.doubleValue());
            this.values.put(keyValue, value);
        }
        return value;
    }
}

