/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.jasper.base;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.dynamicreports.design.definition.expression.DRIDesignComplexExpression;
import net.sf.dynamicreports.design.definition.expression.DRIDesignSimpleExpression;
import net.sf.dynamicreports.jasper.base.DefaultJasperScriptletManager;
import net.sf.dynamicreports.jasper.base.JasperScriptlet;
import net.sf.dynamicreports.jasper.base.JasperScriptletManager;
import net.sf.dynamicreports.jasper.base.ThreadSafeJasperScriptletManager;
import net.sf.dynamicreports.jasper.base.tableofcontents.JasperTocHeading;
import net.sf.dynamicreports.jasper.constant.ValueType;
import net.sf.dynamicreports.report.definition.DRICustomValues;
import net.sf.dynamicreports.report.definition.chart.DRIChartCustomizer;
import org.apache.commons.lang3.StringUtils;

public class JasperCustomValues
implements DRICustomValues {
    private static final long serialVersionUID = 10000L;
    private Map<String, ValueType> valueTypes;
    private Map<String, DRIDesignSimpleExpression> simpleExpressions;
    private Map<String, DRIDesignComplexExpression> complexExpressions;
    private Map<String, List<DRIChartCustomizer>> chartCustomizers;
    private Map<String, Object> systemValues;
    private Integer startPageNumber;
    private Map<String, JasperTocHeading> tocHeadings;
    private Integer subreportWidth;
    private transient JasperScriptletManager scriptletManager;

    public JasperCustomValues(Properties properties) {
        this.init(properties);
    }

    private void init(Properties properties) {
        this.valueTypes = new HashMap<String, ValueType>();
        this.simpleExpressions = new HashMap<String, DRIDesignSimpleExpression>();
        this.complexExpressions = new HashMap<String, DRIDesignComplexExpression>();
        this.chartCustomizers = new HashMap<String, List<DRIChartCustomizer>>();
        this.systemValues = new HashMap<String, Object>();
        this.scriptletManager = this.createScriptletManager(properties);
    }

    private JasperScriptletManager createScriptletManager(Properties properties) {
        String useThreadSafeScriptletManagerPropertyValue = properties.getProperty("net.sf.dynamicreports.useThreadSafeScriptletManager");
        if (Boolean.TRUE.toString().equalsIgnoreCase(useThreadSafeScriptletManagerPropertyValue)) {
            return new ThreadSafeJasperScriptletManager();
        }
        return new DefaultJasperScriptletManager();
    }

    public void addSimpleExpression(DRIDesignSimpleExpression simpleExpression) {
        this.simpleExpressions.put(simpleExpression.getName(), simpleExpression);
        this.addValueType(simpleExpression.getName(), ValueType.SIMPLE_EXPRESSION);
    }

    public void addComplexExpression(DRIDesignComplexExpression complexExpression) {
        this.complexExpressions.put(complexExpression.getName(), complexExpression);
        this.addValueType(complexExpression.getName(), ValueType.COMPLEX_EXPRESSION);
    }

    public void addChartCustomizers(String name, List<DRIChartCustomizer> chartCustomizers) {
        this.chartCustomizers.put(name, chartCustomizers);
    }

    public void addValueType(String name, ValueType valueType) {
        this.valueTypes.put(name, valueType);
    }

    protected ValueType getValueType(String name) {
        return this.valueTypes.get(name);
    }

    protected DRIDesignSimpleExpression getSimpleExpression(String name) {
        return this.simpleExpressions.get(name);
    }

    protected DRIDesignComplexExpression getComplexExpression(String name) {
        return this.complexExpressions.get(name);
    }

    protected List<DRIChartCustomizer> getChartCustomizers(String name) {
        return this.chartCustomizers.get(name);
    }

    public boolean isEmpty() {
        if (!this.simpleExpressions.isEmpty()) {
            return false;
        }
        if (!this.complexExpressions.isEmpty()) {
            return false;
        }
        return this.chartCustomizers.isEmpty();
    }

    public Object getValue(String valueName) {
        return this.scriptletManager.getJasperScriptlet().getValue(valueName);
    }

    public Object getValue(String name, Object[] values) {
        return this.scriptletManager.getJasperScriptlet().getValue(name, values);
    }

    @Override
    public void setSystemValue(String name, Object value) {
        this.systemValues.put(name, value);
    }

    protected Object getSystemValue(String name) {
        return this.systemValues.get(name);
    }

    protected JasperScriptlet getJasperScriptlet() {
        return this.scriptletManager.getJasperScriptlet();
    }

    protected void setJasperScriptlet(JasperScriptlet jasperScriptlet) {
        this.scriptletManager.setJasperScriptlet(jasperScriptlet);
    }

    public Integer getStartPageNumber() {
        return this.startPageNumber;
    }

    public void setStartPageNumber(Integer startPageNumber) {
        this.startPageNumber = startPageNumber;
    }

    @Override
    public void addTocHeading(int level, String id, String text, Object customValue) {
        JasperTocHeading heading = new JasperTocHeading();
        heading.setLevel(level);
        heading.setText(text);
        heading.setReference(id);
        heading.setCustomValue(customValue);
        this.tocHeadings.put(id, heading);
    }

    @Override
    public Map<String, JasperTocHeading> getTocHeadings() {
        return this.tocHeadings;
    }

    @Override
    public void setTocHeadings(Map<String, JasperTocHeading> tocHeadings) {
        this.tocHeadings = tocHeadings;
    }

    public Integer getSubreportWidth() {
        return this.subreportWidth;
    }

    @Override
    public void setSubreportWidth(Integer subreportWidth) {
        this.subreportWidth = subreportWidth;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (String name : this.valueTypes.keySet()) {
            result.append(this.valueTypes.get(name).name() + ":" + name);
            result.append(", ");
        }
        return "{" + StringUtils.removeEnd((String)result.toString(), (String)", ") + "}";
    }

    JasperScriptletManager getScriptletManager() {
        return this.scriptletManager;
    }
}

