/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.jasper.base.templatedesign;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.sf.dynamicreports.jasper.transformation.ConstantTransform;
import net.sf.dynamicreports.report.base.DRField;
import net.sf.dynamicreports.report.base.DRMargin;
import net.sf.dynamicreports.report.constant.PageOrientation;
import net.sf.dynamicreports.report.constant.WhenNoDataType;
import net.sf.dynamicreports.report.constant.WhenResourceMissingType;
import net.sf.dynamicreports.report.definition.DRIField;
import net.sf.dynamicreports.report.definition.DRIMargin;
import net.sf.dynamicreports.report.definition.DRITemplateDesign;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.apache.commons.lang3.Validate;

public class JasperTemplateDesign
implements DRITemplateDesign<JasperDesign> {
    private static final long serialVersionUID = 10000L;
    private JasperDesign jasperDesign;
    private List<DRIField<?>> fields;
    private DRMargin margin;
    private transient ByteArrayOutputStream templateDesign;

    public JasperTemplateDesign(JasperDesign jasperDesign) throws DRException {
        this.init(jasperDesign);
    }

    public JasperTemplateDesign(File file) throws DRException {
        Validate.notNull((Object)file, (String)"file must not be null", (Object[])new Object[0]);
        try {
            this.init(JRXmlLoader.load((File)file));
        }
        catch (JRException e) {
            throw new DRException(e);
        }
    }

    public JasperTemplateDesign(String fileName) throws DRException {
        Validate.notNull((Object)fileName, (String)"fileName must not be null", (Object[])new Object[0]);
        try {
            this.init(JRXmlLoader.load((String)fileName));
        }
        catch (JRException e) {
            throw new DRException(e);
        }
    }

    public JasperTemplateDesign(InputStream inputStream) throws DRException {
        Validate.notNull((Object)inputStream, (String)"inputStream must not be null", (Object[])new Object[0]);
        try {
            this.init(JRXmlLoader.load((InputStream)inputStream));
        }
        catch (JRException e) {
            throw new DRException(e);
        }
    }

    public JasperTemplateDesign(URL url) throws DRException {
        Validate.notNull((Object)url, (String)"url must not be null", (Object[])new Object[0]);
        try {
            this.init(JRXmlLoader.load((InputStream)url.openStream()));
        }
        catch (JRException e) {
            throw new DRException(e);
        }
        catch (IOException e) {
            throw new DRException(e);
        }
    }

    private void init(JasperDesign jasperDesign) throws DRException {
        Validate.notNull((Object)jasperDesign, (String)"jasperDesign must not be null", (Object[])new Object[0]);
        this.jasperDesign = jasperDesign;
        this.fields = new ArrayList();
        for (JRField jrField : jasperDesign.getFields()) {
            DRField field = new DRField(jrField.getName(), jrField.getValueClass());
            this.fields.add(field);
        }
        this.margin = new DRMargin();
        this.margin.setTop(jasperDesign.getTopMargin());
        this.margin.setLeft(jasperDesign.getLeftMargin());
        this.margin.setBottom(jasperDesign.getBottomMargin());
        this.margin.setRight(jasperDesign.getRightMargin());
    }

    @Override
    public String getReportName() {
        return this.jasperDesign.getName();
    }

    @Override
    public List<DRIField<?>> getFields() {
        return this.fields;
    }

    @Override
    public boolean isDefinedParameter(String name) {
        JRParameter parameter = (JRParameter)this.jasperDesign.getParametersMap().get(name);
        return parameter != null;
    }

    @Override
    public String getResourceBundleName() {
        return this.jasperDesign.getResourceBundle();
    }

    @Override
    public Boolean getIgnorePagination() {
        return this.jasperDesign.isIgnorePagination();
    }

    @Override
    public WhenNoDataType getWhenNoDataType() {
        return ConstantTransform.whenNoDataType(this.jasperDesign.getWhenNoDataTypeValue());
    }

    @Override
    public WhenResourceMissingType getWhenResourceMissingType() {
        return ConstantTransform.whenResourceMissingType(this.jasperDesign.getWhenResourceMissingTypeValue());
    }

    @Override
    public Boolean getTitleOnANewPage() {
        return this.jasperDesign.isTitleNewPage();
    }

    @Override
    public Boolean getSummaryOnANewPage() {
        return this.jasperDesign.isSummaryNewPage();
    }

    @Override
    public Boolean getSummaryWithPageHeaderAndFooter() {
        return this.jasperDesign.isSummaryWithPageHeaderAndFooter();
    }

    @Override
    public Boolean getFloatColumnFooter() {
        return this.jasperDesign.isFloatColumnFooter();
    }

    @Override
    public Integer getPageWidth() {
        return this.jasperDesign.getPageWidth();
    }

    @Override
    public Integer getPageHeight() {
        return this.jasperDesign.getPageHeight();
    }

    @Override
    public PageOrientation getPageOrientation() {
        return ConstantTransform.pageOrientation(this.jasperDesign.getOrientationValue());
    }

    @Override
    public DRIMargin getPageMargin() {
        return this.margin;
    }

    @Override
    public Integer getPageColumnsPerPage() {
        return this.jasperDesign.getColumnCount();
    }

    @Override
    public Integer getPageColumnSpace() {
        return this.jasperDesign.getColumnSpacing();
    }

    @Override
    public Integer getPageColumnWidth() {
        return this.jasperDesign.getColumnWidth();
    }

    @Override
    public int getTitleComponentsCount() {
        return this.getBandComponentsCount(this.jasperDesign.getTitle());
    }

    @Override
    public int getPageHeaderComponentsCount() {
        return this.getBandComponentsCount(this.jasperDesign.getPageHeader());
    }

    @Override
    public int getPageFooterComponentsCount() {
        return this.getBandComponentsCount(this.jasperDesign.getPageFooter());
    }

    @Override
    public int getColumnHeaderComponentsCount() {
        return this.getBandComponentsCount(this.jasperDesign.getColumnHeader());
    }

    @Override
    public int getColumnFooterComponentsCount() {
        return this.getBandComponentsCount(this.jasperDesign.getColumnFooter());
    }

    @Override
    public int getLastPageFooterComponentsCount() {
        return this.getBandComponentsCount(this.jasperDesign.getLastPageFooter());
    }

    @Override
    public int getSummaryComponentsCount() {
        return this.getBandComponentsCount(this.jasperDesign.getSummary());
    }

    @Override
    public int getNoDataComponentsCount() {
        return this.getBandComponentsCount(this.jasperDesign.getNoData());
    }

    @Override
    public int getBackgroundComponentsCount() {
        return this.getBandComponentsCount(this.jasperDesign.getBackground());
    }

    private int getBandComponentsCount(JRBand band) {
        if (band != null && band.getElements() != null) {
            return band.getElements().length;
        }
        return 0;
    }

    @Override
    public JasperDesign getDesign() throws DRException {
        try {
            if (this.templateDesign == null) {
                this.templateDesign = new ByteArrayOutputStream();
                JRXmlWriter.writeReport((JRReport)this.jasperDesign, (OutputStream)this.templateDesign, (String)"UTF-8");
            }
            return JRXmlLoader.load((InputStream)new ByteArrayInputStream(this.templateDesign.toByteArray()));
        }
        catch (JRException e) {
            throw new DRException(e);
        }
    }
}

