/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.base;

import net.sf.dynamicreports.report.ReportUtils;
import net.sf.dynamicreports.report.base.DRBand;
import net.sf.dynamicreports.report.base.component.DRTextField;
import net.sf.dynamicreports.report.constant.GroupFooterPosition;
import net.sf.dynamicreports.report.constant.GroupHeaderLayout;
import net.sf.dynamicreports.report.definition.DRIGroup;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.style.DRIReportStyle;
import org.apache.commons.lang3.Validate;

public class DRGroup
implements DRIGroup {
    private static final long serialVersionUID = 10000L;
    private String name;
    private DRTextField<?> valueField;
    private DRIExpression<?> titleExpression;
    private DRIReportStyle titleStyle;
    private Integer titleWidth;
    private GroupHeaderLayout headerLayout;
    private Boolean hideColumn;
    private Boolean groupByDataType;
    private Boolean showColumnHeaderAndFooter;
    private Boolean addToTableOfContents;
    private DRIExpression<Boolean> printSubtotalsWhenExpression;
    private Integer padding;
    private Boolean startInNewPage;
    private Boolean startInNewColumn;
    private Boolean reprintHeaderOnEachPage;
    private Boolean resetPageNumber;
    private Integer minHeightToStartNewPage;
    private GroupFooterPosition footerPosition;
    private Boolean keepTogether;
    private Boolean headerWithSubtotal;
    private DRBand headerBand;
    private DRBand footerBand;

    public DRGroup(DRTextField<?> valueField) {
        this(ReportUtils.generateUniqueName("group"), valueField);
    }

    public DRGroup(String name, DRTextField<?> valueField) {
        Validate.notEmpty((CharSequence)name, (String)"name must not be empty", (Object[])new Object[0]);
        Validate.notNull(valueField, (String)"valueField must not be null", (Object[])new Object[0]);
        this.name = name;
        this.valueField = valueField;
        this.init();
    }

    private void init() {
        this.headerBand = new DRBand();
        this.footerBand = new DRBand();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public DRTextField<?> getValueField() {
        return this.valueField;
    }

    @Override
    public DRIExpression<?> getTitleExpression() {
        return this.titleExpression;
    }

    public void setTitleExpression(DRIExpression<?> titleExpression) {
        this.titleExpression = titleExpression;
    }

    @Override
    public DRIReportStyle getTitleStyle() {
        return this.titleStyle;
    }

    public void setTitleStyle(DRIReportStyle titleStyle) {
        this.titleStyle = titleStyle;
    }

    @Override
    public Integer getTitleWidth() {
        return this.titleWidth;
    }

    public void setTitleWidth(Integer titleWidth) {
        this.titleWidth = titleWidth;
    }

    @Override
    public GroupHeaderLayout getHeaderLayout() {
        return this.headerLayout;
    }

    public void setHeaderLayout(GroupHeaderLayout headerLayout) {
        this.headerLayout = headerLayout;
    }

    @Override
    public Boolean getHideColumn() {
        return this.hideColumn;
    }

    public void setHideColumn(Boolean hideColumn) {
        this.hideColumn = hideColumn;
    }

    @Override
    public Boolean getGroupByDataType() {
        return this.groupByDataType;
    }

    public void setGroupByDataType(Boolean groupByDataType) {
        this.groupByDataType = groupByDataType;
    }

    @Override
    public Boolean getShowColumnHeaderAndFooter() {
        return this.showColumnHeaderAndFooter;
    }

    public void setShowColumnHeaderAndFooter(Boolean showColumnHeaderAndFooter) {
        this.showColumnHeaderAndFooter = showColumnHeaderAndFooter;
    }

    @Override
    public Boolean getAddToTableOfContents() {
        return this.addToTableOfContents;
    }

    public void setAddToTableOfContents(Boolean addToTableOfContents) {
        this.addToTableOfContents = addToTableOfContents;
    }

    @Override
    public DRIExpression<Boolean> getPrintSubtotalsWhenExpression() {
        return this.printSubtotalsWhenExpression;
    }

    public void setPrintSubtotalsWhenExpression(DRIExpression<Boolean> printSubtotalsWhenExpression) {
        this.printSubtotalsWhenExpression = printSubtotalsWhenExpression;
    }

    @Override
    public Integer getPadding() {
        return this.padding;
    }

    public void setPadding(Integer padding) {
        if (padding != null) {
            Validate.isTrue((padding >= 0 ? 1 : 0) != 0, (String)"padding must be >= 0", (Object[])new Object[0]);
        }
        this.padding = padding;
    }

    @Override
    public Boolean getStartInNewPage() {
        return this.startInNewPage;
    }

    public void setStartInNewPage(Boolean startInNewPage) {
        this.startInNewPage = startInNewPage;
    }

    @Override
    public Boolean getStartInNewColumn() {
        return this.startInNewColumn;
    }

    public void setStartInNewColumn(Boolean startInNewColumn) {
        this.startInNewColumn = startInNewColumn;
    }

    @Override
    public Boolean getReprintHeaderOnEachPage() {
        return this.reprintHeaderOnEachPage;
    }

    public void setReprintHeaderOnEachPage(Boolean reprintHeaderOnEachPage) {
        this.reprintHeaderOnEachPage = reprintHeaderOnEachPage;
    }

    @Override
    public Boolean getResetPageNumber() {
        return this.resetPageNumber;
    }

    public void setResetPageNumber(Boolean resetPageNumber) {
        this.resetPageNumber = resetPageNumber;
    }

    @Override
    public Integer getMinHeightToStartNewPage() {
        return this.minHeightToStartNewPage;
    }

    public void setMinHeightToStartNewPage(Integer minHeightToStartNewPage) {
        this.minHeightToStartNewPage = minHeightToStartNewPage;
    }

    @Override
    public GroupFooterPosition getFooterPosition() {
        return this.footerPosition;
    }

    public void setFooterPosition(GroupFooterPosition footerPosition) {
        this.footerPosition = footerPosition;
    }

    @Override
    public Boolean getKeepTogether() {
        return this.keepTogether;
    }

    public void setKeepTogether(Boolean keepTogether) {
        this.keepTogether = keepTogether;
    }

    @Override
    public Boolean getHeaderWithSubtotal() {
        return this.headerWithSubtotal;
    }

    public void setHeaderWithSubtotal(Boolean headerWithSubtotal) {
        this.headerWithSubtotal = headerWithSubtotal;
    }

    @Override
    public DRBand getHeaderBand() {
        return this.headerBand;
    }

    @Override
    public DRBand getFooterBand() {
        return this.footerBand;
    }
}

