/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder;

import net.sf.dynamicreports.jasper.builder.JasperConcatenatedReportBuilder;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.jasper.builder.export.ExporterBuilders;
import net.sf.dynamicreports.jasper.definition.JasperReportHandler;
import net.sf.dynamicreports.report.builder.DatasetBuilder;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.HyperLinkBuilder;
import net.sf.dynamicreports.report.builder.MarginBuilder;
import net.sf.dynamicreports.report.builder.ParameterBuilder;
import net.sf.dynamicreports.report.builder.QueryBuilder;
import net.sf.dynamicreports.report.builder.ReportTemplateBuilder;
import net.sf.dynamicreports.report.builder.SortBuilder;
import net.sf.dynamicreports.report.builder.Units;
import net.sf.dynamicreports.report.builder.VariableBuilder;
import net.sf.dynamicreports.report.builder.barcode.BarcodeBuilders;
import net.sf.dynamicreports.report.builder.chart.ChartBuilders;
import net.sf.dynamicreports.report.builder.column.ColumnBuilders;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilders;
import net.sf.dynamicreports.report.builder.condition.ConditionBuilders;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabBuilders;
import net.sf.dynamicreports.report.builder.datatype.DataTypeBuilders;
import net.sf.dynamicreports.report.builder.datatype.DataTypes;
import net.sf.dynamicreports.report.builder.expression.ExpressionBuilders;
import net.sf.dynamicreports.report.builder.grid.GridBuilders;
import net.sf.dynamicreports.report.builder.group.GroupBuilders;
import net.sf.dynamicreports.report.builder.style.StyleBuilders;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilders;
import net.sf.dynamicreports.report.builder.tableofcontents.TableOfContentsCustomizerBuilder;
import net.sf.dynamicreports.report.builder.tableofcontents.TableOfContentsHeadingBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.OrderType;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import org.apache.commons.lang3.Validate;

public class DynamicReports {
    public static final ColumnBuilders col = new ColumnBuilders();
    public static final GridBuilders grid = new GridBuilders();
    public static final GroupBuilders grp = new GroupBuilders();
    public static final SubtotalBuilders sbt = new SubtotalBuilders();
    public static final StyleBuilders stl = new StyleBuilders();
    public static final ComponentBuilders cmp = new ComponentBuilders();
    public static final ExpressionBuilders exp = new ExpressionBuilders();
    public static final ConditionBuilders cnd = new ConditionBuilders();
    public static final DataTypeBuilders type = new DataTypeBuilders();
    public static final ChartBuilders cht = new ChartBuilders();
    public static final ExporterBuilders export = new ExporterBuilders();
    public static final BarcodeBuilders bcode = new BarcodeBuilders();
    public static final CrosstabBuilders ctab = new CrosstabBuilders();

    public static JasperReportBuilder report() {
        return new JasperReportBuilder();
    }

    public static JasperConcatenatedReportBuilder concatenatedReport() {
        return new JasperConcatenatedReportBuilder();
    }

    public static JasperConcatenatedReportBuilder concatenatedReport(JasperReportHandler jasperReportHandler) {
        return new JasperConcatenatedReportBuilder(jasperReportHandler);
    }

    public static <T> FieldBuilder<T> field(String name, Class valueClass) {
        FieldBuilder fieldBuilder = new FieldBuilder(name, valueClass);
        try {
            Object dataType = DataTypes.detectType(valueClass);
            fieldBuilder.setDataType(dataType);
        }
        catch (DRException dRException) {
            // empty catch block
        }
        return fieldBuilder;
    }

    public static <T> FieldBuilder<T> field(String name, DRIDataType dataType) {
        Validate.notNull((Object)dataType, (String)"dataType must not be null", (Object[])new Object[0]);
        FieldBuilder fieldBuilder = new FieldBuilder(name, dataType.getValueClass());
        fieldBuilder.setDataType(dataType);
        return fieldBuilder;
    }

    public static <T> VariableBuilder<T> variable(ValueColumnBuilder<?, ?> column, Calculation calculation) {
        Validate.notNull(column, (String)"column must not be null", (Object[])new Object[0]);
        return new VariableBuilder(column, calculation);
    }

    public static <T> VariableBuilder<T> variable(String name, ValueColumnBuilder<?, ?> column, Calculation calculation) {
        Validate.notNull(column, (String)"column must not be null", (Object[])new Object[0]);
        return new VariableBuilder(name, column, calculation);
    }

    public static <T> VariableBuilder<T> variable(FieldBuilder<T> field, Calculation calculation) {
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        return new VariableBuilder(field, calculation);
    }

    public static <T> VariableBuilder<T> variable(String name, FieldBuilder<T> field, Calculation calculation) {
        return new VariableBuilder(name, field, calculation);
    }

    public static <T> VariableBuilder<T> variable(String fieldName, Class<?> valueClass, Calculation calculation) {
        return new VariableBuilder(DynamicReports.field(fieldName, valueClass), calculation);
    }

    public static <T> VariableBuilder<T> variable(String name, String fieldName, Class<?> valueClass, Calculation calculation) {
        return new VariableBuilder(name, DynamicReports.field(fieldName, valueClass), calculation);
    }

    public static <T> VariableBuilder<T> variable(DRIExpression<?> expression, Calculation calculation) {
        return new VariableBuilder(expression, calculation);
    }

    public static <T> VariableBuilder<T> variable(String name, DRIExpression<?> expression, Calculation calculation) {
        return new VariableBuilder(name, expression, calculation);
    }

    public static SortBuilder asc(TextColumnBuilder<?> column) {
        return new SortBuilder(column).setOrderType(OrderType.ASCENDING);
    }

    public static SortBuilder asc(FieldBuilder<?> field) {
        return new SortBuilder(field).setOrderType(OrderType.ASCENDING);
    }

    public static SortBuilder asc(String fieldName, Class<?> valueClass) {
        return new SortBuilder(DynamicReports.field(fieldName, valueClass)).setOrderType(OrderType.ASCENDING);
    }

    public static SortBuilder asc(VariableBuilder<?> variable) {
        return new SortBuilder(variable).setOrderType(OrderType.ASCENDING);
    }

    public static SortBuilder asc(DRIExpression<?> expression) {
        return new SortBuilder(expression).setOrderType(OrderType.ASCENDING);
    }

    public static SortBuilder desc(TextColumnBuilder<?> column) {
        return new SortBuilder(column).setOrderType(OrderType.DESCENDING);
    }

    public static SortBuilder desc(FieldBuilder<?> field) {
        return new SortBuilder(field).setOrderType(OrderType.DESCENDING);
    }

    public static SortBuilder desc(String fieldName, Class<?> valueClass) {
        return new SortBuilder(DynamicReports.field(fieldName, valueClass)).setOrderType(OrderType.DESCENDING);
    }

    public static SortBuilder desc(VariableBuilder<?> variable) {
        return new SortBuilder(variable).setOrderType(OrderType.DESCENDING);
    }

    public static SortBuilder desc(DRIExpression<?> expression) {
        return new SortBuilder(expression).setOrderType(OrderType.DESCENDING);
    }

    public static HyperLinkBuilder hyperLink() {
        return new HyperLinkBuilder();
    }

    public static HyperLinkBuilder hyperLink(String link) {
        return new HyperLinkBuilder(link);
    }

    public static HyperLinkBuilder hyperLink(DRIExpression<String> linkExpression) {
        return new HyperLinkBuilder(linkExpression);
    }

    public static MarginBuilder margin() {
        return new MarginBuilder();
    }

    public static MarginBuilder margin(int margin) {
        return new MarginBuilder(margin);
    }

    public static <T> ParameterBuilder<T> parameter(String name, T value) {
        return new ParameterBuilder<T>(name, value);
    }

    public static <T> ParameterBuilder<T> parameter(String name, Class<T> valueClass) {
        return new ParameterBuilder<T>(name, valueClass);
    }

    public static QueryBuilder query(String text, String language) {
        return new QueryBuilder(text, language);
    }

    public static int cm(Number value) {
        return Units.cm(value);
    }

    public static int inch(Number value) {
        return Units.inch(value);
    }

    public static int mm(Number value) {
        return Units.mm(value);
    }

    public static ReportTemplateBuilder template() {
        return new ReportTemplateBuilder();
    }

    public static TableOfContentsCustomizerBuilder tableOfContentsCustomizer() {
        return new TableOfContentsCustomizerBuilder();
    }

    public static TableOfContentsHeadingBuilder tableOfContentsHeading() {
        return new TableOfContentsHeadingBuilder();
    }

    public static TableOfContentsHeadingBuilder tableOfContentsHeading(String label) {
        return new TableOfContentsHeadingBuilder().setLabel(label);
    }

    public static DatasetBuilder dataset() {
        return new DatasetBuilder();
    }
}

