/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.chart;

import java.awt.Color;
import java.util.Map;
import net.sf.dynamicreports.report.base.chart.DRChart;
import net.sf.dynamicreports.report.base.chart.dataset.DRChartDataset;
import net.sf.dynamicreports.report.base.chart.plot.AbstractBasePlot;
import net.sf.dynamicreports.report.builder.chart.AbstractChartBuilder;
import net.sf.dynamicreports.report.constant.ChartType;
import net.sf.dynamicreports.report.constant.Orientation;
import org.apache.commons.lang3.Validate;

public abstract class AbstractBaseChartBuilder<T extends AbstractBaseChartBuilder<T, U, V>, U extends AbstractBasePlot, V extends DRChartDataset>
extends AbstractChartBuilder<T> {
    private static final long serialVersionUID = 10000L;

    protected AbstractBaseChartBuilder(ChartType chartType) {
        super(chartType);
    }

    public T setTheme(String theme) {
        ((DRChart)this.getObject()).setTheme(theme);
        return (T)this;
    }

    public T setOrientation(Orientation orientation) {
        ((AbstractBasePlot)this.getPlot()).setOrientation(orientation);
        return (T)this;
    }

    public T seriesColors(Color ... seriesColors) {
        return this.addSeriesColor(seriesColors);
    }

    public T addSeriesColor(Color ... seriesColors) {
        Validate.notNull((Object)seriesColors, (String)"seriesColors must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])seriesColors, (String)"seriesColors must not contains null seriesColor", (Object[])new Object[0]);
        for (Color seriesColor : seriesColors) {
            ((AbstractBasePlot)this.getPlot()).addSeriesColor(seriesColor);
        }
        return (T)this;
    }

    public T seriesColorsByName(Map<String, Color> seriesColorsByName) {
        ((AbstractBasePlot)this.getPlot()).setSeriesColorsByName(seriesColorsByName);
        return (T)this;
    }

    public T addSeriesColorByName(String seriesName, Color color) {
        ((AbstractBasePlot)this.getPlot()).addSeriesColorByName(seriesName, color);
        return (T)this;
    }

    protected U getPlot() {
        return (U)((AbstractBasePlot)((DRChart)this.getObject()).getPlot());
    }

    protected V getDataset() {
        return (V)((DRChart)this.getObject()).getDataset();
    }
}

