/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.column;

import java.math.BigDecimal;
import net.sf.dynamicreports.report.base.column.DRValueColumn;
import net.sf.dynamicreports.report.base.component.DRTextField;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.expression.AddExpression;
import net.sf.dynamicreports.report.builder.expression.DivideExpression;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.builder.expression.MultiplyExpression;
import net.sf.dynamicreports.report.builder.expression.SubtractExpression;
import net.sf.dynamicreports.report.builder.expression.ValueExpression;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public class TextColumnBuilder<T>
extends ValueColumnBuilder<TextColumnBuilder<T>, T>
implements DRIValue<T> {
    private static final long serialVersionUID = 10000L;

    protected TextColumnBuilder(FieldBuilder<T> field) {
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        this.setValueExpression(field.getField());
    }

    protected TextColumnBuilder(DRIExpression<T> valueExpression) {
        this.setValueExpression(valueExpression);
    }

    public TextColumnBuilder<BigDecimal> add(TextColumnBuilder<? extends Number> column) {
        Validate.isTrue((boolean)Number.class.isAssignableFrom(((DRValueColumn)this.getObject()).getValueClass()), (String)"Only Number column can multiply", (Object[])new Object[0]);
        DRIExpression value1Expression = ((DRTextField)this.getComponent()).getValueExpression();
        DRIExpression value2Expression = ((DRTextField)column.getComponent()).getValueExpression();
        AddExpression exp = new AddExpression(value1Expression, value2Expression);
        return (TextColumnBuilder)new TextColumnBuilder<BigDecimal>(exp).setDataType(DynamicReports.type.bigDecimalType());
    }

    public TextColumnBuilder<BigDecimal> add(Number number) {
        Validate.isTrue((boolean)Number.class.isAssignableFrom(((DRValueColumn)this.getObject()).getValueClass()), (String)"Only Number column can multiply", (Object[])new Object[0]);
        DRIExpression value1Expression = ((DRTextField)this.getComponent()).getValueExpression();
        ValueExpression<Number> value2Expression = Expressions.number(number);
        AddExpression exp = new AddExpression(value1Expression, value2Expression);
        return (TextColumnBuilder)new TextColumnBuilder<BigDecimal>(exp).setDataType(DynamicReports.type.bigDecimalType());
    }

    public TextColumnBuilder<BigDecimal> subtract(TextColumnBuilder<? extends Number> column) {
        Validate.isTrue((boolean)Number.class.isAssignableFrom(((DRValueColumn)this.getObject()).getValueClass()), (String)"Only Number column can subtract", (Object[])new Object[0]);
        DRIExpression value1Expression = ((DRTextField)this.getComponent()).getValueExpression();
        DRIExpression value2Expression = ((DRTextField)column.getComponent()).getValueExpression();
        SubtractExpression exp = new SubtractExpression(value1Expression, value2Expression);
        return (TextColumnBuilder)new TextColumnBuilder<BigDecimal>(exp).setDataType(DynamicReports.type.bigDecimalType());
    }

    public TextColumnBuilder<BigDecimal> subtract(Number number) {
        Validate.isTrue((boolean)Number.class.isAssignableFrom(((DRValueColumn)this.getObject()).getValueClass()), (String)"Only Number column can subtract", (Object[])new Object[0]);
        DRIExpression value1Expression = ((DRTextField)this.getComponent()).getValueExpression();
        ValueExpression<Number> value2Expression = Expressions.number(number);
        SubtractExpression exp = new SubtractExpression(value1Expression, value2Expression);
        return (TextColumnBuilder)new TextColumnBuilder<BigDecimal>(exp).setDataType(DynamicReports.type.bigDecimalType());
    }

    public TextColumnBuilder<BigDecimal> multiply(TextColumnBuilder<? extends Number> column) {
        Validate.isTrue((boolean)Number.class.isAssignableFrom(((DRValueColumn)this.getObject()).getValueClass()), (String)"Only Number column can multiply", (Object[])new Object[0]);
        DRIExpression value1Expression = ((DRTextField)this.getComponent()).getValueExpression();
        DRIExpression value2Expression = ((DRTextField)column.getComponent()).getValueExpression();
        MultiplyExpression exp = new MultiplyExpression(value1Expression, value2Expression);
        return (TextColumnBuilder)new TextColumnBuilder<BigDecimal>(exp).setDataType(DynamicReports.type.bigDecimalType());
    }

    public TextColumnBuilder<BigDecimal> multiply(Number number) {
        Validate.isTrue((boolean)Number.class.isAssignableFrom(((DRValueColumn)this.getObject()).getValueClass()), (String)"Only Number column can multiply", (Object[])new Object[0]);
        DRIExpression value1Expression = ((DRTextField)this.getComponent()).getValueExpression();
        ValueExpression<Number> value2Expression = Expressions.number(number);
        MultiplyExpression exp = new MultiplyExpression(value1Expression, value2Expression);
        return (TextColumnBuilder)new TextColumnBuilder<BigDecimal>(exp).setDataType(DynamicReports.type.bigDecimalType());
    }

    public TextColumnBuilder<BigDecimal> divide(int scale, TextColumnBuilder<? extends Number> column) {
        Validate.isTrue((boolean)Number.class.isAssignableFrom(((DRValueColumn)this.getObject()).getValueClass()), (String)"Only Number column can divide", (Object[])new Object[0]);
        DRIExpression value1Expression = ((DRTextField)this.getComponent()).getValueExpression();
        DRIExpression value2Expression = ((DRTextField)column.getComponent()).getValueExpression();
        DivideExpression exp = new DivideExpression(scale, value1Expression, value2Expression);
        return (TextColumnBuilder)new TextColumnBuilder<BigDecimal>(exp).setDataType(DynamicReports.type.bigDecimalType());
    }

    public TextColumnBuilder<BigDecimal> divide(int scale, Number number) {
        Validate.isTrue((boolean)Number.class.isAssignableFrom(((DRValueColumn)this.getObject()).getValueClass()), (String)"Only Number column can divide", (Object[])new Object[0]);
        DRIExpression value1Expression = ((DRTextField)this.getComponent()).getValueExpression();
        ValueExpression<Number> value2Expression = Expressions.number(number);
        DivideExpression exp = new DivideExpression(scale, value1Expression, value2Expression);
        return (TextColumnBuilder)new TextColumnBuilder<BigDecimal>(exp).setDataType(DynamicReports.type.bigDecimalType());
    }

    @Override
    public String getName() {
        return ((DRValueColumn)this.getObject()).getName();
    }
}

