/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.datatype;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import net.sf.dynamicreports.report.ReportUtils;
import net.sf.dynamicreports.report.base.datatype.AbstractDataType;
import net.sf.dynamicreports.report.exception.DRException;

public abstract class NumberType<T extends Number>
extends AbstractDataType<Number, T> {
    private static final long serialVersionUID = 10000L;

    @Override
    public String valueToString(Number value, Locale locale) {
        if (value != null) {
            return new DecimalFormat(this.getPattern(), new DecimalFormatSymbols(locale)).format(value);
        }
        return null;
    }

    @Override
    public T stringToValue(String value, Locale locale) throws DRException {
        if (value != null) {
            try {
                return this.numberToValue(new DecimalFormat(this.getPattern(), new DecimalFormatSymbols(locale)).parse(value));
            }
            catch (ParseException e) {
                throw new DRException("Unable to convert string value to date", e);
            }
        }
        return null;
    }

    protected abstract T numberToValue(Number var1);

    @Override
    public Class<T> getValueClass() {
        return ReportUtils.getGenericClass(this, 0);
    }
}

