/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.subtotal;

import net.sf.dynamicreports.report.base.DRSubtotal;
import net.sf.dynamicreports.report.base.DRVariable;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.datatype.DataTypes;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.Evaluation;
import net.sf.dynamicreports.report.constant.SubtotalPosition;
import net.sf.dynamicreports.report.definition.DRIField;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.column.DRIValueColumn;
import net.sf.dynamicreports.report.definition.component.DRITextField;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRReportException;

public class AggregationSubtotalBuilder<T>
extends SubtotalBuilder<AggregationSubtotalBuilder<T>, T>
implements DRIValue<T> {
    private static final long serialVersionUID = 10000L;
    private DRIExpression<?> expression;
    private Calculation calculation;

    protected AggregationSubtotalBuilder(ValueColumnBuilder<?, ?> column, Calculation calculation) {
        this((DRIExpression)column.getColumn(), column, calculation);
    }

    protected AggregationSubtotalBuilder(FieldBuilder<?> field, ColumnBuilder<?, ?> showInColumn, Calculation calculation) {
        this((DRIExpression)field.build(), showInColumn, calculation);
    }

    protected AggregationSubtotalBuilder(DRIExpression<?> expression, ColumnBuilder<?, ?> showInColumn, Calculation calculation) {
        super(showInColumn);
        this.expression = expression;
        this.calculation = calculation;
        if (calculation.equals((Object)Calculation.COUNT) || calculation.equals((Object)Calculation.DISTINCT_COUNT)) {
            this.setDataType(DataTypes.longType());
        } else if (calculation.equals((Object)Calculation.AVERAGE) || calculation.equals((Object)Calculation.STANDARD_DEVIATION) || calculation.equals((Object)Calculation.VARIANCE)) {
            this.setDataType(DataTypes.doubleType());
        } else if (expression instanceof DRIValueColumn) {
            this.setDataType(((DRITextField)((DRIValueColumn)expression).getComponent()).getDataType());
            this.setPattern(((DRITextField)((DRIValueColumn)expression).getComponent()).getPattern());
        } else if (expression instanceof DRIField) {
            this.setDataType(((DRIField)expression).getDataType());
        }
    }

    private static Evaluation subtotalPositionToEvaluation(SubtotalPosition position) {
        switch (position) {
            case PAGE_HEADER: 
            case PAGE_FOOTER: {
                return Evaluation.PAGE;
            }
            case COLUMN_HEADER: 
            case COLUMN_FOOTER: {
                return Evaluation.COLUMN;
            }
            case GROUP_HEADER: 
            case GROUP_FOOTER: {
                return Evaluation.GROUP;
            }
            case FIRST_GROUP_HEADER: 
            case FIRST_GROUP_FOOTER: {
                return Evaluation.FIRST_GROUP;
            }
            case LAST_GROUP_HEADER: 
            case LAST_GROUP_FOOTER: {
                return Evaluation.LAST_GROUP;
            }
            case TITLE: 
            case LAST_PAGE_FOOTER: 
            case SUMMARY: {
                return Evaluation.REPORT;
            }
        }
        throw new DRReportException("Subtotal position " + position.name() + " not supported");
    }

    @Override
    protected void configure() {
        DRVariable subtotalVariable = new DRVariable(this.expression, this.calculation);
        Evaluation resetType = AggregationSubtotalBuilder.subtotalPositionToEvaluation(((DRSubtotal)this.getObject()).getPosition());
        subtotalVariable.setResetType(resetType);
        subtotalVariable.setResetGroup(((DRSubtotal)this.getObject()).getGroup());
        this.setValueExpression(subtotalVariable);
        super.configure();
    }

    @Override
    public String getName() {
        return this.getSubtotal().getName();
    }
}

