/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.motherboard.unix;

import java.util.HashMap;
import java.util.Map;
import org.jutils.jhardware.info.motherboard.AbstractMotherboardInfo;
import org.jutils.jhardware.util.HardwareInfoUtils;

public final class UnixMotherboardInfo
extends AbstractMotherboardInfo {
    private static final String DMIPATH = "/sys/devices/virtual/dmi/id/";

    private static String getMotherboardData() {
        String fullData = "";
        if (HardwareInfoUtils.isSudo()) {
            fullData = String.valueOf(fullData) + HardwareInfoUtils.executeCommand("sudo", "dmidecode", "--type", "2");
        } else {
            fullData = String.valueOf(fullData) + "\tProduct Name: " + HardwareInfoUtils.executeCommand("cat", "/sys/devices/virtual/dmi/id/board_name");
            fullData = String.valueOf(fullData) + "\tVendor: " + HardwareInfoUtils.executeCommand("cat", "/sys/devices/virtual/dmi/id/board_vendor");
            fullData = String.valueOf(fullData) + "\tVersion: " + HardwareInfoUtils.executeCommand("cat", "/sys/devices/virtual/dmi/id/board_version");
        }
        return fullData;
    }

    @Override
    protected Map<String, String> parseInfo() {
        String[] dataStringLines;
        HashMap<String, String> motherboardDataMap = new HashMap<String, String>();
        String[] stringArray = dataStringLines = UnixMotherboardInfo.getMotherboardData().split("\\r?\\n");
        int n = dataStringLines.length;
        int n2 = 0;
        while (n2 < n) {
            String dataLine = stringArray[n2];
            if (dataLine.startsWith("\t")) {
                String[] dataStringInfo = dataLine.split(":");
                if (dataStringInfo.length == 2) {
                    motherboardDataMap.put(dataStringInfo[0].trim(), dataStringInfo[1].trim());
                } else if (dataStringInfo.length == 1 && "\tFeatures".equals(dataStringInfo[0])) {
                    motherboardDataMap.put(dataStringInfo[0].trim(), UnixMotherboardInfo.getFeatures(dataStringLines));
                }
            }
            ++n2;
        }
        return motherboardDataMap;
    }

    private static String getFeatures(String[] dataStringLines) {
        StringBuilder features = new StringBuilder();
        String[] stringArray = dataStringLines;
        int n = dataStringLines.length;
        int n2 = 0;
        while (n2 < n) {
            String characteristicsLine = stringArray[n2];
            if (characteristicsLine.trim().length() > 0 && characteristicsLine.startsWith("\t\t")) {
                features.append(characteristicsLine.trim()).append("\n");
            }
            ++n2;
        }
        return features.toString();
    }
}

