/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.search.HitSpanInfo;
import net.sf.jasperreports.search.SpansInfo;

public class LuceneSpansInfo
implements SpansInfo,
Serializable {
    private static final long serialVersionUID = 10200L;
    private Map<String, List<HitSpanInfo>> hitSpanInfoMap;
    private Map<String, Integer> hitSpansPerPage;
    private int termsPerQuery;
    private List<String> queryTerms;

    public LuceneSpansInfo(int termsPerQuery, List<String> queryTerms) {
        this.termsPerQuery = termsPerQuery;
        this.queryTerms = queryTerms;
        this.hitSpanInfoMap = new LinkedHashMap<String, List<HitSpanInfo>>();
        this.hitSpansPerPage = new LinkedHashMap<String, Integer>();
    }

    @Override
    public List<String> getQueryTerms() {
        return this.queryTerms;
    }

    @Override
    public void addSpanInfo(String key, HitSpanInfo hitSpanInfo) {
        if (!this.hitSpanInfoMap.containsKey(key)) {
            this.hitSpanInfoMap.put(key, new ArrayList());
        }
        if (!this.hitSpansPerPage.containsKey(hitSpanInfo.getPageNo())) {
            this.hitSpansPerPage.put(hitSpanInfo.getPageNo(), 0);
        }
        this.hitSpanInfoMap.get(key).add(hitSpanInfo);
        this.hitSpansPerPage.put(hitSpanInfo.getPageNo(), this.hitSpansPerPage.get(hitSpanInfo.getPageNo()) + 1);
    }

    @Override
    public boolean hasHitSpanInfo(String key) {
        return this.hitSpanInfoMap.containsKey(key);
    }

    @Override
    public List<HitSpanInfo> getHitSpanInfo(String key) {
        return this.hitSpanInfoMap.get(key);
    }

    @Override
    public Map<String, Integer> getHitSpansPerPage() {
        return this.hitSpansPerPage;
    }

    @Override
    public int getTermsPerQuery() {
        return this.termsPerQuery;
    }
}

