/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.graphicscard.unix;

import com.profesorfalken.jsensors.JSensors;
import com.profesorfalken.jsensors.model.components.Gpu;
import com.profesorfalken.jsensors.model.sensors.Fan;
import com.profesorfalken.jsensors.model.sensors.Temperature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jutils.jhardware.info.graphicscard.AbstractGraphicsCardInfo;
import org.jutils.jhardware.util.HardwareInfoUtils;

public class UnixGraphicsCardInfo
extends AbstractGraphicsCardInfo {
    private static final String LSHW_COMMAND = "lshw";
    private static final String LSHW_PARAMS = "-C";

    private static String getGraphicsCardData() {
        return HardwareInfoUtils.executeCommand(LSHW_COMMAND, LSHW_PARAMS, "video");
    }

    @Override
    protected Map<String, String> parseInfo() {
        HashMap<String, String> graphicsCardDataMap = new HashMap<String, String>();
        int count = -1;
        String graphicsCardData = UnixGraphicsCardInfo.getGraphicsCardData();
        if (graphicsCardData != null) {
            String[] dataStringLines;
            String[] stringArray = dataStringLines = UnixGraphicsCardInfo.getGraphicsCardData().split("\\r?\\n");
            int n = dataStringLines.length;
            int n2 = 0;
            while (n2 < n) {
                String dataLine = stringArray[n2];
                String line = dataLine.trim();
                if (line.startsWith("*-display")) {
                    ++count;
                } else if (line.startsWith("product:")) {
                    graphicsCardDataMap.put("name_" + count, line.split(":", 2)[1]);
                } else if (line.startsWith("vendor:")) {
                    graphicsCardDataMap.put("manufacturer_" + count, line.split(":", 2)[1]);
                } else if (line.startsWith("description:")) {
                    graphicsCardDataMap.put("chip_type_" + count, line.split(":", 2)[1]);
                }
                ++n2;
            }
            List gpus = JSensors.get.components().gpus;
            int i = 0;
            while (i < count) {
                if (gpus.size() > i) {
                    Gpu gpu = (Gpu)gpus.get(i);
                    if (gpu.sensors.temperatures != null && !gpu.sensors.temperatures.isEmpty()) {
                        graphicsCardDataMap.put("temperature_" + i, String.valueOf(((Temperature)gpu.sensors.temperatures.get((int)0)).value.intValue()));
                    }
                    if (gpu.sensors.fans != null && !gpu.sensors.fans.isEmpty()) {
                        graphicsCardDataMap.put("fan_" + i, String.valueOf(((Fan)gpu.sensors.fans.get((int)0)).value.intValue()));
                    }
                }
                ++i;
            }
        }
        graphicsCardDataMap.put("numOfGraphicsCards", String.valueOf(count + 1));
        return graphicsCardDataMap;
    }
}

