/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.memory.unix;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jutils.jhardware.info.memory.AbstractMemoryInfo;
import org.jutils.jhardware.util.HardwareInfoUtils;

public final class UnixMemoryInfo
extends AbstractMemoryInfo {
    private static final String MEMINFO = "/proc/meminfo";

    private static String getMemoryData() {
        Stream<String> streamMemoryInfo = HardwareInfoUtils.readFile(MEMINFO);
        StringBuilder buffer = new StringBuilder();
        streamMemoryInfo.forEach(line -> {
            StringBuilder stringBuilder2 = buffer.append((String)line).append("\r\n");
        });
        return buffer.toString();
    }

    @Override
    protected Map<String, String> parseInfo() {
        String[] dataStringLines;
        HashMap<String, String> memoryDataMap = new HashMap<String, String>();
        String[] stringArray = dataStringLines = UnixMemoryInfo.getMemoryData().split("\\r?\\n");
        int n = dataStringLines.length;
        int n2 = 0;
        while (n2 < n) {
            String dataLine = stringArray[n2];
            String[] dataStringInfo = dataLine.split(":");
            memoryDataMap.put(dataStringInfo[0].trim(), dataStringInfo.length == 2 ? dataStringInfo[1].trim() : "");
            ++n2;
        }
        return memoryDataMap;
    }
}

