/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.chartcustomizer;

import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.chart.DRIChartCustomizer;
import net.sf.dynamicreports.report.definition.chart.plot.DRIDifferencePlot;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;

public class DifferenceRendererCustomizer
implements DRIChartCustomizer,
Serializable {
    private static final long serialVersionUID = 10000L;
    private Color positiveColor;
    private Color negativeColor;
    private Boolean showShapes;

    public DifferenceRendererCustomizer(DRIDifferencePlot differencePlot) {
        this.positiveColor = differencePlot.getPositiveColor();
        this.negativeColor = differencePlot.getNegativeColor();
        this.showShapes = differencePlot.getShowShapes();
    }

    @Override
    public void customize(JFreeChart chart, ReportParameters reportParameters) {
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)chart.getXYPlot().getRenderer();
        XYDifferenceRenderer renderer = new XYDifferenceRenderer();
        renderer.setBaseItemLabelsVisible(lineRenderer.getBaseItemLabelsVisible());
        renderer.setBaseItemLabelFont(lineRenderer.getBaseItemLabelFont());
        renderer.setBaseItemLabelPaint(lineRenderer.getBaseItemLabelPaint());
        renderer.setBaseItemLabelGenerator(lineRenderer.getBaseItemLabelGenerator());
        if (this.positiveColor != null) {
            renderer.setPositivePaint((Paint)this.positiveColor);
        }
        if (this.negativeColor != null) {
            renderer.setNegativePaint((Paint)this.negativeColor);
        }
        if (this.showShapes != null) {
            renderer.setShapesVisible(this.showShapes.booleanValue());
        }
        chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
    }
}

