/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.expressions;

import java.text.MessageFormat;
import java.util.List;
import net.sf.dynamicreports.report.builder.expression.AbstractComplexExpression;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class PageXofYNumberExpression
extends AbstractComplexExpression<String> {
    private static final long serialVersionUID = 10000L;
    private int index;

    public PageXofYNumberExpression(DRIExpression<String> pageNumberFormatExpression, int index) {
        this.addExpression(pageNumberFormatExpression);
        this.index = index;
    }

    @Override
    public String evaluate(List<?> values, ReportParameters reportParameters) {
        String pattern = (String)values.get(0);
        Validate.isTrue((boolean)StringUtils.contains((CharSequence)pattern, (CharSequence)"{0}"), (String)("Wrong format pattern \"" + pattern + "\", missing argument {0}"), (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.contains((CharSequence)pattern, (CharSequence)"{1}"), (String)("Wrong format pattern \"" + pattern + "\", missing argument {1}"), (Object[])new Object[0]);
        Validate.isTrue((pattern.indexOf("{0}") < pattern.indexOf("{1}") ? 1 : 0) != 0, (String)("Wrong format pattern \"" + pattern + "\", argument {0} must be before {1}"), (Object[])new Object[0]);
        int index1 = pattern.indexOf("{0}");
        pattern = this.index == 0 ? pattern.substring(0, index1 + 3) : pattern.substring(index1 + 3);
        MessageFormat format = new MessageFormat(pattern, reportParameters.getLocale());
        String result = format.format(new Object[]{reportParameters.getPageNumber(), reportParameters.getPageNumber()});
        return result;
    }
}

