/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.jasper.builder;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.sf.dynamicreports.design.base.DRDesignReport;
import net.sf.dynamicreports.jasper.base.JasperReportDesign;
import net.sf.dynamicreports.jasper.base.export.AbstractJasperExporter;
import net.sf.dynamicreports.jasper.base.export.JasperImageExporter;
import net.sf.dynamicreports.jasper.base.tableofcontents.JasperTocReport;
import net.sf.dynamicreports.jasper.base.templatedesign.JasperEmptyTemplateDesign;
import net.sf.dynamicreports.jasper.base.templatedesign.JasperTemplateDesign;
import net.sf.dynamicreports.jasper.builder.export.AbstractJasperExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.Exporters;
import net.sf.dynamicreports.jasper.builder.export.JasperCsvExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperDocxExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperHtmlExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperImageExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperOdsExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperOdtExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperPdfExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperPptxExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperRtfExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperTextExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperXlsExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperXlsxExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperXmlExporterBuilder;
import net.sf.dynamicreports.jasper.constant.ImageType;
import net.sf.dynamicreports.jasper.definition.export.JasperIExporter;
import net.sf.dynamicreports.jasper.exception.JasperDesignException;
import net.sf.dynamicreports.jasper.transformation.ExporterTransform;
import net.sf.dynamicreports.jasper.transformation.JasperTransform;
import net.sf.dynamicreports.report.base.DRQuery;
import net.sf.dynamicreports.report.base.DRReport;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.QueryBuilder;
import net.sf.dynamicreports.report.builder.ReportBuilder;
import net.sf.dynamicreports.report.definition.DRIReport;
import net.sf.dynamicreports.report.definition.DRITemplateDesign;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import net.sf.jasperreports.export.Exporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleGraphics2DExporterConfiguration;
import net.sf.jasperreports.export.SimpleGraphics2DExporterOutput;
import net.sf.jasperreports.export.SimpleGraphics2DReportConfiguration;
import net.sf.jasperreports.view.JasperDesignViewer;
import net.sf.jasperreports.view.JasperViewer;
import org.apache.commons.lang3.Validate;

public class JasperReportBuilder
extends ReportBuilder<JasperReportBuilder> {
    private static final long serialVersionUID = 10000L;
    private JasperReportDesign reportDesign;
    private JasperDesign jasperDesign;
    private JasperReport jasperReport;
    private JasperPrint jasperPrint;
    private transient JRDataSource dataSource;
    private transient Connection connection;
    private transient JRVirtualizer virtualizer;
    private Integer startPageNumber;
    private Map<String, Object> parameters;

    public JasperReportBuilder() {
        this.setTemplateDesign(new JasperEmptyTemplateDesign());
    }

    public JasperReportBuilder setStartPageNumber(Integer startPageNumber) throws DRException {
        if (this.startPageNumber == startPageNumber) {
            return this;
        }
        this.startPageNumber = startPageNumber;
        this.rebuild();
        return this;
    }

    public JasperReportBuilder setDataSource(Collection<?> collection) {
        return this.setDataSource((JRDataSource)new JRBeanCollectionDataSource(collection));
    }

    public JasperReportBuilder setDataSource(ResultSet resultSet) {
        return this.setDataSource((JRDataSource)new JRResultSetDataSource(resultSet));
    }

    public JasperReportBuilder setDataSource(String sql, Connection connection) {
        Validate.notNull((Object)sql, (String)"sql must not be null", (Object[])new Object[0]);
        return this.setDataSource(DynamicReports.query(sql, "sql"), connection);
    }

    public JasperReportBuilder setDataSource(QueryBuilder query, Connection connection) {
        Validate.notNull((Object)query, (String)"query must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)connection, (String)"connection must not be null", (Object[])new Object[0]);
        ((DRReport)this.getObject()).setQuery((DRQuery)query.build());
        this.connection = connection;
        this.dataSource = null;
        return this;
    }

    public JasperReportBuilder setTemplateDesign(InputStream inputStream) throws DRException {
        return this.setTemplateDesign(new JasperTemplateDesign(inputStream));
    }

    public JasperReportBuilder setTemplateDesign(File file) throws DRException {
        return this.setTemplateDesign(new JasperTemplateDesign(file));
    }

    public JasperReportBuilder setTemplateDesign(String fileName) throws DRException {
        return this.setTemplateDesign(new JasperTemplateDesign(fileName));
    }

    public JasperReportBuilder setTemplateDesign(JasperDesign jasperDesign) throws DRException {
        return this.setTemplateDesign(new JasperTemplateDesign(jasperDesign));
    }

    public JasperReportBuilder setTemplateDesign(URL jasperDesignUrl) throws DRException {
        return this.setTemplateDesign(new JasperTemplateDesign(jasperDesignUrl));
    }

    private JasperReportBuilder setTemplateDesign(DRITemplateDesign<JasperDesign> templateDesign) {
        ((DRReport)this.getObject()).setTemplateDesign(templateDesign);
        return this;
    }

    @Override
    public JasperReportBuilder setParameter(String name, Object value) {
        super.setParameter(name, value);
        this.parameters = null;
        this.jasperPrint = null;
        return this;
    }

    @Override
    public JasperReportBuilder setParameters(Map<String, Object> parameters) {
        super.setParameters(parameters);
        this.parameters = null;
        this.jasperPrint = null;
        return this;
    }

    public JasperReportBuilder rebuild() throws DRException {
        this.builded = false;
        this.reportDesign = null;
        this.jasperDesign = null;
        this.jasperReport = null;
        this.parameters = null;
        this.jasperPrint = null;
        if (this.dataSource != null && this.dataSource instanceof JRRewindableDataSource) {
            try {
                ((JRRewindableDataSource)this.dataSource).moveFirst();
            }
            catch (JRException e) {
                throw new DRException(e);
            }
        }
        return this;
    }

    private JasperReportDesign toJasperReportDesign() throws DRException {
        if (this.reportDesign == null) {
            DRDesignReport report = new DRDesignReport((DRIReport)this.build());
            this.reportDesign = new JasperReportDesign(report, this.startPageNumber);
            JasperTransform jasperTransform = new JasperTransform(report, this.reportDesign);
            jasperTransform.transform();
        }
        return this.reportDesign;
    }

    public JasperDesign toJasperDesign() throws DRException {
        if (this.jasperDesign == null) {
            this.jasperDesign = this.toJasperReportDesign().getDesign();
        }
        return this.jasperDesign;
    }

    public JasperReport toJasperReport() throws DRException {
        if (this.jasperReport == null) {
            try {
                this.jasperReport = JasperCompileManager.compileReport((JasperDesign)this.toJasperDesign());
            }
            catch (JRException e) {
                throw new DRException(e);
            }
        }
        return this.jasperReport;
    }

    public Map<String, Object> getJasperParameters() throws DRException {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>();
            JasperReportDesign jasperReportDesign = this.toJasperReportDesign();
            this.parameters.putAll(jasperReportDesign.getParameters());
            if (this.getReport().getParameterValues() != null) {
                this.parameters.putAll(this.getReport().getParameterValues());
            }
        }
        return this.parameters;
    }

    public JasperPrint toJasperPrint() throws DRException {
        if (this.jasperPrint == null) {
            Map<String, Object> parameters = this.getJasperParameters();
            if (this.virtualizer != null) {
                parameters.put("REPORT_VIRTUALIZER", this.virtualizer);
            }
            try {
                this.jasperPrint = this.connection != null && this.toJasperReport().getQuery() != null ? JasperFillManager.fillReport((JasperReport)this.toJasperReport(), parameters, (Connection)this.connection) : (this.dataSource != null ? JasperFillManager.fillReport((JasperReport)this.toJasperReport(), parameters, (JRDataSource)this.dataSource) : JasperFillManager.fillReport((JasperReport)this.toJasperReport(), parameters));
                if (this.toJasperReportDesign().isTableOfContents()) {
                    JasperTocReport.createTocReport(this.toJasperReportDesign(), this.jasperPrint, parameters);
                }
            }
            catch (JRException e) {
                throw new DRException(e);
            }
        }
        return this.jasperPrint;
    }

    public JasperReportBuilder show() throws DRException {
        JasperViewer.viewReport((JasperPrint)this.toJasperPrint());
        return this;
    }

    public JasperReportBuilder show(boolean exitOnClose) throws DRException {
        JasperViewer.viewReport((JasperPrint)this.toJasperPrint(), (boolean)exitOnClose, null);
        return this;
    }

    public JasperReportBuilder showJrXml() throws DRException {
        try {
            JasperDesignViewer.viewReportDesign((JRReport)this.toJasperDesign());
        }
        catch (JRException e) {
            throw new DRException(e);
        }
        return this;
    }

    public JasperReportBuilder toJrXml(OutputStream outputStream) throws DRException {
        Validate.notNull((Object)outputStream, (String)"outputStream must not be null", (Object[])new Object[0]);
        try {
            JRXmlWriter.writeReport((JRReport)this.toJasperDesign(), (OutputStream)outputStream, (String)"UTF-8");
        }
        catch (JRException e) {
            throw new DRException(e);
        }
        return this;
    }

    public JasperReportBuilder print() throws DRException {
        return this.print(true);
    }

    public JasperReportBuilder print(boolean withPrintDialog) throws DRException {
        try {
            JasperPrintManager.printReport((JasperPrint)this.toJasperPrint(), (boolean)withPrintDialog);
        }
        catch (JRException e) {
            throw new DRException(e);
        }
        return this;
    }

    public JasperReportBuilder setVirtualizer(JRVirtualizer virtualizer) {
        this.virtualizer = virtualizer;
        return this;
    }

    public JasperReportBuilder toImage(OutputStream outputStream, ImageType imageType) throws DRException {
        return this.toImage(Exporters.imageExporter(outputStream, imageType));
    }

    public JasperReportBuilder toImage(JasperImageExporterBuilder imageExporterBuilder) throws DRException {
        block18: {
            Validate.notNull((Object)imageExporterBuilder, (String)"imageExporterBuilder must not be null", (Object[])new Object[0]);
            JasperImageExporter imageExporter = (JasperImageExporter)imageExporterBuilder.build();
            JasperPrint jasperPrint = this.toJasperPrint();
            Integer fromPage = null;
            Integer toPage = null;
            float zoom = 1.0f;
            String imageType = imageExporter.getImageType().name().toLowerCase();
            int offsetX = 0;
            int offsetY = 0;
            int pageGap = 0;
            if (imageExporter.getZoomRatio() != null) {
                zoom = imageExporter.getZoomRatio().floatValue();
            }
            if (imageExporter.getOffsetX() != null) {
                offsetX = imageExporter.getOffsetX();
            }
            if (imageExporter.getOffsetY() != null) {
                offsetY = imageExporter.getOffsetY();
            }
            if (imageExporter.getPageGap() != null) {
                pageGap = imageExporter.getPageGap();
            }
            if (imageExporter.getPageIndex() != null && imageExporter.getPageIndex() >= 0) {
                fromPage = imageExporter.getPageIndex();
                toPage = imageExporter.getPageIndex() + 1;
            } else {
                if (imageExporter.getStartPageIndex() != null) {
                    fromPage = imageExporter.getStartPageIndex();
                }
                if (imageExporter.getEndPageIndex() != null) {
                    toPage = imageExporter.getEndPageIndex();
                }
            }
            if (fromPage == null) {
                fromPage = 0;
            }
            if (toPage == null) {
                toPage = jasperPrint.getPages().size();
            }
            int pages = toPage - fromPage;
            int pageWidth = (int)((float)jasperPrint.getPageWidth() * zoom);
            int pageHeight = (int)((float)jasperPrint.getPageHeight() * zoom);
            int width = pageWidth * pages + pages - 1 + offsetX * 2;
            int height = (int)((float)jasperPrint.getPageHeight() * zoom) + offsetY * 2;
            BufferedImage image = new BufferedImage(width, height, 1);
            int offset = offsetX;
            for (int i = 0; i < pages; ++i) {
                try {
                    SimpleExporterInput exporterInput = new SimpleExporterInput(jasperPrint);
                    SimpleGraphics2DExporterOutput exporterOutput = new SimpleGraphics2DExporterOutput();
                    BufferedImage pageImage = new BufferedImage(pageWidth, pageHeight, 1);
                    exporterOutput.setGraphics2D((Graphics2D)((Image)pageImage).getGraphics());
                    SimpleGraphics2DReportConfiguration reportExportConfiguration = new SimpleGraphics2DReportConfiguration();
                    reportExportConfiguration.setPageIndex(fromPage);
                    reportExportConfiguration.setZoomRatio(Float.valueOf(zoom));
                    SimpleGraphics2DExporterConfiguration exporterConfiguration = new SimpleGraphics2DExporterConfiguration();
                    JRGraphics2DExporter jrExporter = new JRGraphics2DExporter();
                    jrExporter.setExporterInput((ExporterInput)exporterInput);
                    jrExporter.setExporterOutput((ExporterOutput)exporterOutput);
                    jrExporter.setConfiguration((ReportExportConfiguration)reportExportConfiguration);
                    jrExporter.setConfiguration((ExporterConfiguration)exporterConfiguration);
                    jrExporter.exportReport();
                    ((Graphics2D)((Image)image).getGraphics()).drawImage((Image)pageImage, offset, offsetY, null);
                    Integer n = fromPage;
                    Integer n2 = fromPage = Integer.valueOf(fromPage + 1);
                    offset += pageWidth + pageGap;
                    continue;
                }
                catch (JRException e) {
                    throw new DRException(e);
                }
            }
            try {
                if (imageExporter.getOutputStream() != null) {
                    ImageIO.write((RenderedImage)image, imageType, imageExporter.getOutputStream());
                    break block18;
                }
                if (imageExporter.getOutputFileName() != null) {
                    ImageIO.write((RenderedImage)image, imageType, new File(imageExporter.getOutputFileName()));
                    break block18;
                }
                if (imageExporter.getOutputFile() != null) {
                    ImageIO.write((RenderedImage)image, imageType, imageExporter.getOutputFile());
                    break block18;
                }
                throw new JasperDesignException("ImageExporter output not supported");
            }
            catch (IOException e) {
                throw new DRException(e);
            }
        }
        return this;
    }

    public JasperReportBuilder toCsv(OutputStream outputStream) throws DRException {
        return this.toCsv(Exporters.csvExporter(outputStream));
    }

    public JasperReportBuilder toCsv(JasperCsvExporterBuilder csvExporterBuilder) throws DRException {
        return this.export(csvExporterBuilder);
    }

    public JasperReportBuilder toDocx(OutputStream outputStream) throws DRException {
        return this.toDocx(Exporters.docxExporter(outputStream));
    }

    public JasperReportBuilder toDocx(JasperDocxExporterBuilder docxExporterBuilder) throws DRException {
        return this.export(docxExporterBuilder);
    }

    public JasperReportBuilder toHtml(OutputStream outputStream) throws DRException {
        return this.toHtml(Exporters.htmlExporter(outputStream));
    }

    public JasperReportBuilder toHtml(JasperHtmlExporterBuilder htmlExporterBuilder) throws DRException {
        return this.export(htmlExporterBuilder);
    }

    public JasperReportBuilder toOds(OutputStream outputStream) throws DRException {
        return this.toOds(Exporters.odsExporter(outputStream));
    }

    public JasperReportBuilder toOds(JasperOdsExporterBuilder odsExporterBuilder) throws DRException {
        return this.export(odsExporterBuilder);
    }

    public JasperReportBuilder toOdt(OutputStream outputStream) throws DRException {
        return this.toOdt(Exporters.odtExporter(outputStream));
    }

    public JasperReportBuilder toOdt(JasperOdtExporterBuilder odtExporterBuilder) throws DRException {
        return this.export(odtExporterBuilder);
    }

    public JasperReportBuilder toPdf(OutputStream outputStream) throws DRException {
        return this.toPdf(Exporters.pdfExporter(outputStream));
    }

    public JasperReportBuilder toPdf(JasperPdfExporterBuilder pdfExporterBuilder) throws DRException {
        return this.export(pdfExporterBuilder);
    }

    public JasperReportBuilder toRtf(OutputStream outputStream) throws DRException {
        return this.toRtf(Exporters.rtfExporter(outputStream));
    }

    public JasperReportBuilder toRtf(JasperRtfExporterBuilder rtfExporterBuilder) throws DRException {
        return this.export(rtfExporterBuilder);
    }

    public JasperReportBuilder toText(OutputStream outputStream) throws DRException {
        return this.toText(Exporters.textExporter(outputStream));
    }

    public JasperReportBuilder toText(JasperTextExporterBuilder textExporterBuilder) throws DRException {
        return this.export(textExporterBuilder);
    }

    public JasperReportBuilder toXls(OutputStream outputStream) throws DRException {
        return this.toXls(Exporters.xlsExporter(outputStream));
    }

    public JasperReportBuilder toXls(JasperXlsExporterBuilder xlsExporterBuilder) throws DRException {
        return this.export(xlsExporterBuilder);
    }

    public JasperReportBuilder toXlsx(OutputStream outputStream) throws DRException {
        return this.toXlsx(Exporters.xlsxExporter(outputStream));
    }

    public JasperReportBuilder toXlsx(JasperXlsxExporterBuilder xlsxExporterBuilder) throws DRException {
        return this.export(xlsxExporterBuilder);
    }

    public JasperReportBuilder toXml(OutputStream outputStream) throws DRException {
        return this.toXml(Exporters.xmlExporter(outputStream));
    }

    public JasperReportBuilder toXml(JasperXmlExporterBuilder xmlExporterBuilder) throws DRException {
        return this.export(xmlExporterBuilder);
    }

    public JasperReportBuilder toPptx(OutputStream outputStream) throws DRException {
        return this.toPptx(Exporters.pptxExporter(outputStream));
    }

    public JasperReportBuilder toPptx(JasperPptxExporterBuilder pptxExporterBuilder) throws DRException {
        return this.export(pptxExporterBuilder);
    }

    public JasperReportBuilder export(AbstractJasperExporterBuilder<?, ? extends AbstractJasperExporter> exporterBuilder) throws DRException {
        Validate.notNull(exporterBuilder, (String)"exporterBuilder must not be null", (Object[])new Object[0]);
        try {
            ExporterTransform exporterTransform = new ExporterTransform((JasperIExporter)exporterBuilder.build());
            Exporter<?, ?, ?, ?> exporter = exporterTransform.transform();
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.toJasperPrint()));
            exporter.exportReport();
        }
        catch (JRException e) {
            throw new DRException(e);
        }
        return this;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public JasperReportBuilder setConnection(Connection connection) {
        Validate.notNull((Object)connection, (String)"connection must not be null", (Object[])new Object[0]);
        this.connection = connection;
        return this;
    }

    public JRDataSource getDataSource() {
        return this.dataSource;
    }

    public JasperReportBuilder setDataSource(JRDataSource dataSource) {
        this.dataSource = dataSource;
        this.connection = null;
        return this;
    }
}

