/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report;

import java.lang.reflect.ParameterizedType;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.dynamicreports.report.constant.Calculation;

public class ReportUtils {
    private static final Lock LOCK = new ReentrantLock();
    private static int counter;

    public static String generateUniqueName(String name) {
        try {
            LOCK.lock();
            String string = ReportUtils.generateName(name);
            return string;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static Class<?> getVariableValueClass(Calculation calculation, Class<?> valueClass) {
        if (calculation.equals((Object)Calculation.COUNT) || calculation.equals((Object)Calculation.DISTINCT_COUNT)) {
            return Long.class;
        }
        if (calculation.equals((Object)Calculation.AVERAGE) || calculation.equals((Object)Calculation.STANDARD_DEVIATION) || calculation.equals((Object)Calculation.VARIANCE)) {
            return Number.class;
        }
        return valueClass;
    }

    public static Class<?> getGenericClass(Object object, int index) {
        ParameterizedType genericSuperclass = ReportUtils.getParameterizedType(object.getClass());
        if (genericSuperclass == null) {
            return String.class;
        }
        Class<?> rawType = ReportUtils.getRawType(genericSuperclass.getActualTypeArguments()[index]);
        if (rawType == null) {
            return String.class;
        }
        return rawType;
    }

    static void setCounter(int counter) {
        ReportUtils.counter = counter;
    }

    private static ParameterizedType getParameterizedType(Class<?> classs) {
        if (classs == null) {
            return null;
        }
        if (classs.getGenericSuperclass() instanceof ParameterizedType) {
            return (ParameterizedType)classs.getGenericSuperclass();
        }
        return ReportUtils.getParameterizedType((Class)classs.getGenericSuperclass());
    }

    private static Class<?> getRawType(Object typeArgument) {
        if (typeArgument instanceof ParameterizedType) {
            return ReportUtils.getRawType(((ParameterizedType)typeArgument).getRawType());
        }
        if (typeArgument instanceof Class) {
            return (Class)typeArgument;
        }
        return null;
    }

    private static String generateName(String name) {
        if (counter == Integer.MAX_VALUE) {
            counter = 0;
        }
        return name + "_" + counter++ + "_";
    }
}

