/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import net.sf.dynamicreports.report.base.DRBand;
import net.sf.dynamicreports.report.base.DRField;
import net.sf.dynamicreports.report.base.DRGroup;
import net.sf.dynamicreports.report.base.DRPage;
import net.sf.dynamicreports.report.base.DRParameter;
import net.sf.dynamicreports.report.base.DRQuery;
import net.sf.dynamicreports.report.base.DRReportTemplate;
import net.sf.dynamicreports.report.base.DRSort;
import net.sf.dynamicreports.report.base.DRSubtotal;
import net.sf.dynamicreports.report.base.DRVariable;
import net.sf.dynamicreports.report.base.column.DRColumn;
import net.sf.dynamicreports.report.base.grid.DRColumnGrid;
import net.sf.dynamicreports.report.base.style.DRConditionalStyle;
import net.sf.dynamicreports.report.base.style.DRSimpleStyle;
import net.sf.dynamicreports.report.constant.Orientation;
import net.sf.dynamicreports.report.constant.RunDirection;
import net.sf.dynamicreports.report.constant.WhenNoDataType;
import net.sf.dynamicreports.report.constant.WhenResourceMissingType;
import net.sf.dynamicreports.report.definition.DRIReport;
import net.sf.dynamicreports.report.definition.DRIScriptlet;
import net.sf.dynamicreports.report.definition.DRITableOfContentsCustomizer;
import net.sf.dynamicreports.report.definition.DRITemplateDesign;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.style.DRIFont;
import net.sf.dynamicreports.report.definition.style.DRIReportStyle;
import net.sf.dynamicreports.report.definition.style.DRIStyle;
import org.apache.commons.lang3.Validate;

public class DRReport
implements DRIReport {
    private static final long serialVersionUID = 10000L;
    private DRReportTemplate template;
    private List<DRIStyle> templateStyles;
    private DRITemplateDesign<?> templateDesign;
    private String reportName;
    private Locale locale;
    private ResourceBundle resourceBundle;
    private String resourceBundleName;
    private Boolean ignorePagination;
    private Boolean showColumnTitle;
    private Boolean showColumnValues;
    private List<DRColumn<?>> columns;
    private List<DRGroup> groups;
    private List<DRSubtotal<?>> subtotals;
    private List<DRField<?>> fields;
    private List<DRVariable<?>> variables;
    private List<DRSort> sorts;
    private List<DRParameter<?>> parameters;
    private Map<String, Object> parameterValues;
    private List<DRIScriptlet> scriptlets;
    private Properties properties;
    private DRQuery query;
    private DRPage page;
    private WhenNoDataType whenNoDataType;
    private WhenResourceMissingType whenResourceMissingType;
    private Boolean titleOnANewPage;
    private Boolean summaryOnANewPage;
    private Boolean summaryWithPageHeaderAndFooter;
    private Boolean floatColumnFooter;
    private Orientation printOrder;
    private RunDirection columnDirection;
    private String language;
    private Boolean useFieldNameAsDescription;
    private Boolean highlightDetailOddRows;
    private DRSimpleStyle detailOddRowStyle;
    private Boolean highlightDetailEvenRows;
    private DRSimpleStyle detailEvenRowStyle;
    private List<DRConditionalStyle> detailRowHighlighters;
    private DRColumnGrid columnGrid;
    private Boolean tableOfContents;
    private DRITableOfContentsCustomizer tableOfContentsCustomizer;
    private DRIExpression<Boolean> filterExpression;
    private DRIFont defaultFont;
    private DRIReportStyle textStyle;
    private DRIReportStyle columnTitleStyle;
    private DRIReportStyle columnStyle;
    private DRIReportStyle groupTitleStyle;
    private DRIReportStyle groupStyle;
    private DRIReportStyle subtotalStyle;
    private DRIReportStyle imageStyle;
    private DRIReportStyle chartStyle;
    private DRIReportStyle barcodeStyle;
    private DRBand titleBand;
    private DRBand pageHeaderBand;
    private DRBand pageFooterBand;
    private DRBand columnHeaderBand;
    private DRBand columnFooterBand;
    private DRBand detailBand;
    private DRBand detailHeaderBand;
    private DRBand detailFooterBand;
    private DRBand lastPageFooterBand;
    private DRBand summaryBand;
    private DRBand noDataBand;
    private DRBand backgroundBand;

    public DRReport() {
        this.init();
    }

    private void init() {
        this.template = new DRReportTemplate();
        this.templateStyles = new ArrayList<DRIStyle>();
        this.columns = new ArrayList();
        this.groups = new ArrayList<DRGroup>();
        this.subtotals = new ArrayList();
        this.fields = new ArrayList();
        this.variables = new ArrayList();
        this.sorts = new ArrayList<DRSort>();
        this.parameters = new ArrayList();
        this.scriptlets = new ArrayList<DRIScriptlet>();
        this.detailRowHighlighters = new ArrayList<DRConditionalStyle>();
        this.properties = new Properties();
        this.page = new DRPage();
        this.titleBand = new DRBand();
        this.pageHeaderBand = new DRBand();
        this.pageFooterBand = new DRBand();
        this.columnHeaderBand = new DRBand();
        this.columnFooterBand = new DRBand();
        this.detailBand = new DRBand();
        this.detailHeaderBand = new DRBand();
        this.detailFooterBand = new DRBand();
        this.lastPageFooterBand = new DRBand();
        this.summaryBand = new DRBand();
        this.noDataBand = new DRBand();
        this.backgroundBand = new DRBand();
    }

    @Override
    public DRReportTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(DRReportTemplate template) {
        Validate.notNull((Object)template, (String)"template must not be null", (Object[])new Object[0]);
        this.template = template;
    }

    @Override
    public List<DRIStyle> getTemplateStyles() {
        return this.templateStyles;
    }

    public void setTemplateStyles(List<DRIStyle> templateStyles) {
        this.templateStyles = templateStyles;
    }

    public void addTemplateStyle(DRIStyle templateStyle) {
        Validate.notNull((Object)templateStyle, (String)"templateStyle must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)templateStyle.getName(), (String)"templateStyle name must not be null", (Object[])new Object[0]);
        this.templateStyles.add(templateStyle);
    }

    @Override
    public DRITemplateDesign<?> getTemplateDesign() {
        return this.templateDesign;
    }

    public void setTemplateDesign(DRITemplateDesign<?> templateDesign) {
        Validate.notNull(templateDesign, (String)"templateDesign must not be null", (Object[])new Object[0]);
        this.templateDesign = templateDesign;
    }

    @Override
    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    @Override
    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
    }

    @Override
    public Boolean getShowColumnTitle() {
        return this.showColumnTitle;
    }

    public void setShowColumnTitle(Boolean showColumnTitle) {
        this.showColumnTitle = showColumnTitle;
    }

    @Override
    public Boolean getShowColumnValues() {
        return this.showColumnValues;
    }

    public void setShowColumnValues(Boolean showColumnValues) {
        this.showColumnValues = showColumnValues;
    }

    public List<DRColumn<?>> getColumns() {
        return this.columns;
    }

    public void setColumns(List<DRColumn<?>> columns) {
        Validate.notNull(columns, (String)"columns must not be null", (Object[])new Object[0]);
        Validate.noNullElements(columns, (String)"columns must not contains null column", (Object[])new Object[0]);
        this.columns = columns;
    }

    public void addColumn(DRColumn<?> column) {
        Validate.notNull(column, (String)"column must not be null", (Object[])new Object[0]);
        this.columns.add(column);
    }

    public List<DRGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(List<DRGroup> groups) {
        Validate.notNull(groups, (String)"groups must not be null", (Object[])new Object[0]);
        Validate.noNullElements(groups, (String)"groups must not contains null group", (Object[])new Object[0]);
        this.groups = groups;
    }

    public void addGroup(DRGroup group) {
        Validate.notNull((Object)group, (String)"group must not be null", (Object[])new Object[0]);
        this.groups.add(group);
    }

    public List<DRField<?>> getFields() {
        return this.fields;
    }

    public void setFields(List<DRField<?>> fields) {
        Validate.notNull(fields, (String)"fields must not be null", (Object[])new Object[0]);
        Validate.noNullElements(fields, (String)"fields must not contains null field", (Object[])new Object[0]);
        this.fields = fields;
    }

    public void addField(DRField<?> field) {
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        this.fields.add(field);
    }

    public List<DRVariable<?>> getVariables() {
        return this.variables;
    }

    public void setVariables(List<DRVariable<?>> variables) {
        Validate.notNull(variables, (String)"variables must not be null", (Object[])new Object[0]);
        Validate.noNullElements(variables, (String)"variables must not contains null variable", (Object[])new Object[0]);
        this.variables = variables;
    }

    public void addVariable(DRVariable<?> variable) {
        Validate.notNull(variable, (String)"variable must not be null", (Object[])new Object[0]);
        this.variables.add(variable);
    }

    public List<DRSort> getSorts() {
        return this.sorts;
    }

    public void setSorts(List<DRSort> sorts) {
        Validate.notNull(sorts, (String)"sorts must not be null", (Object[])new Object[0]);
        Validate.noNullElements(sorts, (String)"sorts must not contains null sort", (Object[])new Object[0]);
        this.sorts = sorts;
    }

    public void addSort(DRSort sort) {
        Validate.notNull((Object)sort, (String)"sort must not be null", (Object[])new Object[0]);
        this.sorts.add(sort);
    }

    public List<DRSubtotal<?>> getSubtotals() {
        return this.subtotals;
    }

    public void setSubtotals(List<DRSubtotal<?>> subtotals) {
        Validate.notNull(subtotals, (String)"subtotals must not be null", (Object[])new Object[0]);
        Validate.noNullElements(subtotals, (String)"subtotals must not contains null subtotal", (Object[])new Object[0]);
        this.subtotals = subtotals;
    }

    public void addSubtotal(DRSubtotal<?> subtotal) {
        Validate.notNull(subtotal, (String)"subtotal must not be null", (Object[])new Object[0]);
        this.subtotals.add(subtotal);
    }

    public List<DRParameter<?>> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<DRParameter<?>> parameters) {
        Validate.notNull(parameters, (String)"parameters must not be null", (Object[])new Object[0]);
        Validate.noNullElements(parameters, (String)"parameters must not contains null parameter", (Object[])new Object[0]);
        this.parameters = parameters;
    }

    public void addParameter(DRParameter<?> parameter) {
        Validate.notNull(parameter, (String)"parameter must not be null", (Object[])new Object[0]);
        this.parameters.add(parameter);
    }

    @Override
    public Map<String, Object> getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public void addParameterValue(String name, Object value) {
        Validate.notNull((Object)name, (String)"parameter name must not be null", (Object[])new Object[0]);
        if (this.parameterValues == null) {
            this.parameterValues = new HashMap<String, Object>();
        }
        this.parameterValues.put(name, value);
    }

    @Override
    public List<DRIScriptlet> getScriptlets() {
        return this.scriptlets;
    }

    public void setScriptlets(List<DRIScriptlet> scriptlets) {
        Validate.notNull(scriptlets, (String)"scriptlets must not be null", (Object[])new Object[0]);
        Validate.noNullElements(scriptlets, (String)"scriptlets must not contains null scriptlet", (Object[])new Object[0]);
        this.scriptlets = scriptlets;
    }

    public void addScriptlet(DRIScriptlet scriptlet) {
        Validate.notNull((Object)scriptlet, (String)"scriptlet must not be null", (Object[])new Object[0]);
        this.scriptlets.add(scriptlet);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        Validate.notNull((Object)properties, (String)"properties must not be null", (Object[])new Object[0]);
        this.properties = properties;
    }

    public void addProperty(String key, String value) {
        Validate.notNull((Object)key, (String)"key must not be null", (Object[])new Object[0]);
        this.properties.setProperty(key, value);
    }

    @Override
    public DRQuery getQuery() {
        return this.query;
    }

    public void setQuery(DRQuery query) {
        this.query = query;
    }

    @Override
    public DRPage getPage() {
        return this.page;
    }

    public void setPage(DRPage page) {
        Validate.notNull((Object)page, (String)"page must not be null", (Object[])new Object[0]);
        this.page = page;
    }

    @Override
    public Boolean getIgnorePagination() {
        return this.ignorePagination;
    }

    public void setIgnorePagination(Boolean ignorePagination) {
        this.ignorePagination = ignorePagination;
    }

    @Override
    public WhenNoDataType getWhenNoDataType() {
        return this.whenNoDataType;
    }

    public void setWhenNoDataType(WhenNoDataType whenNoDataType) {
        this.whenNoDataType = whenNoDataType;
    }

    @Override
    public WhenResourceMissingType getWhenResourceMissingType() {
        return this.whenResourceMissingType;
    }

    public void setWhenResourceMissingType(WhenResourceMissingType whenResourceMissingType) {
        this.whenResourceMissingType = whenResourceMissingType;
    }

    @Override
    public Boolean getTitleOnANewPage() {
        return this.titleOnANewPage;
    }

    public void setTitleOnANewPage(Boolean titleOnANewPage) {
        this.titleOnANewPage = titleOnANewPage;
    }

    @Override
    public Boolean getSummaryOnANewPage() {
        return this.summaryOnANewPage;
    }

    public void setSummaryOnANewPage(Boolean summaryOnANewPage) {
        this.summaryOnANewPage = summaryOnANewPage;
    }

    @Override
    public Boolean getSummaryWithPageHeaderAndFooter() {
        return this.summaryWithPageHeaderAndFooter;
    }

    public void setSummaryWithPageHeaderAndFooter(Boolean summaryWithPageHeaderAndFooter) {
        this.summaryWithPageHeaderAndFooter = summaryWithPageHeaderAndFooter;
    }

    @Override
    public Boolean getFloatColumnFooter() {
        return this.floatColumnFooter;
    }

    public void setFloatColumnFooter(Boolean floatColumnFooter) {
        this.floatColumnFooter = floatColumnFooter;
    }

    @Override
    public Orientation getPrintOrder() {
        return this.printOrder;
    }

    public void setPrintOrder(Orientation printOrder) {
        this.printOrder = printOrder;
    }

    @Override
    public RunDirection getColumnDirection() {
        return this.columnDirection;
    }

    public void setColumnDirection(RunDirection columnDirection) {
        this.columnDirection = columnDirection;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public Boolean getUseFieldNameAsDescription() {
        return this.useFieldNameAsDescription;
    }

    public void setUseFieldNameAsDescription(Boolean useFieldNameAsDescription) {
        this.useFieldNameAsDescription = useFieldNameAsDescription;
    }

    @Override
    public DRIFont getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(DRIFont defaultFont) {
        this.defaultFont = defaultFont;
    }

    @Override
    public DRIReportStyle getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(DRIReportStyle textStyle) {
        this.textStyle = textStyle;
    }

    @Override
    public DRIReportStyle getColumnTitleStyle() {
        return this.columnTitleStyle;
    }

    public void setColumnTitleStyle(DRIReportStyle columnTitleStyle) {
        this.columnTitleStyle = columnTitleStyle;
    }

    @Override
    public DRIReportStyle getColumnStyle() {
        return this.columnStyle;
    }

    public void setColumnStyle(DRIReportStyle columnStyle) {
        this.columnStyle = columnStyle;
    }

    @Override
    public DRIReportStyle getGroupTitleStyle() {
        return this.groupTitleStyle;
    }

    public void setGroupTitleStyle(DRIReportStyle groupTitleStyle) {
        this.groupTitleStyle = groupTitleStyle;
    }

    @Override
    public DRIReportStyle getGroupStyle() {
        return this.groupStyle;
    }

    public void setGroupStyle(DRIReportStyle groupStyle) {
        this.groupStyle = groupStyle;
    }

    @Override
    public DRIReportStyle getSubtotalStyle() {
        return this.subtotalStyle;
    }

    public void setSubtotalStyle(DRIReportStyle subtotalStyle) {
        this.subtotalStyle = subtotalStyle;
    }

    @Override
    public DRIReportStyle getImageStyle() {
        return this.imageStyle;
    }

    public void setImageStyle(DRIReportStyle imageStyle) {
        this.imageStyle = imageStyle;
    }

    @Override
    public DRIReportStyle getChartStyle() {
        return this.chartStyle;
    }

    public void setChartStyle(DRIReportStyle chartStyle) {
        this.chartStyle = chartStyle;
    }

    @Override
    public DRIReportStyle getBarcodeStyle() {
        return this.barcodeStyle;
    }

    public void setBarcodeStyle(DRIReportStyle barcodeStyle) {
        this.barcodeStyle = barcodeStyle;
    }

    @Override
    public Boolean getHighlightDetailOddRows() {
        return this.highlightDetailOddRows;
    }

    public void setHighlightDetailOddRows(Boolean highlightDetailOddRows) {
        this.highlightDetailOddRows = highlightDetailOddRows;
    }

    @Override
    public DRSimpleStyle getDetailOddRowStyle() {
        return this.detailOddRowStyle;
    }

    public void setDetailOddRowStyle(DRSimpleStyle detailOddRowStyle) {
        this.detailOddRowStyle = detailOddRowStyle;
    }

    @Override
    public Boolean getHighlightDetailEvenRows() {
        return this.highlightDetailEvenRows;
    }

    public void setHighlightDetailEvenRows(Boolean highlightDetailEvenRows) {
        this.highlightDetailEvenRows = highlightDetailEvenRows;
    }

    @Override
    public DRSimpleStyle getDetailEvenRowStyle() {
        return this.detailEvenRowStyle;
    }

    public void setDetailEvenRowStyle(DRSimpleStyle detailEvenRowStyle) {
        this.detailEvenRowStyle = detailEvenRowStyle;
    }

    public List<DRConditionalStyle> getDetailRowHighlighters() {
        return this.detailRowHighlighters;
    }

    public void setDetailRowHighlighters(List<DRConditionalStyle> detailRowHighlighters) {
        Validate.notNull(detailRowHighlighters, (String)"detailRowHighlighters must not be null", (Object[])new Object[0]);
        Validate.noNullElements(detailRowHighlighters, (String)"detailRowHighlighters must not contains null detailRowHighlighter", (Object[])new Object[0]);
        this.detailRowHighlighters = detailRowHighlighters;
    }

    public void addDetailRowHighlighter(DRConditionalStyle detailRowHighlighter) {
        Validate.notNull((Object)detailRowHighlighter, (String)"detailRowHighlighter must not be null", (Object[])new Object[0]);
        this.detailRowHighlighters.add(detailRowHighlighter);
    }

    @Override
    public DRColumnGrid getColumnGrid() {
        return this.columnGrid;
    }

    public void setColumnGrid(DRColumnGrid columnGrid) {
        this.columnGrid = columnGrid;
    }

    @Override
    public Boolean getTableOfContents() {
        return this.tableOfContents;
    }

    public void setTableOfContents(Boolean tableOfContents) {
        this.tableOfContents = tableOfContents;
    }

    @Override
    public DRITableOfContentsCustomizer getTableOfContentsCustomizer() {
        return this.tableOfContentsCustomizer;
    }

    public void setTableOfContentsCustomizer(DRITableOfContentsCustomizer tableOfContentsCustomizer) {
        this.tableOfContentsCustomizer = tableOfContentsCustomizer;
    }

    @Override
    public DRIExpression<Boolean> getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(DRIExpression<Boolean> filterExpression) {
        this.filterExpression = filterExpression;
    }

    @Override
    public DRBand getTitleBand() {
        return this.titleBand;
    }

    @Override
    public DRBand getPageHeaderBand() {
        return this.pageHeaderBand;
    }

    @Override
    public DRBand getPageFooterBand() {
        return this.pageFooterBand;
    }

    @Override
    public DRBand getColumnHeaderBand() {
        return this.columnHeaderBand;
    }

    @Override
    public DRBand getColumnFooterBand() {
        return this.columnFooterBand;
    }

    @Override
    public DRBand getDetailBand() {
        return this.detailBand;
    }

    @Override
    public DRBand getDetailHeaderBand() {
        return this.detailHeaderBand;
    }

    @Override
    public DRBand getDetailFooterBand() {
        return this.detailFooterBand;
    }

    @Override
    public DRBand getLastPageFooterBand() {
        return this.lastPageFooterBand;
    }

    @Override
    public DRBand getSummaryBand() {
        return this.summaryBand;
    }

    @Override
    public DRBand getNoDataBand() {
        return this.noDataBand;
    }

    @Override
    public DRBand getBackgroundBand() {
        return this.backgroundBand;
    }
}

