/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.base;

import net.sf.dynamicreports.report.ReportUtils;
import net.sf.dynamicreports.report.base.DRGroup;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.Evaluation;
import net.sf.dynamicreports.report.definition.DRIVariable;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public class DRVariable<T>
implements DRIVariable<T> {
    private static final long serialVersionUID = 10000L;
    private String name;
    private DRIExpression<?> valueExpression;
    private DRIExpression<?> initialValueExpression;
    private Calculation calculation;
    private Evaluation resetType;
    private DRGroup resetGroup;

    public DRVariable(DRIExpression<?> valueExpression, Calculation calculation) {
        this(ReportUtils.generateUniqueName("variable"), valueExpression, calculation);
    }

    public DRVariable(String name, DRIExpression<?> valueExpression, Calculation calculation) {
        Validate.notEmpty((CharSequence)name, (String)"name must not be empty", (Object[])new Object[0]);
        Validate.notNull(valueExpression, (String)"valueExpression must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)calculation), (String)"calculation must not be null", (Object[])new Object[0]);
        this.name = name;
        this.valueExpression = valueExpression;
        this.calculation = calculation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DRIExpression<?> getInitialValueExpression() {
        return this.initialValueExpression;
    }

    public void setInitialValueExpression(DRIExpression<?> initialValueExpression) {
        this.initialValueExpression = initialValueExpression;
    }

    @Override
    public Calculation getCalculation() {
        return this.calculation;
    }

    @Override
    public Evaluation getResetType() {
        return this.resetType;
    }

    public void setResetType(Evaluation resetType) {
        this.resetType = resetType;
    }

    @Override
    public DRGroup getResetGroup() {
        return this.resetGroup;
    }

    public void setResetGroup(DRGroup resetGroup) {
        this.resetGroup = resetGroup;
    }

    @Override
    public DRIExpression<?> getValueExpression() {
        return this.valueExpression;
    }

    @Override
    public Class<? super T> getValueClass() {
        return ReportUtils.getVariableValueClass(this.getCalculation(), this.valueExpression.getValueClass());
    }
}

