/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.chart;

import java.awt.Color;
import net.sf.dynamicreports.report.base.chart.DRChart;
import net.sf.dynamicreports.report.base.chart.dataset.DRValueDataset;
import net.sf.dynamicreports.report.base.chart.plot.DRMeterPlot;
import net.sf.dynamicreports.report.base.style.DRFont;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractChartBuilder;
import net.sf.dynamicreports.report.builder.chart.MeterIntervalBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.builder.style.FontBuilder;
import net.sf.dynamicreports.report.constant.ChartType;
import net.sf.dynamicreports.report.constant.MeterShape;
import net.sf.dynamicreports.report.definition.chart.plot.DRIMeterInterval;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public class MeterChartBuilder
extends AbstractChartBuilder<MeterChartBuilder> {
    private static final long serialVersionUID = 10000L;

    protected MeterChartBuilder() {
        super(ChartType.METER);
    }

    public MeterChartBuilder setTheme(String theme) {
        ((DRChart)this.getObject()).setTheme(theme);
        return this;
    }

    public MeterChartBuilder setValue(Number value) {
        this.getDataset().setValueExpression(Expressions.number(value));
        return this;
    }

    public MeterChartBuilder setValue(ValueColumnBuilder<?, ? extends Number> column) {
        Validate.notNull(column, (String)"column must not be null", (Object[])new Object[0]);
        this.getDataset().setValueExpression((DRIExpression)column.getColumn());
        return this;
    }

    public MeterChartBuilder setValue(String fieldName, Class<? extends Number> valueClass) {
        return this.setValue(DynamicReports.field(fieldName, valueClass));
    }

    public MeterChartBuilder setValue(FieldBuilder<? extends Number> field) {
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        this.getDataset().setValueExpression((DRIExpression)field.build());
        return this;
    }

    public MeterChartBuilder setValue(DRIExpression<? extends Number> expression) {
        this.getDataset().setValueExpression(expression);
        return this;
    }

    public MeterChartBuilder setDataRangeLowExpression(Number dataRangeLowValue) {
        this.getPlot().setDataRangeLowExpression(Expressions.number(dataRangeLowValue));
        return this;
    }

    public MeterChartBuilder setDataRangeLowExpression(DRIExpression<? extends Number> dataRangeLowExpression) {
        this.getPlot().setDataRangeLowExpression(dataRangeLowExpression);
        return this;
    }

    public MeterChartBuilder setDataRangeHighExpression(Number dataRangeHighValue) {
        this.getPlot().setDataRangeHighExpression(Expressions.number(dataRangeHighValue));
        return this;
    }

    public MeterChartBuilder setDataRangeHighExpression(DRIExpression<? extends Number> dataRangeHighExpression) {
        this.getPlot().setDataRangeHighExpression(dataRangeHighExpression);
        return this;
    }

    public MeterChartBuilder setValueColor(Color valueColor) {
        this.getPlot().setValueColor(valueColor);
        return this;
    }

    public MeterChartBuilder setValueMask(String valueMask) {
        this.getPlot().setValueMask(valueMask);
        return this;
    }

    public MeterChartBuilder setValueFont(FontBuilder valueFont) {
        Validate.notNull((Object)valueFont, (String)"valueFont must not be null", (Object[])new Object[0]);
        this.getPlot().setValueFont((DRFont)valueFont.build());
        return this;
    }

    public MeterChartBuilder setShape(MeterShape shape) {
        this.getPlot().setShape(shape);
        return this;
    }

    public MeterChartBuilder intervals(MeterIntervalBuilder ... intervals) {
        return this.addInterval(intervals);
    }

    public MeterChartBuilder addInterval(MeterIntervalBuilder ... intervals) {
        Validate.notNull((Object)intervals, (String)"intervals must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])intervals, (String)"intervals must not contains null interval", (Object[])new Object[0]);
        for (MeterIntervalBuilder interval : intervals) {
            this.getPlot().addInterval((DRIMeterInterval)interval.build());
        }
        return this;
    }

    public MeterChartBuilder setMeterAngle(Integer meterAngle) {
        this.getPlot().setMeterAngle(meterAngle);
        return this;
    }

    public MeterChartBuilder setUnits(String units) {
        this.getPlot().setUnits(units);
        return this;
    }

    public MeterChartBuilder setTickInterval(Double tickInterval) {
        this.getPlot().setTickInterval(tickInterval);
        return this;
    }

    public MeterChartBuilder setMeterBackgroundColor(Color meterBackgroundColor) {
        this.getPlot().setMeterBackgroundColor(meterBackgroundColor);
        return this;
    }

    public MeterChartBuilder setNeedleColor(Color needleColor) {
        this.getPlot().setNeedleColor(needleColor);
        return this;
    }

    public MeterChartBuilder setTickColor(Color tickColor) {
        this.getPlot().setTickColor(tickColor);
        return this;
    }

    public MeterChartBuilder setTickLabelFont(FontBuilder tickLabelFont) {
        Validate.notNull((Object)tickLabelFont, (String)"tickLabelFont must not be null", (Object[])new Object[0]);
        this.getPlot().setTickLabelFont((DRFont)tickLabelFont.build());
        return this;
    }

    private DRValueDataset getDataset() {
        return (DRValueDataset)((DRChart)this.getObject()).getDataset();
    }

    private DRMeterPlot getPlot() {
        return (DRMeterPlot)((DRChart)this.getObject()).getPlot();
    }
}

