/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.util.Locale;
import net.sf.jasperreports.components.sort.AbstractFieldComparator;
import net.sf.jasperreports.components.sort.FilterTypeTextOperatorsEnum;
import net.sf.jasperreports.engine.JRRuntimeException;

public class FieldTextComparator
extends AbstractFieldComparator<String> {
    private Locale locale;

    public FieldTextComparator(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void initValues() {
        this.compareStart = this.valueStart;
    }

    @Override
    public boolean compare(String filterTypeOperator) {
        boolean defaultResult;
        boolean result = defaultResult = true;
        try {
            this.initValues();
        }
        catch (Exception e) {
            throw new JRRuntimeException(e);
        }
        FilterTypeTextOperatorsEnum textEnum = FilterTypeTextOperatorsEnum.getByEnumConstantName(filterTypeOperator);
        if (this.compareStart != null) {
            String lcCompareStart = ((String)this.compareStart).toLowerCase(this.locale);
            boolean validComparison = this.compareTo != null;
            String lcCompareTo = validComparison ? ((String)this.compareTo).toLowerCase(this.locale) : null;
            switch (textEnum) {
                case CONTAINS: {
                    result = validComparison ? lcCompareTo.contains(lcCompareStart) : false;
                    break;
                }
                case DOES_NOT_CONTAIN: {
                    result = validComparison ? !lcCompareTo.contains(lcCompareStart) : false;
                    break;
                }
                case DOES_NOT_END_WITH: {
                    result = validComparison ? !lcCompareTo.endsWith(lcCompareStart) : false;
                    break;
                }
                case DOES_NOT_START_WITH: {
                    result = validComparison ? !lcCompareTo.startsWith(lcCompareStart) : false;
                    break;
                }
                case ENDS_WITH: {
                    result = validComparison ? lcCompareTo.endsWith(lcCompareStart) : false;
                    break;
                }
                case EQUALS: {
                    result = validComparison ? lcCompareTo.equals(lcCompareStart) : false;
                    break;
                }
                case IS_NOT_EQUAL_TO: {
                    result = validComparison ? !lcCompareTo.equals(lcCompareStart) : defaultResult;
                    break;
                }
                case STARTS_WITH: {
                    result = validComparison ? lcCompareTo.startsWith(lcCompareStart) : false;
                    break;
                }
                case IS_NULL: {
                    result = !validComparison;
                    break;
                }
                case IS_NOT_NULL: {
                    result = validComparison;
                }
            }
        }
        return result;
    }
}

