/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.HeaderUtil;
import net.lingala.zip4j.headers.HeaderWriter;
import net.lingala.zip4j.io.outputstream.SplitOutputStream;
import net.lingala.zip4j.io.outputstream.ZipOutputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AbstractAddFileToZipTask;
import net.lingala.zip4j.tasks.AbstractZipTaskParameters;
import net.lingala.zip4j.tasks.RemoveEntryFromZipFileTask;
import net.lingala.zip4j.util.Zip4jUtil;

public class AddStreamToZipTask
extends AbstractAddFileToZipTask<AddStreamToZipTaskParameters> {
    public AddStreamToZipTask(ProgressMonitor progressMonitor, boolean runInThread, ZipModel zipModel, char[] password, HeaderWriter headerWriter) {
        super(progressMonitor, runInThread, zipModel, password, headerWriter);
    }

    @Override
    protected void executeTask(AddStreamToZipTaskParameters taskParameters, ProgressMonitor progressMonitor) throws IOException {
        this.verifyZipParameters(taskParameters.zipParameters);
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(taskParameters.zipParameters.getFileNameInZip())) {
            throw new ZipException("fileNameInZip has to be set in zipParameters when adding stream");
        }
        this.removeFileIfExists(this.getZipModel(), taskParameters.charset, taskParameters.zipParameters.getFileNameInZip(), progressMonitor);
        taskParameters.zipParameters.setWriteExtendedLocalFileHeader(true);
        if (taskParameters.zipParameters.getCompressionMethod().equals((Object)CompressionMethod.STORE)) {
            taskParameters.zipParameters.setEntrySize(0L);
        }
        try (SplitOutputStream splitOutputStream = new SplitOutputStream(this.getZipModel().getZipFile(), this.getZipModel().getSplitLength());
             ZipOutputStream zipOutputStream = this.initializeOutputStream(splitOutputStream, taskParameters.charset);){
            FileHeader fileHeader;
            byte[] readBuff = new byte[4096];
            int readLen = -1;
            ZipParameters zipParameters = taskParameters.zipParameters;
            zipOutputStream.putNextEntry(zipParameters);
            if (!zipParameters.getFileNameInZip().endsWith("/") && !zipParameters.getFileNameInZip().endsWith("\\")) {
                while ((readLen = taskParameters.inputStream.read(readBuff)) != -1) {
                    zipOutputStream.write(readBuff, 0, readLen);
                }
            }
            if ((fileHeader = zipOutputStream.closeEntry()).getCompressionMethod().equals((Object)CompressionMethod.STORE)) {
                this.updateLocalFileHeader(fileHeader, splitOutputStream);
            }
        }
    }

    @Override
    protected long calculateTotalWork(AddStreamToZipTaskParameters taskParameters) {
        return 0L;
    }

    private void removeFileIfExists(ZipModel zipModel, Charset charset, String fileNameInZip, ProgressMonitor progressMonitor) throws ZipException {
        FileHeader fileHeader = HeaderUtil.getFileHeader(zipModel, fileNameInZip);
        if (fileHeader != null) {
            RemoveEntryFromZipFileTask removeEntryFromZipFileTask = new RemoveEntryFromZipFileTask(progressMonitor, false, zipModel);
            removeEntryFromZipFileTask.execute(new RemoveEntryFromZipFileTask.RemoveEntryFromZipFileTaskParameters(fileHeader, charset));
        }
    }

    public static class AddStreamToZipTaskParameters
    extends AbstractZipTaskParameters {
        private InputStream inputStream;
        private ZipParameters zipParameters;

        public AddStreamToZipTaskParameters(InputStream inputStream, ZipParameters zipParameters, Charset charset) {
            super(charset);
            this.inputStream = inputStream;
            this.zipParameters = zipParameters;
        }
    }
}

